/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.storage.impl;

import com.huawei.vm.console.storage.impl.CDROMDriver;
import com.huawei.vm.console.utils.ImageIO;
import com.huawei.vm.console.utils.VMException;
import com.kvm.UDFExtendFile;
import com.library.LoggerUtil;
import java.io.IOException;
import java.util.Map;

public class CDROMImage
extends CDROMDriver {
    private ImageIO image = new ImageIO();
    private ImageIO newImage = null;

    public CDROMImage(String path, boolean isMustExist) throws VMException {
        super(path);
        this.mustExist = isMustExist;
        try {
            this.image.open(this.deviceName, this.mustExist);
        }
        catch (IOException e) {
            LoggerUtil.error("Invalid file name");
        }
    }

    @Override
    protected void open(String path) throws VMException {
        try {
            this.image.open(path, this.mustExist);
        }
        catch (IOException e) {
            LoggerUtil.error("Invalid file name");
        }
    }

    @Override
    public void close() throws VMException {
        this.image.close();
    }

    @Override
    public void inquiry() {
    }

    @Override
    public int modeSense(byte[] dataBuffer, int pc, int pageCode) {
        dataBuffer[0] = 0;
        dataBuffer[1] = 6;
        dataBuffer[2] = 0 != this.testUnitReady() ? 1 : 112;
        dataBuffer[3] = 0;
        dataBuffer[4] = 0;
        dataBuffer[5] = 0;
        dataBuffer[6] = 0;
        dataBuffer[7] = 0;
        return 8;
    }

    @Override
    public int read(byte[] dataBuffer, long startPosition, int length) throws VMException {
        return this.image.read(dataBuffer, startPosition, length);
    }

    @Override
    public long getMediumSize() throws VMException {
        long mSize = this.image.getMediumSize();
        if (0L > mSize) {
            throw new VMException(253);
        }
        return mSize;
    }

    @Override
    public void startStopUnit(boolean isEject, boolean isStart) throws VMException {
        if (!isStart && isEject) {
            this.setIsoDiskChanged(true);
            this.setDeviceState(0);
            this.needInit = false;
        } else if (isStart && isEject) {
            this.setDeviceState(3);
            this.needInit = true;
        } else {
            throw new VMException(252);
        }
    }

    @Override
    protected void prepareChangeDisk(String localDirName, Map<Long, UDFExtendFile> memoryStructMap, String diskName) throws VMException {
        this.newImage = new ImageIO();
        try {
            this.newImage.open(diskName, true);
        }
        catch (IOException e) {
            LoggerUtil.error("Invalid file name");
        }
    }

    @Override
    public void eject() {
        try {
            this.deviceName = null;
            this.needInit = false;
            this.close();
        }
        catch (VMException e) {
            LoggerUtil.error(e.getClass().getName());
        }
    }

    @Override
    public void insert() throws VMException {
        if (this.newImage != null) {
            this.image = this.newImage;
            this.newImage = null;
            this.setDeviceState(0);
            this.deviceName = this.newDiskName;
            this.newDiskName = null;
        }
        this.needInit = true;
    }

    @Override
    public boolean preventAllowMediumRemoval(boolean isPrevent) {
        return true;
    }

    @Override
    public boolean isInited() {
        return !this.needInit || this.image.isActive();
    }
}

