/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vm.console.utils;

import com.huawei.vm.console.communication.ProtocolCode;
import com.huawei.vm.console.utils.DataElement;
import com.huawei.vm.console.utils.TestPrint;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class DataArray {
    private final LinkedList<DataElement> linkedList = new LinkedList();
    private final LinkedList<byte[]> bigArrList = new LinkedList();
    private final LinkedList<byte[]> smallArrList = new LinkedList();
    private final int bigArrSize = ProtocolCode.CDROM_PACKET_SIZE + 12 + 20;
    private static final int smallArrSize = 12;
    private int capacity = 256;
    private int elementNumber = 0;
    private int totalNum = 0;
    private int cmdCount = 0;
    private final Object blockLock = new Object();
    private final Object arrBlockLock = new Object();

    public DataArray() {
    }

    public DataArray(int capacity) {
        if (capacity > 0) {
            this.capacity = capacity;
        }
    }

    public void initArrList(int bigArrCap, int smallArrCap) {
        for (int i = 0; i < bigArrCap; ++i) {
            this.bigArrList.addLast(new byte[this.bigArrSize]);
        }
        for (int j = 0; j < smallArrCap; ++j) {
            this.smallArrList.addLast(new byte[12]);
        }
    }

    public DataElement getFirst() {
        DataElement data = null;
        try {
            data = this.linkedList.getFirst();
        }
        catch (NoSuchElementException e) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement getAndRemoveFirst() {
        DataElement data = null;
        try {
            Object object = this.blockLock;
            synchronized (object) {
                data = this.linkedList.removeFirst();
                --this.elementNumber;
            }
        }
        catch (NoSuchElementException e) {
            data = null;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataElement getAndRemoveFirstByBlock() {
        DataElement data = null;
        Object object = this.blockLock;
        synchronized (object) {
            while (true) {
                try {
                    data = this.linkedList.removeFirst();
                    --this.elementNumber;
                }
                catch (NoSuchElementException e) {
                    try {
                        this.blockLock.wait();
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLast(DataElement element) {
        boolean result = false;
        if (this.elementNumber >= this.capacity) {
            result = false;
        } else {
            if (null != element) {
                Object object = this.blockLock;
                synchronized (object) {
                    this.linkedList.addLast(element);
                    ++this.elementNumber;
                    this.blockLock.notifyAll();
                }
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMore(DataElement element) {
        if (null != element) {
            Object object = this.blockLock;
            synchronized (object) {
                this.linkedList.addLast(element);
                ++this.elementNumber;
                this.blockLock.notifyAll();
            }
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getDataNum() {
        return this.linkedList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArr(int arrLen) {
        TestPrint.println(1, Thread.currentThread().getName() + "--Get a arr. Total -" + ++this.totalNum);
        byte[] arr = null;
        Object object = this.arrBlockLock;
        synchronized (object) {
            try {
                arr = 12 < arrLen ? this.bigArrList.removeFirst() : this.smallArrList.removeFirst();
            }
            catch (NoSuchElementException e) {
                arr = 12 < arrLen ? new byte[this.bigArrSize] : new byte[12];
            }
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(byte[] arr) {
        if (null != arr) {
            Object object = this.arrBlockLock;
            synchronized (object) {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = 0;
                }
                if (12 == arr.length) {
                    this.smallArrList.addLast(arr);
                } else if (this.bigArrSize == arr.length) {
                    this.bigArrList.addLast(arr);
                }
            }
        }
    }

    public int getBigArrNum() {
        return this.bigArrList.size();
    }

    public int getSmallArrNum() {
        return this.smallArrList.size();
    }

    public int getElementNumber() {
        return this.elementNumber;
    }

    public void setElementNumber(int elementNumber) {
        this.elementNumber = elementNumber;
    }

    public void setCmdCount(int cmdCount) {
        this.cmdCount = cmdCount;
    }

    public int getCmdCount() {
        return this.cmdCount;
    }
}

