/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.SendIPMIInDiffOS;
import java.util.ArrayList;

class FirmwareRevision {
    public static final String LOAD_SHARE_LIBRARY = "export LD_LIBRARY_PATH=`pwd`";
    public static final String LAN_INTERFACE = "-I lanplus";
    public static final String ACCESS_RIGHT = "-L Operator";
    public static final String IPMI_REQUEST_PARAM = "raw 0x06 0x01";

    FirmwareRevision() {
    }

    public int getRevision(String host, String user_name, String pwdStr, int port) throws Exception {
        int firmwareRevision = -1;
        StringBuffer ipmiOEM = new StringBuffer();
        ipmiOEM.append(LAN_INTERFACE).append(" ").append(ACCESS_RIGHT).append(" ").append("-H").append(" \"").append(host).append("\" ").append("-p").append(" ").append(String.valueOf(port)).append(" ").append("-U").append(" \"").append(user_name).append("\" ").append("-P").append(" \"").append(pwdStr).append("\" ").append(IPMI_REQUEST_PARAM);
        SendIPMIInDiffOS sendIPMIInDiffOS = new SendIPMIInDiffOS();
        if (sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString()) == null) {
            return firmwareRevision;
        }
        String result = sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString());
        if (result == null) {
            return firmwareRevision;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < result.length() - 1; i += 2) {
            list.add(result.substring(i, i + 2));
        }
        int hexVersion = Integer.parseInt((String)list.get(13), 16);
        String binaryStr = Integer.toBinaryString(hexVersion);
        String version = "";
        version = binaryStr.length() > 4 ? binaryStr.substring(0, binaryStr.length() - 4) : "0000";
        firmwareRevision = Integer.parseInt(version, 2);
        return firmwareRevision;
    }
}

