/*
 * Decompiled with CFR 0.152.
 */
package com.kvm;

import com.kvm.LoginUtil;
import com.kvm.SendIPMIInDiffOS;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;

class LoginAuthentication {
    public static final String LOAD_SHARE_LIBRARY = "export LD_LIBRARY_PATH=`pwd`";
    public static final String LAN_INTERFACE = "-I lanplus";
    public static final String ACCESS_RIGHT = "-L Operator";
    public static final String IPMI_REQUEST_PARAM = "raw 0x30 0x94 0xDB 0x07 0x00 0x21 0x06 0x00 0x00 0x37";
    private int keyNumber;
    public static final String IPMI_REQUEST_PARAM_KVM_IBMC = "raw 0x30 0x93 0xDB 0x07 0x00 0x38 0x0a 0x00 0x01 0xff 0x00 0x00 0x01 0x00";
    public static final String IPMI_REQUEST_PARAM_KVM_IMANA = "raw 0x30 0x93 0xDB 0x07 0x00 0x10 0x04 0x02 0x01 0x00 0x00";
    public static final String IPMI_REQUEST_PARAM_VMM_IBMC = "raw 0x30 0x93 0xDB 0x07 0x00 0x38 0x0b 0x00 0x01 0xff 0x00 0x00 0x01 0x00";
    public static final String IPMI_REQUEST_PARAM_VMM_IMANA = "raw 0x30 0x93 0xDB 0x07 0x00 0x10 0x04 0x02 0x02 0x00 0x00";
    public static final String IPMI_REQUEST_PARAM_ENCRY_INFO = "raw 0x30 0x94 0xDB 0x07 0x00 0x20";
    public static final String IPMI_REQUEST_PARAM_OFFSET_LENGTH = "0x00 0xff";

    LoginAuthentication() {
    }

    public int getKeyNumber() {
        return this.keyNumber;
    }

    public void setKeyNumber(int keyNumber) {
        this.keyNumber = keyNumber;
    }

    public String doLoginAuth(String host, String username, String passWord, String KvmMode, int port, LoginUtil loginUtil) throws Exception {
        String returnFlag = "gologin";
        String hexUsername = "";
        String hexKvmMode = "";
        String key = "";
        StringBuffer ipmiOEM = new StringBuffer();
        hexUsername = this.stringToHex(username);
        hexKvmMode = "0x0" + Integer.toHexString(Integer.parseInt(KvmMode));
        byte[] keyByteArray = this.getRandomAndToByteArray();
        StringBuffer keyArray = new StringBuffer();
        for (int i = 0; i < keyByteArray.length; ++i) {
            keyArray.append("0x0").append(keyByteArray[i]).append(" ");
        }
        key = keyArray.toString();
        ipmiOEM.append(ACCESS_RIGHT).append(" ").append("-H").append(" \"").append(host).append("\" ").append("-p").append(" ").append(String.valueOf(port)).append(" ").append(LAN_INTERFACE).append(" ").append("-U").append(" \"").append(username).append("\" ").append("-P").append(" \"").append(passWord).append("\" ").append(IPMI_REQUEST_PARAM).append(" ").append("0x00 0x24 ").append(key).append("0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 ").append("0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 ").append(hexUsername).append("0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 0x00 ").append(hexKvmMode);
        SendIPMIInDiffOS sendIPMIInDiffOS = new SendIPMIInDiffOS();
        if (sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString()) == null) {
            return "gologin";
        }
        String result = sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString());
        if (result != null) {
            returnFlag = "success";
        }
        return returnFlag;
    }

    public String getKVMPort(String host, String username, String passWord, int port, int firmVersion, LoginUtil loginUtil) throws Exception {
        String kvmPort = "fal";
        StringBuffer ipmiOEM = new StringBuffer();
        ipmiOEM.append(LAN_INTERFACE).append(" ").append(ACCESS_RIGHT).append(" ").append("-H").append(" \"").append(host).append("\" ").append("-p").append(" ").append(port).append(" ").append("-U").append(" \"").append(username).append("\" ").append("-P").append(" \"").append(passWord).append("\" ");
        if (firmVersion == 0) {
            ipmiOEM.append(IPMI_REQUEST_PARAM_KVM_IMANA);
        } else if (firmVersion > 0) {
            ipmiOEM.append(IPMI_REQUEST_PARAM_KVM_IBMC);
        }
        SendIPMIInDiffOS sendIPMIInDiffOS = new SendIPMIInDiffOS();
        if (sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString()) == null) {
            return "fal";
        }
        String result = sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString());
        if (result == null) {
            return "fal";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < result.length() - 1; i += 2) {
            list.add(result.substring(i, i + 2));
        }
        StringBuffer portMessage = new StringBuffer();
        if (firmVersion == 0) {
            portMessage.append((String)list.get(list.size() - 1)).append((String)list.get(list.size() - 2));
        } else if (firmVersion > 0) {
            portMessage.append((String)list.get(list.size() - 1)).append((String)list.get(list.size() - 2)).append((String)list.get(list.size() - 3)).append((String)list.get(list.size() - 4));
        }
        Integer temp = Integer.parseInt(portMessage.toString(), 16);
        kvmPort = String.valueOf(temp);
        return kvmPort;
    }

    public String getVMMPort(String host, String username, String passWord, int port, int firmVersion, LoginUtil loginUtil) throws Exception {
        String vmmPort = "fal";
        StringBuffer ipmiOEM = new StringBuffer();
        ipmiOEM.append(LAN_INTERFACE).append(" ").append(ACCESS_RIGHT).append(" ").append("-H").append(" \"").append(host).append("\" ").append("-p").append(" ").append(port).append(" ").append("-U").append(" \"").append(username).append("\" ").append("-P").append(" \"").append(passWord).append("\" ");
        if (firmVersion == 0) {
            ipmiOEM.append(IPMI_REQUEST_PARAM_VMM_IMANA);
        } else if (firmVersion > 0) {
            ipmiOEM.append(IPMI_REQUEST_PARAM_VMM_IBMC);
        }
        SendIPMIInDiffOS sendIPMIInDifOS = new SendIPMIInDiffOS();
        if (sendIPMIInDifOS.useIpmitoolInDiffOS(ipmiOEM.toString()) == null) {
            return "fal";
        }
        String ret = sendIPMIInDifOS.useIpmitoolInDiffOS(ipmiOEM.toString());
        if (ret == null) {
            return "fal";
        }
        ArrayList<String> resList = new ArrayList<String>();
        for (int i = 0; i < ret.length() - 1; i += 2) {
            resList.add(ret.substring(i, i + 2));
        }
        StringBuffer portMessage = new StringBuffer();
        if (firmVersion == 0) {
            portMessage.append((String)resList.get(resList.size() - 1)).append((String)resList.get(resList.size() - 2));
        } else if (firmVersion > 0) {
            portMessage.append((String)resList.get(resList.size() - 1)).append((String)resList.get(resList.size() - 2)).append((String)resList.get(resList.size() - 3)).append((String)resList.get(resList.size() - 4));
        }
        Integer temp = Integer.parseInt(portMessage.toString(), 16);
        vmmPort = String.valueOf(temp);
        return vmmPort;
    }

    public String getEncryInfo(String host, String username, String passWord, int port, String param) throws NumberFormatException, UnsupportedEncodingException, IOException {
        String encryInfo = "fal";
        StringBuffer ipmiOEM = new StringBuffer();
        ipmiOEM.append(LAN_INTERFACE).append(" ").append(ACCESS_RIGHT).append(" ").append("-H").append(" \"").append(host).append("\" ").append("-p").append(" ").append(port).append(" ").append("-U").append(" \"").append(username).append("\" ").append("-P").append(" \"").append(passWord).append("\" ").append(IPMI_REQUEST_PARAM_ENCRY_INFO).append(" ").append(param).append(" ").append(IPMI_REQUEST_PARAM_OFFSET_LENGTH);
        SendIPMIInDiffOS sendIPMIInDiffOS = new SendIPMIInDiffOS();
        if (sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString()) == null) {
            return "fal";
        }
        String result = sendIPMIInDiffOS.useIpmitoolInDiffOS(ipmiOEM.toString());
        if (result == null) {
            return "fal";
        }
        Integer temp = Integer.parseInt(result.substring(result.length() - 2, result.length()), 16);
        encryInfo = String.valueOf(temp);
        return encryInfo;
    }

    private byte[] getRandomAndToByteArray() {
        SecureRandom random = new SecureRandom();
        int temp = random.nextInt(10);
        this.setKeyNumber(temp);
        byte[] byteArray = new byte[4];
        byteArray[3] = (byte)(temp & 0xFF);
        byteArray[2] = (byte)(temp >> 8 & 0xFF);
        byteArray[1] = (byte)(temp >> 16 & 0xFF);
        byteArray[0] = (byte)(temp >> 24 & 0xFF);
        return byteArray;
    }

    private String stringToHex(String str) {
        StringBuffer resultSB = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char cha = str.charAt(i);
            String resultstr = Integer.toHexString(cha);
            resultSB.append("0x").append(resultstr).append(" ");
        }
        String result = resultSB.toString();
        return result;
    }
}

