/*
 * Decompiled with CFR 0.152.
 */
package com.kvmV1;

import com.kvmV1.Base;
import com.kvmV1.BladeCommu;
import com.kvmV1.BladeHeartTimer;
import com.kvmV1.BladeState;
import com.kvmV1.BladeThread;
import com.kvmV1.CCrc;
import com.kvmV1.Client;
import com.kvmV1.Debug;
import com.kvmV1.DrawThread;
import com.kvmV1.FloatPanel;
import com.kvmV1.FloatToolbar;
import com.kvmV1.IManaKVMApplet;
import com.kvmV1.ImagePane;
import com.kvmV1.InterfaceContainer;
import com.kvmV1.KVMException;
import com.kvmV1.KVMInterface;
import com.kvmV1.MouseDisplacementImpl;
import com.kvmV1.PackData;
import com.kvmV1.UnPackData;
import com.kvmV1.VirtualMedia;
import com.newKvm.KeyboardImpl;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KVMUtil {
    public byte[] bladePreInfo = new byte[2];
    public int times = 0;
    public boolean isConn = false;
    public int frame = 0;
    public int tempFrame = 0;
    public byte number = 0;
    public byte tempNumber = 0;
    public boolean tempDiff = false;
    public boolean dispDiff = false;
    public int remoteX = 0;
    public int remoteY = 0;
    public byte colorBit = 0;
    public ArrayList<byte[]> diviBuff = new ArrayList();
    public byte[] imageData = null;
    public static CCrc crc = new CCrc("CRC_16_H");
    public String resourcePath = "com.kvm.resource.KVMResource";
    public boolean resolutionCh = false;
    public boolean firstJudge = true;
    public ArrayList<ImagePane> imagePaneList = new ArrayList();
    public int imageWidth;
    public int imageHeight;
    private boolean diff = false;
    private Object[] bufferA = null;
    private Object[] bufferB = null;
    private int lenA = 0;
    private int lenB = 0;
    public byte nowDisplay = 0;
    public ArrayList<byte[]> resultDivi = new ArrayList();
    private ResourceBundle bundle = null;
    private int packLenght = 0;
    private int packSum = 0;
    private int packTempSum = 0;
    private int packTempLenght = 0;
    private byte[] zipImageData = null;
    private static final String BLADE = "blade";
    private static final int NUM_LOCATION = 4;
    private static final String FAKE_BLADENO = "100";
    private BladeThread bladeThread = null;
    private static final int[][] keyCode = new int[][]{{10, 40}, {8, 42}, {9, 43}, {3, 155}, {12, 156}, {16, 225}, {17, 224}, {18, 226}, {19, 72}, {20, 57}, {27, 41}, {32, 44}, {33, 75}, {34, 78}, {35, 77}, {36, 74}, {37, 80}, {38, 82}, {39, 79}, {40, 81}, {44, 54}, {45, 45}, {46, 55}, {47, 56}, {48, 39}, {49, 30}, {50, 31}, {51, 32}, {52, 33}, {53, 34}, {54, 35}, {55, 36}, {56, 37}, {57, 38}, {192, 53}, {59, 51}, {222, 52}, {61, 46}, {65, 4}, {66, 5}, {67, 6}, {68, 7}, {69, 8}, {70, 9}, {71, 10}, {72, 11}, {73, 12}, {74, 13}, {75, 14}, {76, 15}, {77, 16}, {78, 17}, {79, 18}, {80, 19}, {81, 20}, {82, 21}, {83, 22}, {84, 23}, {85, 24}, {86, 25}, {87, 26}, {88, 27}, {89, 28}, {90, 29}, {96, 98}, {97, 89}, {98, 90}, {99, 91}, {100, 92}, {101, 93}, {102, 94}, {103, 95}, {104, 96}, {105, 97}, {106, 85}, {107, 87}, {109, 86}, {110, 99}, {111, 84}, {127, 76}, {144, 83}, {145, 71}, {112, 58}, {113, 59}, {114, 60}, {115, 61}, {116, 62}, {117, 63}, {118, 64}, {119, 65}, {120, 66}, {121, 67}, {122, 68}, {123, 69}, {154, 70}, {155, 73}, {91, 47}, {92, 49}, {93, 48}};
    private KVMInterface kvmInterface = null;
    public UnPackData unPack = null;
    public int start = 0;
    public int state = 0;
    public int resultStart = 0;
    public int head = 0;
    public int dlen = 0;
    public int rdlen = 0;
    public byte[] result = null;
    public boolean isReqFrame = false;
    public long startTime = 0L;
    private int iWindosFocus = 0;
    public ActionListener taskPerformer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (((KVMUtil)KVMUtil.this).kvmInterface.clientSocket.bladePresentInfo.size() != 0) {
                KVMUtil.this.bladePreInfo = ((KVMUtil)KVMUtil.this).kvmInterface.clientSocket.bladePresentInfo.remove(((KVMUtil)KVMUtil.this).kvmInterface.clientSocket.bladePreIndex);
                Debug.println("blade present info===========");
                Debug.printByte(KVMUtil.this.bladePreInfo);
                KVMUtil.this.isConn = true;
            } else {
                ++KVMUtil.this.times;
            }
        }
    };
    public ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (((KVMUtil)KVMUtil.this).kvmInterface.tabbedpane.getTabCount() > 0) {
                int slotNO;
                ((KVMUtil)KVMUtil.this).kvmInterface.actionBlade = slotNO = ((ImagePane)((KVMUtil)KVMUtil.this).kvmInterface.tabbedpane.getSelectedComponent()).bladeNO;
                ImagePane imagePane = KVMUtil.this.getImagePane(slotNO);
                ((KVMUtil)KVMUtil.this).kvmInterface.tabbedpane.setPreferredSize(new Dimension(imagePane.width + imagePane.getLocation().x, imagePane.height + imagePane.getLocation().y + 5));
                KVMUtil.this.setDrawDisplay(false);
                BladeThread bladeThread = ((KVMUtil)KVMUtil.this).kvmInterface.base.threadGroup.get(String.valueOf(slotNO));
                DrawThread drawThread = bladeThread.getDrawThread();
                drawThread.getKvmUtil().firstJudge = true;
                bladeThread.kvmUtil.resetBuf();
                drawThread.lList.clear();
                drawThread.getComImage().clear();
                drawThread.isDisplay = true;
                bladeThread.kvmUtil.isReqFrame = false;
                bladeThread.bladeCommu.sentData(((KVMUtil)KVMUtil.this).kvmInterface.packData.connectBlade(slotNO, KVMUtil.this.getImagePane((int)slotNO).custBit));
                bladeThread.bladeCommu.sentData(((KVMUtil)KVMUtil.this).kvmInterface.packData.contrRate(35, bladeThread.getBladeNO()));
                if (null != ((KVMUtil)KVMUtil.this).kvmInterface.toolbar.mouseSynButton) {
                    if (bladeThread.isNew()) {
                        if (!((KVMUtil)KVMUtil.this).kvmInterface.base.isMstsc) {
                            ((KVMUtil)KVMUtil.this).kvmInterface.toolbar.mouseSynButton.setEnabled(false);
                        }
                    } else {
                        ((KVMUtil)KVMUtil.this).kvmInterface.toolbar.mouseSynButton.setEnabled(true);
                    }
                }
                imagePane.kvmInterface.floatToolbar.setLocation((imagePane.kvmInterface.floatToolbar.imgwidth - imagePane.kvmInterface.floatToolbar.getWidth()) / 2, -1);
                imagePane.kvmInterface.floatToolbar.setVisible(true);
                if (imagePane.kvmInterface.floatToolbar.isVirtualMedia()) {
                    imagePane.kvmInterface.floatToolbar.setFlpLocation((imagePane.kvmInterface.floatToolbar.imgwidth - imagePane.kvmInterface.floatToolbar.getFlpWidth()) / 2, imagePane.kvmInterface.floatToolbar.getHeight() - 1);
                    imagePane.kvmInterface.floatToolbar.setCDLocation((imagePane.kvmInterface.floatToolbar.imgwidth - imagePane.kvmInterface.floatToolbar.getCDWidth()) / 2, imagePane.kvmInterface.floatToolbar.getHeight() - 1);
                }
            }
        }
    };
    private static String osType = "";
    private static String osArch = "";

    public BladeThread getBladeThread() {
        return this.bladeThread;
    }

    public int getiWindosFocus() {
        return this.iWindosFocus;
    }

    public void setiWindosFocus(int iWindosFocus) {
        this.iWindosFocus = iWindosFocus;
    }

    public void setKvmInterface(KVMInterface kvmInterface) {
        this.kvmInterface = kvmInterface;
    }

    public KVMInterface getKvmInterface() {
        return this.kvmInterface;
    }

    public void setUnPack(UnPackData unPack) {
        this.unPack = unPack;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public static int javaCodeToUSB(KeyEvent e) {
        int temp = 0;
        int keyValue = 0;
        keyValue = e.getKeyLocation() == 4 && KVMUtil.numKey(e) != 0 ? KVMUtil.numKey(e) : e.getKeyCode();
        for (int i = 0; i < keyCode.length; ++i) {
            if (keyCode[i][0] != keyValue) continue;
            temp = keyCode[i][1];
        }
        return temp;
    }

    private static int numKey(KeyEvent e) {
        int keyValue = 0;
        switch (e.getKeyCode()) {
            case 155: {
                keyValue = 96;
                break;
            }
            case 127: {
                keyValue = 110;
                break;
            }
            case 35: {
                keyValue = 97;
                break;
            }
            case 40: 
            case 225: {
                keyValue = 98;
                break;
            }
            case 34: {
                keyValue = 99;
                break;
            }
            case 37: 
            case 226: {
                keyValue = 100;
                break;
            }
            case 12: {
                keyValue = 101;
                break;
            }
            case 39: 
            case 227: {
                keyValue = 102;
                break;
            }
            case 36: {
                keyValue = 103;
                break;
            }
            case 38: 
            case 224: {
                keyValue = 104;
                break;
            }
            case 33: {
                keyValue = 105;
                break;
            }
            default: {
                keyValue = 0;
            }
        }
        return keyValue;
    }

    public static int javaCodeToUSB(int keycode) {
        int temp = 0;
        for (int i = 0; i < keyCode.length; ++i) {
            if (keyCode[i][0] != keycode) continue;
            temp = keyCode[i][1];
        }
        return temp;
    }

    public static int usbToJavaCode(int USBCode) {
        int temp = 0;
        for (int i = 0; i < keyCode.length; ++i) {
            if (keyCode[i][1] != USBCode) continue;
            temp = keyCode[i][0];
        }
        return temp;
    }

    public static int byteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    public static int byteToIntCon(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        try {
            for (int i = offset; i <= offset + length - 1; ++i) {
                intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            intdes = 0;
        }
        return intdes;
    }

    public static void intToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void intToByteCon(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 3] = (byte)intsrc;
        bytedest[offset + 2] = (byte)(intsrc >> 8);
        bytedest[offset + 1] = (byte)(intsrc >> 16);
        bytedest[offset + 0] = (byte)(intsrc >> 24);
    }

    public static void perIntToByteCon(byte[] bytedest, int offset, byte[] bytesrc) {
        int count = bytesrc.length / 4;
        int t_offset = 0;
        for (int i = 0; i < count; ++i) {
            t_offset = offset + i * 4;
            bytedest[t_offset + 3] = bytesrc[i * 4 + 0];
            bytedest[t_offset + 2] = bytesrc[i * 4 + 1];
            bytedest[t_offset + 1] = bytesrc[i * 4 + 2];
            bytedest[t_offset + 0] = bytesrc[i * 4 + 3];
        }
    }

    public static byte[] intToByte_ret(int intsrc) {
        byte[] bytedest = new byte[]{(byte)intsrc, (byte)(intsrc >> 8), (byte)(intsrc >> 16), (byte)(intsrc >> 24)};
        return bytedest;
    }

    public static int[] perBitToInt(byte bytesrc) {
        int[] intdes = new int[8];
        int mask = 1;
        for (int i = 0; i < 8; ++i) {
            intdes[i] = (bytesrc & mask) == mask ? 1 : 0;
            mask *= 2;
        }
        return intdes;
    }

    public JButton createBladeButton(int bladeNO) {
        String imagesRes = "resource/images/blade1.gif";
        imagesRes = "resource/images/blade" + bladeNO + ".gif";
        JButton blade = new JButton(new ImageIcon(this.getClass().getResource(imagesRes.trim())));
        return blade;
    }

    public static void translate(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            byte red = data[i];
            byte green = data[i];
            byte blue = data[i];
            red = (byte)(red << 6 & 0xC0);
            green = (byte)(green << 1 & 0x38);
            blue = (byte)(blue >>> 5 & 6);
            data[i] = (byte)(red | green | blue);
        }
    }

    private void swap() {
        Object[] C = this.bufferA = null;
        this.bufferA = this.bufferB;
        this.bufferB = C;
        this.frame = this.tempFrame;
        this.number = this.tempNumber;
        this.packLenght = this.packTempLenght;
        this.packSum = this.packTempSum;
        this.diff = this.tempDiff;
        this.tempFrame = 0;
        this.tempNumber = 0;
        this.packTempLenght = 0;
        this.packTempSum = 0;
        this.tempDiff = false;
    }

    public static void doSort(LinkedList<byte[]> list) {
        for (int i = 0; i < list.size(); ++i) {
            byte[] bytesA = list.get(i);
            int tempA = KVMUtil.byteToIntCon(bytesA, 0, 2);
            int lSize = list.size();
            for (int j = i + 1; j < lSize; ++j) {
                byte[] bytesB = list.get(j);
                int tempB = KVMUtil.byteToIntCon(bytesB, 0, 2);
                if (tempA <= tempB) continue;
                byte[] tmp = bytesA;
                bytesA = bytesB;
                bytesB = tmp;
                list.set(i, bytesA);
                list.set(j, bytesB);
                tempA = tempB;
            }
        }
    }

    public byte[] combine(Object[] list, boolean judge) {
        int i;
        int length = 0;
        int index = 1;
        length = judge ? this.packLenght + 1 : this.packTempLenght + 1;
        byte[] data = new byte[length];
        byte[] buf = (byte[])list[0];
        int[] temp = KVMUtil.perBitToInt(buf[7]);
        byte k = (byte)temp[7];
        StringBuffer tem = new StringBuffer();
        for (i = 6; i >= 0; --i) {
            tem.append(temp[i]);
        }
        temp = KVMUtil.perBitToInt(buf[8]);
        for (i = 7; i >= 0; --i) {
            tem.append(temp[i]);
        }
        if (this.imageWidth != Integer.parseInt(tem.toString(), 2) || this.imageHeight != KVMUtil.byteToIntCon(buf, 9, 2)) {
            this.imageWidth = Integer.parseInt(tem.toString(), 2);
            this.imageHeight = KVMUtil.byteToIntCon(buf, 9, 2);
            this.resolutionCh = true;
        }
        if (!this.kvmInterface.base.isDiv) {
            this.remoteX = KVMUtil.byteToIntCon(buf, 12, 2);
            this.remoteY = KVMUtil.byteToIntCon(buf, 14, 2);
        }
        this.colorBit = buf[16];
        data[0] = k;
        for (i = 1; i < list.length; ++i) {
            byte[] bytes0 = (byte[])list[i];
            int temLen = bytes0.length - 3;
            System.arraycopy(bytes0, 3, data, index, temLen);
            index += temLen;
        }
        return data;
    }

    public boolean xorData(byte[] dataA, byte[] dataB) {
        boolean flage = false;
        if (dataA.length != dataB.length) {
            Debug.printExc("dataA = " + dataA.length + " dataB = " + dataB.length);
        } else {
            int len = dataB.length;
            for (int i = 0; i < len; ++i) {
                dataB[i] = (byte)(dataA[i] ^ dataB[i]);
            }
            flage = true;
        }
        return flage;
    }

    private void setVar(byte[] bytes, boolean prem) {
        block9: {
            if (prem) {
                this.frame = KVMUtil.byteToIntCon(bytes, 0, 2);
                this.number = bytes[2];
                this.packLenght = KVMUtil.byteToIntCon(bytes, 3, 4);
                this.lenA = this.packLenght / 220 + 1;
                if (this.packLenght % 220 != 0) {
                    ++this.lenA;
                }
                this.bufferA = new Object[this.lenA];
                try {
                    int[] temp = KVMUtil.perBitToInt(bytes[7]);
                    if (1 == temp[7]) {
                        this.diff = true;
                        break block9;
                    }
                    this.diff = false;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.diff = false;
                }
            } else {
                this.tempFrame = KVMUtil.byteToIntCon(bytes, 0, 2);
                this.tempNumber = bytes[2];
                this.packTempLenght = KVMUtil.byteToIntCon(bytes, 3, 4);
                this.lenB = this.packTempLenght / 220 + 1;
                if (this.packTempLenght % 220 != 0) {
                    ++this.lenB;
                }
                this.bufferB = new Object[this.lenB];
                try {
                    int[] temp = KVMUtil.perBitToInt(bytes[7]);
                    this.tempDiff = 1 == temp[7];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.tempDiff = false;
                }
            }
        }
    }

    public void resetBuf() {
        this.bufferA = null;
        this.bufferB = null;
        this.packLenght = 0;
        this.packSum = 0;
        this.packTempLenght = 0;
        this.packTempSum = 0;
        this.frame = 0;
        this.tempFrame = 0;
        this.diff = false;
        this.tempDiff = false;
    }

    private void sentIFrame(int bladeNo, BladeCommu bladeCommu) {
        Debug.println("I frame request...");
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.startTime > 500L) {
            bladeCommu.sentData(this.kvmInterface.packData.resendData(bladeNo));
            this.startTime = 0L;
        }
    }

    private boolean setPremBuffer(int bladeNo, BladeCommu bladeCommu) {
        boolean flage = false;
        if (this.diff) {
            if (this.firstJudge) {
                this.sentIFrame(bladeNo, bladeCommu);
                this.resetBuf();
                return flage;
            }
            if ((byte)(this.nowDisplay + 1) == this.number) {
                this.zipImageData = this.combine(this.bufferA, true);
                this.nowDisplay = this.number;
                this.dispDiff = this.diff;
                this.swap();
                flage = true;
            } else {
                this.resetBuf();
                Debug.println("buffA discontinuity this = " + this.number + " nowDisplay =  " + this.nowDisplay);
                this.sentIFrame(bladeNo, bladeCommu);
            }
        } else {
            this.zipImageData = this.combine(this.bufferA, true);
            this.nowDisplay = this.number;
            this.dispDiff = this.diff;
            this.swap();
            if (this.firstJudge) {
                this.firstJudge = false;
            }
            this.isReqFrame = false;
            flage = true;
        }
        return flage;
    }

    private boolean setMinorBuffer(byte[] bytes, int bladeNo, BladeCommu bladeCommu) {
        boolean judge = false;
        if (this.bufferB != null) {
            if (this.tempNumber == bytes[2]) {
                int tem = KVMUtil.byteToIntCon(bytes, 0, 2);
                if (tem >= this.lenB) {
                    this.resetBuf();
                    this.sentIFrame(bladeNo, bladeCommu);
                    return false;
                }
                if (this.bufferB[tem] == null) {
                    this.bufferB[tem] = bytes;
                    this.packTempSum += bytes.length - 3;
                } else {
                    byte[] old = (byte[])this.bufferB[tem];
                    if (!Arrays.equals(old, bytes)) {
                        Debug.println("Number is equals, but data no!");
                        this.resetBuf();
                        this.sentIFrame(bladeNo, bladeCommu);
                        return false;
                    }
                }
                if (this.packTempSum == this.packTempLenght) {
                    if (this.tempDiff) {
                        if (this.firstJudge) {
                            this.sentIFrame(bladeNo, bladeCommu);
                            this.resetBuf();
                            return false;
                        }
                        if ((byte)(this.nowDisplay + 1) == this.tempNumber) {
                            this.zipImageData = this.combine(this.bufferB, false);
                            this.nowDisplay = this.tempNumber;
                            this.dispDiff = this.tempDiff;
                            this.resetBuf();
                            judge = true;
                        } else {
                            this.resetBuf();
                            this.sentIFrame(bladeNo, bladeCommu);
                        }
                    } else {
                        this.zipImageData = this.combine(this.bufferB, false);
                        this.nowDisplay = this.tempNumber;
                        this.dispDiff = this.tempDiff;
                        this.resetBuf();
                        if (this.firstJudge) {
                            this.firstJudge = false;
                        }
                        this.isReqFrame = false;
                        judge = true;
                    }
                }
            } else {
                this.resetBuf();
                this.sentIFrame(bladeNo, bladeCommu);
                Debug.println("third image");
            }
        } else if (KVMUtil.byteToIntCon(bytes, 0, 2) == 0) {
            this.setVar(bytes, false);
            this.bufferB[0] = bytes;
        } else {
            this.sentIFrame(bladeNo, bladeCommu);
        }
        return judge;
    }

    public boolean isComplete(byte[] bytes, int bladeNo) {
        BladeThread bladeThread = this.kvmInterface.base.threadGroup.get(String.valueOf(bladeNo));
        if (bladeThread == null) {
            return false;
        }
        BladeCommu bladeCommu = bladeThread.bladeCommu;
        boolean isComp = false;
        if (this.bufferA != null) {
            if (this.number == bytes[2]) {
                int tem = KVMUtil.byteToIntCon(bytes, 0, 2);
                if (tem >= this.lenA) {
                    this.resetBuf();
                    Debug.println("bufferA outof!!!");
                    this.sentIFrame(bladeNo, bladeCommu);
                    return false;
                }
                if (this.bufferA[tem] == null) {
                    this.bufferA[tem] = bytes;
                    this.packSum += bytes.length - 3;
                } else {
                    byte[] old = (byte[])this.bufferA[tem];
                    if (!Arrays.equals(old, bytes)) {
                        Debug.println("Number is equals, but data no!");
                        this.resetBuf();
                        this.sentIFrame(bladeNo, bladeCommu);
                        return false;
                    }
                }
                isComp = this.packSum == this.packLenght ? this.setPremBuffer(bladeNo, bladeCommu) : false;
            } else {
                isComp = this.setMinorBuffer(bytes, bladeNo, bladeCommu);
            }
        } else {
            if (KVMUtil.byteToIntCon(bytes, 0, 2) == 0) {
                this.setVar(bytes, true);
                this.bufferA[0] = bytes;
            } else if (this.nowDisplay < bytes[2]) {
                int tem = bytes[2] - this.nowDisplay;
                if (tem < 128 && tem > 0) {
                    Debug.println("bufferA isn't head nowDisplay = " + this.nowDisplay + "bytes = " + bytes[2]);
                    this.sentIFrame(bladeNo, bladeCommu);
                }
            } else {
                int tem = this.nowDisplay - bytes[2];
                if (tem >= 128 || tem < 0) {
                    Debug.println("bufferA isn't head nowDisplay = " + this.nowDisplay + "bytes = " + bytes[2]);
                    this.sentIFrame(bladeNo, bladeCommu);
                }
            }
            isComp = false;
        }
        return isComp;
    }

    public byte[] getZipImageData() throws KVMException {
        if (this.zipImageData != null) {
            return this.zipImageData;
        }
        throw new KVMException("zipImageData is null");
    }

    public byte[] unZipData(byte[] bytes) throws KVMException {
        int pixNumber = this.imageWidth * this.imageHeight;
        if (this.imageData.length != pixNumber) {
            this.imageData = new byte[pixNumber];
        }
        int countNum = 0;
        int temLength = 0;
        int bytesLenght = bytes.length;
        boolean flagRem = false;
        byte bufColor = 0;
        block14: for (int i = 1; i < bytesLenght; i += temLength) {
            int j;
            int size22;
            int extendNum22;
            int j2;
            int size18;
            int extendNum18;
            int j3;
            int size10;
            int extendNum10;
            int size6;
            int j4;
            int jend;
            int tem;
            if (flagRem) {
                if (i + 1 >= bytesLenght) {
                    return null;
                }
                bufColor = (byte)(bytes[i] | bytes[i + 1] >>> 4 & 0xF);
                tem = (byte)(bytes[i + 1] & 0xF);
                if (tem != 0) {
                    int temInt = tem;
                    if (temInt + countNum > pixNumber) {
                        temInt = pixNumber - countNum;
                    }
                    jend = temInt + countNum;
                    for (j4 = countNum; j4 < jend; ++j4) {
                        this.imageData[j4] = bufColor;
                    }
                    countNum = jend;
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    temLength = 2;
                    if (bytesLenght == i + 3) {
                        temLength = 3;
                    }
                    flagRem = false;
                    continue;
                }
                if (i + 2 >= bytesLenght) {
                    return null;
                }
                switch (bytes[i + 2] & 0xC0) {
                    case 0: {
                        if (i + 2 >= bytesLenght) {
                            return null;
                        }
                        int extendNum6 = bytes[i + 2] & 0x3F;
                        size6 = countNum + extendNum6;
                        if (size6 > pixNumber) {
                            size6 = pixNumber;
                        }
                        for (j4 = countNum; j4 < size6; ++j4) {
                            this.imageData[j4] = bufColor;
                        }
                        countNum = size6;
                        if (countNum == pixNumber) {
                            return this.imageData;
                        }
                        temLength = 3;
                        if (bytesLenght == i + 4) {
                            temLength = 4;
                        }
                        flagRem = false;
                        break;
                    }
                    case 64: {
                        if (i + 3 >= bytesLenght) {
                            return null;
                        }
                        extendNum10 = (bytes[i + 2] << 4 & 0x3F0) + (bytes[i + 3] >>> 4 & 0xF);
                        size10 = countNum + extendNum10;
                        if (size10 > pixNumber) {
                            size10 = pixNumber;
                        }
                        for (j3 = countNum; j3 < size10; ++j3) {
                            this.imageData[j3] = bufColor;
                        }
                        countNum = size10;
                        if (countNum == pixNumber) {
                            return this.imageData;
                        }
                        temLength = 3;
                        if (bytesLenght == i + 4) {
                            temLength = 4;
                            break;
                        }
                        if (i + 3 >= bytesLenght) {
                            return null;
                        }
                        bytes[i + 3] = (byte)(bytes[i + 3] << 4);
                        flagRem = true;
                        break;
                    }
                    case 128: {
                        if (i + 4 >= bytesLenght) {
                            return null;
                        }
                        extendNum18 = (bytes[i + 2] << 12 & 0x3F000) + (bytes[i + 3] << 4 & 0xFF0) + (bytes[i + 4] >>> 4 & 0xF);
                        size18 = countNum + extendNum18;
                        if (size18 > pixNumber) {
                            size18 = pixNumber;
                        }
                        for (j2 = countNum; j2 < size18; ++j2) {
                            this.imageData[j2] = bufColor;
                        }
                        countNum = size18;
                        if (countNum == pixNumber) {
                            return this.imageData;
                        }
                        temLength = 4;
                        if (bytesLenght == i + 5) {
                            temLength = 5;
                            break;
                        }
                        if (i + 4 >= bytesLenght) {
                            return null;
                        }
                        bytes[i + 4] = (byte)(bytes[i + 4] << 4);
                        flagRem = true;
                        break;
                    }
                    case 192: {
                        if (i + 4 >= bytesLenght) {
                            return null;
                        }
                        extendNum22 = (bytes[i + 2] << 16 & 0x3F0000) + (bytes[i + 3] << 8 & 0xFF00) + (bytes[i + 4] & 0xFF);
                        size22 = countNum + extendNum22;
                        if (size22 > pixNumber) {
                            size22 = pixNumber;
                        }
                        for (j = countNum; j < size22; ++j) {
                            this.imageData[j] = bufColor;
                        }
                        countNum = size22;
                        if (countNum == pixNumber) {
                            return this.imageData;
                        }
                        temLength = 5;
                        if (bytesLenght == i + 6) {
                            temLength = 6;
                        }
                        flagRem = false;
                        break;
                    }
                    default: {
                        throw new KVMException("imagedata error");
                    }
                }
                continue;
            }
            bufColor = bytes[i];
            tem = 0;
            try {
                if (i + 1 >= bytesLenght) {
                    return null;
                }
                tem = bytes[i + 1] >>> 4 & 0xF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                Debug.println("i = " + i);
            }
            if (tem != 0) {
                int temInt = tem;
                if (temInt + countNum > pixNumber) {
                    temInt = pixNumber - countNum;
                }
                jend = temInt + countNum;
                for (j4 = countNum; j4 < jend; ++j4) {
                    this.imageData[j4] = bufColor;
                }
                countNum = jend;
                if (countNum == pixNumber) {
                    return this.imageData;
                }
                temLength = 1;
                if (bytesLenght == i + 2) {
                    temLength = 2;
                    continue;
                }
                if (i + 1 >= bytesLenght) {
                    return null;
                }
                bytes[i + 1] = (byte)(bytes[i + 1] << 4);
                flagRem = true;
                continue;
            }
            if (i + 1 >= bytesLenght) {
                return null;
            }
            switch (bytes[i + 1] & 0xC) {
                case 0: {
                    if (i + 2 >= bytesLenght) {
                        return null;
                    }
                    int extendNum6 = (bytes[i + 1] << 4 & 0x30) + (bytes[i + 2] >>> 4 & 0xF);
                    size6 = countNum + extendNum6;
                    if (size6 > pixNumber) {
                        size6 = pixNumber;
                    }
                    for (j4 = countNum; j4 < size6; ++j4) {
                        this.imageData[j4] = bufColor;
                    }
                    countNum = size6;
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    temLength = 2;
                    if (bytesLenght == i + 3) {
                        temLength = 3;
                        continue block14;
                    }
                    if (i + 2 >= bytesLenght) {
                        return null;
                    }
                    bytes[i + 2] = (byte)(bytes[i + 2] << 4);
                    flagRem = true;
                    continue block14;
                }
                case 4: {
                    if (i + 2 >= bytesLenght) {
                        return null;
                    }
                    extendNum10 = (bytes[i + 1] << 8 & 0x300) + (bytes[i + 2] & 0xFF);
                    size10 = countNum + extendNum10;
                    if (size10 > pixNumber) {
                        size10 = pixNumber;
                    }
                    for (j3 = countNum; j3 < size10; ++j3) {
                        this.imageData[j3] = bufColor;
                    }
                    countNum = size10;
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    temLength = 3;
                    if (bytesLenght == i + 4) {
                        temLength = 4;
                    }
                    flagRem = false;
                    continue block14;
                }
                case 8: {
                    if (i + 3 >= bytesLenght) {
                        return null;
                    }
                    extendNum18 = (bytes[i + 1] << 16 & 0x30000) + (bytes[i + 2] << 8 & 0xFF00) + (bytes[i + 3] & 0xFF);
                    size18 = countNum + extendNum18;
                    if (size18 > pixNumber) {
                        size18 = pixNumber;
                    }
                    for (j2 = countNum; j2 < size18; ++j2) {
                        this.imageData[j2] = bufColor;
                    }
                    countNum = size18;
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    temLength = 4;
                    if (bytesLenght == i + 5) {
                        temLength = 5;
                    }
                    flagRem = false;
                    continue block14;
                }
                case 12: {
                    if (i + 4 >= bytesLenght) {
                        return null;
                    }
                    extendNum22 = (bytes[i + 1] << 20 & 0x300000) + (bytes[i + 2] << 12 & 0xFF000) + (bytes[i + 3] << 4 & 0xFF0) + (bytes[i + 4] >>> 4 & 0xF);
                    size22 = countNum + extendNum22;
                    if (size22 > pixNumber) {
                        size22 = pixNumber;
                    }
                    for (j = countNum; j < size22; ++j) {
                        this.imageData[j] = bufColor;
                    }
                    countNum = size22;
                    if (countNum == pixNumber) {
                        return this.imageData;
                    }
                    temLength = 4;
                    if (bytesLenght == i + 5) {
                        temLength = 5;
                        continue block14;
                    }
                    if (i + 4 >= bytesLenght) {
                        return null;
                    }
                    bytes[i + 4] = (byte)(bytes[i + 4] << 4);
                    flagRem = true;
                    continue block14;
                }
                default: {
                    throw new KVMException("imagedata error");
                }
            }
        }
        countNum = 0;
        return this.imageData;
    }

    public static int[][] transform(byte[] bytes) {
        int[][] bgrData = new int[bytes.length][3];
        for (int i = 0; i < bytes.length; ++i) {
            bgrData[i][0] = (bgrData[i][0] << 8) + (bytes[i] & 0xC0);
            bgrData[i][1] = (bgrData[i][1] << 8) + (bytes[i] & 0x38) << 2;
            bgrData[i][2] = (bgrData[i][2] << 8) + (bytes[i] & 7) << 5;
        }
        return bgrData;
    }

    public ArrayList<byte[]> diviStream(byte[] bytes, byte period1, byte period2) {
        if ("UDP".equals(IManaKVMApplet.protocol)) {
            this.resultDivi.clear();
            byte[] data = null;
            int packageLen = bytes.length;
            int dataLen = packageLen - 4;
            byte[] crcData = new byte[dataLen - 2];
            System.arraycopy(bytes, 6, crcData, 0, dataLen - 2);
            int returnCheck = crc.wCrc((short)0, crcData, (short)(dataLen - 2));
            byte[] tem = new byte[4];
            KVMUtil.intToByte(tem, 0, returnCheck);
            if (tem[0] == bytes[5] && tem[1] == bytes[4]) {
                block9: {
                    if (bytes[6] == 2 || bytes[6] == 4) {
                        try {
                            this.kvmInterface.client.sentData(this.kvmInterface.packData.replayToSMM(bytes[7], bytes[1]));
                        }
                        catch (KVMException e) {
                            if (!"IO_ERRCODE".equals(e.getErrCode())) break block9;
                            JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("Network_interrupt_message"));
                        }
                    }
                }
                data = new byte[packageLen - 2];
                System.arraycopy(bytes, 2, data, 0, packageLen - 2);
                this.resultDivi.add(data);
            } else {
                Debug.printByte(bytes);
            }
        }
        if ("TCP".equals(IManaKVMApplet.protocol)) {
            if (this.diviBuff.size() == 0) {
                this.resultDivi = this.doDivi(bytes, period1, period2);
            } else {
                byte[] temp = this.diviBuff.remove(0);
                byte[] data = new byte[temp.length + bytes.length];
                System.arraycopy(temp, 0, data, 0, temp.length);
                System.arraycopy(bytes, 0, data, temp.length, bytes.length);
                this.resultDivi = this.doDivi(data, period1, period2);
            }
        }
        return this.resultDivi;
    }

    private ArrayList<byte[]> doDivi(byte[] bytes, byte period1, byte period2) {
        ArrayList<byte[]> resultDo = new ArrayList<byte[]>();
        if (bytes.length < 3) {
            this.diviBuff.clear();
            this.diviBuff.add(bytes);
            return resultDo;
        }
        int start = 0;
        byte[] tem = new byte[4];
        byte[] lenData = new byte[2];
        boolean flag = false;
        for (int j = 0; j < bytes.length; ++j) {
            if (bytes.length - start < 3) {
                byte[] remBytes = new byte[bytes.length - start];
                System.arraycopy(bytes, start, remBytes, 0, remBytes.length);
                this.diviBuff.add(remBytes);
                return resultDo;
            }
            if (bytes[j] != period1 || bytes[j + 1] != period2 || bytes[j + 2] != 0 || j >= bytes.length) continue;
            int i = start = j;
            while (i < bytes.length) {
                if (bytes.length >= start + 4) {
                    lenData[0] = bytes[start + 2];
                    lenData[1] = bytes[start + 3];
                    int expectLen = KVMUtil.byteToIntCon(lenData, 0, 2);
                    if (bytes.length - start - 4 >= expectLen) {
                        if (expectLen < 2) {
                            this.diviBuff.clear();
                            j = start = start + 4 + expectLen;
                            flag = false;
                            break;
                        }
                        byte[] crcData = new byte[expectLen - 2];
                        System.arraycopy(bytes, start + 6, crcData, 0, crcData.length);
                        int returnCheck = crc.wCrc((short)0, crcData, (short)crcData.length);
                        KVMUtil.intToByte(tem, 0, returnCheck);
                        i = start + expectLen + 4;
                        if (tem[0] == bytes[start + 5] && tem[1] == bytes[start + 4]) {
                            byte[] data = new byte[expectLen + 2];
                            System.arraycopy(bytes, start + 2, data, 0, data.length);
                            resultDo.add(data);
                            j = start = i;
                            if (i == bytes.length - 1) {
                                flag = false;
                                continue;
                            }
                            flag = true;
                            continue;
                        }
                        this.diviBuff.clear();
                        j = start = i;
                        flag = false;
                        continue;
                    }
                    j = bytes.length;
                    flag = true;
                    break;
                }
                j = bytes.length;
                flag = true;
                break;
            }
            if (!flag) continue;
            byte[] temp = new byte[bytes.length - start];
            System.arraycopy(bytes, start, temp, 0, temp.length);
            this.diviBuff.clear();
            this.diviBuff.add(temp);
        }
        return resultDo;
    }

    public ArrayList<byte[]> diviStreamNew(byte[] bytes, byte period1, byte period2) {
        if (this.diviBuff.size() == 0) {
            this.resultDivi = this.doDiviNew(bytes, period1, period2);
        } else {
            byte[] temp = this.diviBuff.get(0);
            byte[] data = new byte[temp.length + bytes.length];
            System.arraycopy(temp, 0, data, 0, temp.length);
            System.arraycopy(bytes, 0, data, temp.length, bytes.length);
            this.resultDivi = this.doDiviNew(data, period1, period2);
        }
        return this.resultDivi;
    }

    private ArrayList<byte[]> doDiviNew(byte[] bytes, byte period1, byte period2) {
        ArrayList<byte[]> resultDo = new ArrayList<byte[]>();
        if (bytes.length < 3) {
            this.diviBuff.clear();
            this.diviBuff.add(bytes);
            return resultDo;
        }
        int start = 0;
        byte[] lenData = new byte[2];
        boolean flag = false;
        for (int j = 0; j < bytes.length; ++j) {
            if (bytes.length - start < 3) {
                byte[] remBytes = new byte[bytes.length - start];
                System.arraycopy(bytes, start, remBytes, 0, remBytes.length);
                this.diviBuff.add(remBytes);
                return resultDo;
            }
            if (bytes[j] != period1 || bytes[j + 1] != period2 || bytes[j + 2] != 0 || j >= bytes.length) continue;
            int i = start;
            while (i < bytes.length) {
                if (bytes.length >= start + 4) {
                    lenData[0] = bytes[start + 2];
                    lenData[1] = bytes[start + 3];
                    int expectLen = KVMUtil.byteToIntCon(lenData, 0, 2);
                    if (bytes.length - start - 4 >= expectLen) {
                        if (expectLen < 3) {
                            this.diviBuff.clear();
                            j = start = start + 4 + expectLen;
                            flag = false;
                            break;
                        }
                        i = start + expectLen + 4;
                        byte[] data = new byte[expectLen + 2];
                        System.arraycopy(bytes, start + 2, data, 0, data.length);
                        resultDo.add(data);
                        j = start = i;
                        if (i == bytes.length - 1) {
                            flag = false;
                            continue;
                        }
                        flag = true;
                        continue;
                    }
                    j = bytes.length;
                    flag = true;
                    break;
                }
                j = bytes.length;
                flag = true;
                break;
            }
            if (!flag) continue;
            byte[] temp = new byte[bytes.length - start];
            System.arraycopy(bytes, start, temp, 0, temp.length);
            this.diviBuff.clear();
            this.diviBuff.add(temp);
        }
        return resultDo;
    }

    public boolean diviStreamNew(byte[] bytes, boolean isNew) {
        block7: while (this.start < bytes.length) {
            switch (this.state) {
                case 0: {
                    this.head <<= 8;
                    this.head += bytes[this.start++] & 0xFF;
                    if ((this.head & 0xFFFFFF) != 16709120) continue block7;
                    this.state = 1;
                    continue block7;
                }
                case 1: {
                    this.dlen = bytes[this.start++] & 0xFF;
                    if (this.dlen < 3 || this.dlen > 250) {
                        this.state = 0;
                        this.head = this.dlen;
                        continue block7;
                    }
                    this.rdlen = 0;
                    this.resultStart = 0;
                    this.result = new byte[this.dlen];
                    this.state = 2;
                    continue block7;
                }
                case 2: {
                    try {
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.result[this.resultStart++] = bytes[this.start++];
                    ++this.rdlen;
                    if (this.rdlen < this.dlen) continue block7;
                    this.state = 0;
                    this.head = 0;
                    return true;
                }
            }
            this.state = 0;
            this.head = 0;
        }
        return false;
    }

    public String getString(String key) {
        String value = null;
        try {
            value = this.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            Debug.println("java.util.MissingResourceException: Couldn't find value for: " + key);
        }
        if (value == null) {
            value = "Could not find resource: " + key + "  ";
        }
        return value;
    }

    public ResourceBundle getResourceBundle() {
        if (this.bundle == null) {
            this.bundle = "en".equalsIgnoreCase(Base.local) ? ResourceBundle.getBundle(this.resourcePath, new Locale("en"), ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES)) : ResourceBundle.getBundle(this.resourcePath, new Locale("zh"), ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
        }
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void setNumAndCapLock() {
        byte numAndCapLock = 0;
        int bladeNo = 0;
        bladeNo = !this.kvmInterface.isFullScreen ? this.kvmInterface.actionBlade : this.kvmInterface.fullScreen.actionBlade;
        try {
            BladeThread bladeThread = this.kvmInterface.base.threadGroup.get(String.valueOf(bladeNo));
            numAndCapLock = bladeThread.keyState.get(String.valueOf(bladeNo));
        }
        catch (Exception e) {
            Debug.printExc(e.getMessage());
        }
        int[] lock = KVMUtil.perBitToInt(numAndCapLock);
        this.setNumKeyColor(lock[0]);
        this.setCapsKeyColor(lock[1]);
        this.setScrollKeyColor(lock[2]);
        ImagePane imagePane = this.getImagePane(bladeNo);
        if (imagePane != null) {
            imagePane.setCaps(lock[1]);
            imagePane.setNum(lock[0]);
            imagePane.setScroll(lock[2]);
        }
    }

    public void setNumKeyColor(int lock) {
        if (lock == 1) {
            if (!this.kvmInterface.isFullScreen) {
                this.kvmInterface.toolbar.NumColor = Base.LIGHT_ON;
                this.kvmInterface.toolbar.numColorButton.setBackground(this.kvmInterface.toolbar.NumColor);
            } else if (this.kvmInterface.fullScreen.toolBar != null) {
                this.kvmInterface.fullScreen.toolBar.numColor = Base.LIGHT_ON;
                this.kvmInterface.fullScreen.toolBar.numColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.numColor);
            }
        } else if (!this.kvmInterface.isFullScreen) {
            this.kvmInterface.toolbar.NumColor = Base.LIGHT_OFF;
            this.kvmInterface.toolbar.numColorButton.setBackground(this.kvmInterface.toolbar.NumColor);
        } else if (this.kvmInterface.fullScreen.toolBar != null) {
            this.kvmInterface.fullScreen.toolBar.numColor = Base.LIGHT_OFF;
            this.kvmInterface.fullScreen.toolBar.numColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.numColor);
        }
    }

    public void setCapsKeyColor(int lock) {
        if (lock == 1) {
            if (!this.kvmInterface.isFullScreen) {
                this.kvmInterface.toolbar.CapsColor = Base.LIGHT_ON;
                this.kvmInterface.toolbar.capsColorButton.setBackground(this.kvmInterface.toolbar.CapsColor);
            } else if (this.kvmInterface.fullScreen.toolBar != null) {
                this.kvmInterface.fullScreen.toolBar.capsColor = Base.LIGHT_ON;
                this.kvmInterface.fullScreen.toolBar.capsColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.capsColor);
            }
        } else if (!this.kvmInterface.isFullScreen) {
            this.kvmInterface.toolbar.CapsColor = Base.LIGHT_OFF;
            this.kvmInterface.toolbar.capsColorButton.setBackground(this.kvmInterface.toolbar.CapsColor);
        } else if (this.kvmInterface.fullScreen.toolBar != null) {
            this.kvmInterface.fullScreen.toolBar.capsColor = Base.LIGHT_OFF;
            this.kvmInterface.fullScreen.toolBar.capsColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.capsColor);
        }
    }

    public void setScrollKeyColor(int lock) {
        if (lock == 1) {
            if (!this.kvmInterface.isFullScreen) {
                this.kvmInterface.toolbar.ScrollColor = Base.LIGHT_ON;
                this.kvmInterface.toolbar.scrollColorButton.setBackground(this.kvmInterface.toolbar.ScrollColor);
            } else if (this.kvmInterface.fullScreen.toolBar != null) {
                this.kvmInterface.fullScreen.toolBar.scrollColor = Base.LIGHT_ON;
                this.kvmInterface.fullScreen.toolBar.scrollColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.scrollColor);
            }
        } else if (!this.kvmInterface.isFullScreen) {
            this.kvmInterface.toolbar.ScrollColor = Base.LIGHT_OFF;
            this.kvmInterface.toolbar.scrollColorButton.setBackground(this.kvmInterface.toolbar.ScrollColor);
        } else if (this.kvmInterface.fullScreen.toolBar != null) {
            this.kvmInterface.fullScreen.toolBar.scrollColor = Base.LIGHT_OFF;
            this.kvmInterface.fullScreen.toolBar.scrollColorButton.setBackground(this.kvmInterface.fullScreen.toolBar.scrollColor);
        }
    }

    public FloatToolbar getImageFloatToolbar(int bladeNO) {
        FloatToolbar floatKoobar = null;
        InterfaceContainer iContainer = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            floatKoobar = iContainer.getFloatToolbar();
        }
        return floatKoobar;
    }

    public ImagePane getNewImagePane(int bladeNO) {
        return this.kvmInterface.createImagPanePanel(bladeNO);
    }

    public ImagePane getNewImagePane1(int bladeNO) {
        ImagePane imagePane = null;
        InterfaceContainer iContainer = null;
        VirtualMedia virtualMedia = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            imagePane = iContainer.getImagePane();
            if (iContainer.getBladeNO() != bladeNO || imagePane != null && (imagePane == null || imagePane.bladeNO != 0)) continue;
            if (Base.connMode == 0) {
                virtualMedia = new VirtualMedia(Base.local, this.kvmInterface);
                virtualMedia.setStrIP(Base.vmmConnIP);
                virtualMedia.setCodeKey(Base.vmmCodeKey);
                virtualMedia.setPort(Base.vmmPort);
                iContainer.setVirtualMedia(virtualMedia);
            }
            imagePane = new ImagePane(this.kvmInterface);
            FloatToolbar floatToolbar = new FloatToolbar(imagePane, virtualMedia, this.kvmInterface);
            floatToolbar.setVirtualMedia(virtualMedia);
            iContainer.setImagePane(imagePane);
            iContainer.setKvmInterface(this.kvmInterface);
            iContainer.setFloatToolbar(floatToolbar);
            this.kvmInterface.floatToolbar = iContainer.getFloatToolbar();
            break;
        }
        return imagePane;
    }

    public ImagePane getImagePane(int bladeNO) {
        ImagePane imagePane = null;
        InterfaceContainer iContainer = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            imagePane = iContainer.getImagePane();
            if (iContainer.getBladeNO() != bladeNO || imagePane == null || imagePane.bladeNO != bladeNO) continue;
            this.kvmInterface.floatToolbar = iContainer.getFloatToolbar();
            return imagePane;
        }
        return null;
    }

    public boolean getSecretKVM(int bladeNO) {
        InterfaceContainer iContainer = null;
        boolean isSecretKVM = false;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            return iContainer.getSecretKVM();
        }
        return isSecretKVM;
    }

    public boolean getSecretVMM(int bladeNO) {
        InterfaceContainer iContainer = null;
        boolean isSecretVMM = false;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            return iContainer.getSecretVMM();
        }
        return isSecretVMM;
    }

    public boolean getAuthVMM(int bladeNO) {
        InterfaceContainer iContainer = null;
        boolean isAuthVMM = true;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            return iContainer.getAuthVMM();
        }
        return isAuthVMM;
    }

    public void setVMMSecretCodeKey(int bladeNO, byte[] codeKey) {
        InterfaceContainer iContainer = null;
        VirtualMedia virtualMedia = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            virtualMedia = iContainer.getVirtualMedia();
            virtualMedia.setNegotiCodeKey(codeKey);
        }
    }

    public void setVMMSecretSalt(int bladeNO, byte[] salt) {
        InterfaceContainer iContainer = null;
        VirtualMedia virtualMedia = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            virtualMedia = iContainer.getVirtualMedia();
            virtualMedia.setNegotiSalt(salt);
        }
    }

    public int getImagePaneCodeKey(int bladeNO) {
        int imagePaneCodeKey = 0;
        InterfaceContainer iContainer = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            imagePaneCodeKey = iContainer.getCodeKey();
            return imagePaneCodeKey;
        }
        return imagePaneCodeKey;
    }

    public byte[] getImagePaneCodeKey_bytes(int bladeNO) {
        BladeThread bThread;
        int imagePaneCodeKey = 0;
        InterfaceContainer iContainer = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            imagePaneCodeKey = iContainer.getCodeKey();
            break;
        }
        return (bThread = this.kvmInterface.base.threadGroup.get(String.valueOf(bladeNO))) != null && bThread.getEncrytedStatus() ? Base.getSessionID() : KVMUtil.intToByte_ret(imagePaneCodeKey);
    }

    public byte[] getImagePaneCodeKey_bytes(int bladeNO, BladeThread bThread) {
        int imagePaneCodeKey = 0;
        InterfaceContainer iContainer = null;
        for (int i = 0; i < this.kvmInterface.bladeList.size(); ++i) {
            iContainer = this.kvmInterface.bladeList.get(i);
            if (iContainer.getBladeNO() != bladeNO) continue;
            imagePaneCodeKey = iContainer.getCodeKey();
            break;
        }
        return bThread != null && bThread.getEncrytedStatus() ? Base.getSessionID() : KVMUtil.intToByte_ret(imagePaneCodeKey);
    }

    public byte[] getSMMCodeKey_bytes() {
        return Base.securekvm ? Base.getSessionID() : KVMUtil.intToByte_ret(this.kvmInterface.codeKey);
    }

    public ImagePane getImagePane_bak(int bladeNO) {
        if (bladeNO == 0) {
            if (this.kvmInterface.imagePane1 == null) {
                this.kvmInterface.imagePane1 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane1;
            }
            if (this.kvmInterface.imagePane1.bladeNO == 0) {
                this.kvmInterface.imagePane1 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane1;
            }
            if (this.kvmInterface.imagePane2 == null) {
                this.kvmInterface.imagePane2 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane2;
            }
            if (this.kvmInterface.imagePane2.bladeNO == 0) {
                this.kvmInterface.imagePane2 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane2;
            }
            if (this.kvmInterface.imagePane3 == null) {
                this.kvmInterface.imagePane3 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane3;
            }
            if (this.kvmInterface.imagePane3.bladeNO == 0) {
                this.kvmInterface.imagePane3 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane3;
            }
            if (this.kvmInterface.imagePane4 == null) {
                this.kvmInterface.imagePane4 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane4;
            }
            if (this.kvmInterface.imagePane4.bladeNO == 0) {
                this.kvmInterface.imagePane4 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane4;
            }
            if (this.kvmInterface.imagePane5 == null) {
                this.kvmInterface.imagePane5 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane5;
            }
            if (this.kvmInterface.imagePane5.bladeNO == 0) {
                this.kvmInterface.imagePane5 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane5;
            }
            if (this.kvmInterface.imagePane6 == null) {
                this.kvmInterface.imagePane6 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane6;
            }
            if (this.kvmInterface.imagePane6.bladeNO == 0) {
                this.kvmInterface.imagePane6 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane6;
            }
            if (this.kvmInterface.imagePane7 == null) {
                this.kvmInterface.imagePane7 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane7;
            }
            if (this.kvmInterface.imagePane7.bladeNO == 0) {
                this.kvmInterface.imagePane7 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane7;
            }
            if (this.kvmInterface.imagePane8 == null) {
                this.kvmInterface.imagePane8 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane8;
            }
            if (this.kvmInterface.imagePane8.bladeNO == 0) {
                this.kvmInterface.imagePane8 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane8;
            }
            if (this.kvmInterface.imagePane9 == null) {
                this.kvmInterface.imagePane9 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane9;
            }
            if (this.kvmInterface.imagePane9.bladeNO == 0) {
                this.kvmInterface.imagePane9 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane9;
            }
            if (this.kvmInterface.imagePane10 == null) {
                this.kvmInterface.imagePane10 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane10;
            }
            if (this.kvmInterface.imagePane10.bladeNO == 0) {
                this.kvmInterface.imagePane10 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane10;
            }
            if (this.kvmInterface.imagePane11 == null) {
                this.kvmInterface.imagePane11 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane11;
            }
            if (this.kvmInterface.imagePane11.bladeNO == 0) {
                this.kvmInterface.imagePane11 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane11;
            }
            if (this.kvmInterface.imagePane12 == null) {
                this.kvmInterface.imagePane12 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane12;
            }
            if (this.kvmInterface.imagePane12.bladeNO == 0) {
                this.kvmInterface.imagePane12 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane12;
            }
            if (this.kvmInterface.imagePane13 == null) {
                this.kvmInterface.imagePane13 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane13;
            }
            if (this.kvmInterface.imagePane13.bladeNO == 0) {
                this.kvmInterface.imagePane13 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane13;
            }
            if (this.kvmInterface.imagePane14 == null) {
                this.kvmInterface.imagePane14 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane14;
            }
            if (this.kvmInterface.imagePane14.bladeNO == 0) {
                this.kvmInterface.imagePane14 = new ImagePane(this.kvmInterface);
                return this.kvmInterface.imagePane14;
            }
        } else {
            if (this.kvmInterface.imagePane1 != null && this.kvmInterface.imagePane1.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane1;
            }
            if (this.kvmInterface.imagePane2 != null && this.kvmInterface.imagePane2.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane2;
            }
            if (this.kvmInterface.imagePane3 != null && this.kvmInterface.imagePane3.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane3;
            }
            if (this.kvmInterface.imagePane4 != null && this.kvmInterface.imagePane4.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane4;
            }
            if (this.kvmInterface.imagePane5 != null && this.kvmInterface.imagePane5.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane5;
            }
            if (this.kvmInterface.imagePane6 != null && this.kvmInterface.imagePane6.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane6;
            }
            if (this.kvmInterface.imagePane7 != null && this.kvmInterface.imagePane7.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane7;
            }
            if (this.kvmInterface.imagePane8 != null && this.kvmInterface.imagePane8.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane8;
            }
            if (this.kvmInterface.imagePane9 != null && this.kvmInterface.imagePane9.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane9;
            }
            if (this.kvmInterface.imagePane10 != null && this.kvmInterface.imagePane10.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane10;
            }
            if (this.kvmInterface.imagePane11 != null && this.kvmInterface.imagePane11.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane11;
            }
            if (this.kvmInterface.imagePane12 != null && this.kvmInterface.imagePane12.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane12;
            }
            if (this.kvmInterface.imagePane13 != null && this.kvmInterface.imagePane13.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane13;
            }
            if (this.kvmInterface.imagePane14 != null && this.kvmInterface.imagePane14.bladeNO == bladeNO) {
                return this.kvmInterface.imagePane14;
            }
        }
        return null;
    }

    public void setBladeButton() throws KVMException {
        if (this.kvmInterface.toolbar.dynamicBlade) {
            int bladeSize = this.kvmInterface.bladeList.size();
            for (int i = 0; i < bladeSize; ++i) {
                JButton blade = this.kvmInterface.bladeList.get(i).getBladeButton();
                if (blade == null) continue;
                if (this.bladePreInfo[i] == 1 || this.bladePreInfo[i] == 7 || this.bladePreInfo[i] == 15 || this.bladePreInfo[i] == 23 || this.bladePreInfo[i] == 31) {
                    blade.setEnabled(true);
                    blade.addMouseListener(this.bladeMouseListener(true));
                } else {
                    blade.setEnabled(false);
                    blade.addMouseListener(this.bladeMouseListener(false));
                }
                blade.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5), BorderFactory.createLineBorder(Color.WHITE)));
            }
        }
    }

    public void setBladeEnable() {
        int[] temp1 = KVMUtil.perBitToInt(this.bladePreInfo[0]);
        int[] temp2 = KVMUtil.perBitToInt(this.bladePreInfo[1]);
        int[] PresentInfo = new int[14];
        System.arraycopy(temp1, 1, PresentInfo, 0, 7);
        System.arraycopy(temp2, 0, PresentInfo, 7, 7);
        if (this.kvmInterface.toolbar.dynamicBlade) {
            int bladeSize = this.kvmInterface.bladeList.size();
            for (int i = 0; i < bladeSize; ++i) {
                JButton blade = this.kvmInterface.bladeList.get(i).getBladeButton();
                if (blade == null) continue;
                if (PresentInfo[i] == 1 && this.kvmInterface.base.threadGroup.get(String.valueOf(i + 1)) == null) {
                    blade.setEnabled(true);
                    blade.addMouseListener(this.bladeMouseListener(true));
                } else {
                    blade.setEnabled(false);
                    blade.addMouseListener(this.bladeMouseListener(false));
                }
                blade.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5), BorderFactory.createLineBorder(Color.WHITE)));
            }
        }
    }

    public void arrayImagePane() {
        this.imagePaneList.clear();
        this.imagePaneList.add(this.kvmInterface.imagePane1);
        this.imagePaneList.add(this.kvmInterface.imagePane2);
        this.imagePaneList.add(this.kvmInterface.imagePane3);
        this.imagePaneList.add(this.kvmInterface.imagePane4);
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                ImagePane imaPane1 = this.imagePaneList.get(i);
                ImagePane imaPane2 = this.imagePaneList.get(j);
                if (imaPane1.bladeNO <= imaPane2.bladeNO) continue;
                ImagePane tem = imaPane1;
                this.imagePaneList.set(i, imaPane2);
                this.imagePaneList.set(j, tem);
            }
        }
    }

    public void setImageTipText(boolean isShow) {
        if (isShow) {
            if (this.kvmInterface.imagePane1 != null && this.kvmInterface.imagePane1.bladeNO != 0) {
                this.kvmInterface.imagePane1.setToolTipText(BLADE + this.kvmInterface.imagePane1.bladeNO);
            }
            if (this.kvmInterface.imagePane2 != null && this.kvmInterface.imagePane2.bladeNO != 0) {
                this.kvmInterface.imagePane2.setToolTipText(BLADE + this.kvmInterface.imagePane2.bladeNO);
            }
            if (this.kvmInterface.imagePane3 != null && this.kvmInterface.imagePane3.bladeNO != 0) {
                this.kvmInterface.imagePane3.setToolTipText(BLADE + this.kvmInterface.imagePane3.bladeNO);
            }
            if (this.kvmInterface.imagePane4 != null && this.kvmInterface.imagePane4.bladeNO != 0) {
                this.kvmInterface.imagePane4.setToolTipText(BLADE + this.kvmInterface.imagePane4.bladeNO);
            }
            if (this.kvmInterface.imagePane5 != null && this.kvmInterface.imagePane5.bladeNO != 0) {
                this.kvmInterface.imagePane5.setToolTipText(BLADE + this.kvmInterface.imagePane5.bladeNO);
            }
            if (this.kvmInterface.imagePane6 != null && this.kvmInterface.imagePane6.bladeNO != 0) {
                this.kvmInterface.imagePane6.setToolTipText(BLADE + this.kvmInterface.imagePane6.bladeNO);
            }
            if (this.kvmInterface.imagePane7 != null && this.kvmInterface.imagePane7.bladeNO != 0) {
                this.kvmInterface.imagePane7.setToolTipText(BLADE + this.kvmInterface.imagePane7.bladeNO);
            }
            if (this.kvmInterface.imagePane8 != null && this.kvmInterface.imagePane8.bladeNO != 0) {
                this.kvmInterface.imagePane8.setToolTipText(BLADE + this.kvmInterface.imagePane8.bladeNO);
            }
            if (this.kvmInterface.imagePane9 != null && this.kvmInterface.imagePane9.bladeNO != 0) {
                this.kvmInterface.imagePane9.setToolTipText(BLADE + this.kvmInterface.imagePane9.bladeNO);
            }
            if (this.kvmInterface.imagePane10 != null && this.kvmInterface.imagePane10.bladeNO != 0) {
                this.kvmInterface.imagePane10.setToolTipText(BLADE + this.kvmInterface.imagePane10.bladeNO);
            }
            if (this.kvmInterface.imagePane11 != null && this.kvmInterface.imagePane11.bladeNO != 0) {
                this.kvmInterface.imagePane11.setToolTipText(BLADE + this.kvmInterface.imagePane11.bladeNO);
            }
            if (this.kvmInterface.imagePane12 != null && this.kvmInterface.imagePane12.bladeNO != 0) {
                this.kvmInterface.imagePane12.setToolTipText(BLADE + this.kvmInterface.imagePane12.bladeNO);
            }
            if (this.kvmInterface.imagePane13 != null && this.kvmInterface.imagePane13.bladeNO != 0) {
                this.kvmInterface.imagePane13.setToolTipText(BLADE + this.kvmInterface.imagePane13.bladeNO);
            }
            if (this.kvmInterface.imagePane14 != null && this.kvmInterface.imagePane14.bladeNO != 0) {
                this.kvmInterface.imagePane14.setToolTipText(BLADE + this.kvmInterface.imagePane14.bladeNO);
            }
        } else {
            if (this.kvmInterface.imagePane1 != null) {
                this.kvmInterface.imagePane1.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane2 != null) {
                this.kvmInterface.imagePane2.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane3 != null) {
                this.kvmInterface.imagePane3.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane4 != null) {
                this.kvmInterface.imagePane4.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane5 != null) {
                this.kvmInterface.imagePane5.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane6 != null) {
                this.kvmInterface.imagePane6.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane7 != null) {
                this.kvmInterface.imagePane7.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane8 != null) {
                this.kvmInterface.imagePane8.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane9 != null) {
                this.kvmInterface.imagePane9.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane10 != null) {
                this.kvmInterface.imagePane10.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane11 != null) {
                this.kvmInterface.imagePane11.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane12 != null) {
                this.kvmInterface.imagePane12.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane13 != null) {
                this.kvmInterface.imagePane13.setToolTipText(null);
            }
            if (this.kvmInterface.imagePane14 != null) {
                this.kvmInterface.imagePane14.setToolTipText(null);
            }
        }
    }

    public void setDrawDisplay(boolean isDisplay) {
        Iterator<String> iter = this.kvmInterface.base.threadGroup.keySet().iterator();
        String name = "";
        if (isDisplay) {
            while (iter.hasNext()) {
                name = iter.next();
                BladeThread bladeThread = this.kvmInterface.base.threadGroup.get(name);
                bladeThread.getDrawThread().isDisplay = isDisplay;
                bladeThread.bladeCommu.sentData(this.kvmInterface.packData.contrRate(1, bladeThread.getBladeNO()));
            }
        } else {
            while (iter.hasNext()) {
                name = iter.next();
                BladeThread bladeThread = this.kvmInterface.base.threadGroup.get(name);
                bladeThread.getDrawThread().isDisplay = isDisplay;
                bladeThread.bladeCommu.sentData(this.kvmInterface.packData.contrRate(0, bladeThread.getBladeNO()));
            }
        }
    }

    public BladeState getBladeStateAuto(int bladeNO, String bladeIP, byte[] stateBytes) {
        BladeState bladeState = new BladeState();
        int[] state = KVMUtil.perBitToInt(stateBytes[1]);
        if (state[2] == 1) {
            bladeState.setEnable(false);
        } else {
            bladeState = this.showBladeAbsent(stateBytes, bladeNO, 10);
        }
        return bladeState;
    }

    public BladeState getBladeState(int bladeNO) throws KVMException {
        BladeState bladeState;
        block12: {
            bladeState = new BladeState();
            this.kvmInterface.clientSocket.bladeStateInfo.remove(String.valueOf(bladeNO));
            try {
                this.kvmInterface.client.sentData(this.kvmInterface.packData.reqBladeState(bladeNO, Base.connMode));
            }
            catch (KVMException e) {
                if ("IO_ERRCODE".equals(e.getErrCode())) {
                    JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("Network_interrupt_message"));
                }
                throw new KVMException();
            }
            for (int count = 0; count < 15; ++count) {
                int[] state;
                byte[] stateBytes;
                if (this.kvmInterface.clientSocket.bladeStateInfo.get(String.valueOf(bladeNO)) == null && this.kvmInterface.clientSocket.bladeStateInfo.get(FAKE_BLADENO) == null) {
                    Debug.println(BLADE + bladeNO + " = " + count);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Debug.printExc(e.getMessage());
                    }
                    continue;
                }
                if (this.kvmInterface.clientSocket.bladeStateInfo.get(String.valueOf(bladeNO)) != null) {
                    stateBytes = this.kvmInterface.clientSocket.bladeStateInfo.remove(String.valueOf(bladeNO));
                    state = KVMUtil.perBitToInt(stateBytes[1]);
                    if (state[2] == 1) {
                        JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("BMC_reset_message"));
                        bladeState.setEnable(false);
                    } else {
                        bladeState = this.showBladeAbsent(stateBytes, bladeNO, 0);
                    }
                    this.setCodeKey(stateBytes[stateBytes.length - 1], bladeNO);
                }
                if (this.kvmInterface.clientSocket.bladeStateInfo.get(FAKE_BLADENO) == null) break block12;
                stateBytes = this.kvmInterface.clientSocket.bladeStateInfo.remove(String.valueOf(FAKE_BLADENO));
                state = KVMUtil.perBitToInt(stateBytes[1]);
                if (state[2] == 1) {
                    JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("BMC_reset_message"));
                    bladeState.setEnable(false);
                } else {
                    bladeState = this.showBladeAbsent(stateBytes, bladeNO, 0);
                }
                break block12;
            }
            JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("timeout"));
        }
        return bladeState;
    }

    private BladeState showBladeAbsent(byte[] bytes, int bladeNO, int count) {
        BladeState bladeState = new BladeState();
        if (bytes[0] == 100) {
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("SMMMaxContrConnection"));
            }
            return bladeState;
        }
        int[] state = KVMUtil.perBitToInt(bytes[1]);
        if (state[7] == 0) {
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("Absent"));
            }
        } else {
            bladeState = this.showBladeDown(state, bladeNO, bytes, count);
        }
        return bladeState;
    }

    private BladeState showBladeDown(int[] state, int bladeNO, byte[] bytes, int count) {
        BladeState bladeState = new BladeState();
        if (state[5] == 0) {
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("nonsupportKVM"));
            }
        } else if (state[4] == 1) {
            if (state[3] == 0) {
                int tem1 = bytes[3];
                int tem2 = bytes[4];
                int tem3 = bytes[5];
                int tem4 = bytes[6];
                if (bytes[3] < 0) {
                    tem1 = 256 + bytes[3];
                }
                if (bytes[4] < 0) {
                    tem2 = 256 + bytes[4];
                }
                if (bytes[5] < 0) {
                    tem3 = 256 + bytes[5];
                }
                if (bytes[6] < 0) {
                    tem4 = 256 + bytes[6];
                }
                String point = ".";
                StringBuffer strBuf = new StringBuffer("");
                strBuf.append(tem1);
                strBuf.append(point);
                strBuf.append(tem2);
                strBuf.append(point);
                strBuf.append(tem3);
                strBuf.append(point);
                strBuf.append(tem4);
                String bladeIP = strBuf.toString();
                if (Base.connMode == 1) {
                    String bladeIP1 = this.kvmInterface.client.address.getHostAddress();
                    if (bladeIP != null && !bladeIP.equals(bladeIP1)) {
                        bladeIP = bladeIP1;
                    }
                }
                int bladePort = KVMUtil.byteToIntCon(bytes, 7, 2);
                bladeState.setBladeIP(bladeIP);
                bladeState.setBladePort(bladePort);
                bladeState.setEnable(true);
                bladeState.setNew(true);
                return bladeState;
            }
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("KVM_now"));
                bladeState.setEnable(false);
                return bladeState;
            }
        } else {
            String bladeIP = this.kvmInterface.client.address.getHostAddress();
            int bladePort = KVMUtil.byteToIntCon(bytes, 7, 2);
            bladeState.setBladeIP(bladeIP);
            bladeState.setBladePort(bladePort);
            bladeState.setNew(false);
            bladeState.setEnable(this.showBladeBusy(state, bladeNO, bytes, count));
        }
        return bladeState;
    }

    private boolean showBladeBusy(int[] state, int bladeNO, byte[] bytes, int count) {
        boolean connectEnable = false;
        if (state[2] == 0 && state[1] == 0 && state[0] == 1) {
            if (bytes[2] >= 4) {
                if (count <= 0) {
                    JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("over_bladeconnect"));
                }
            } else {
                int tem1 = bytes[3];
                int tem2 = bytes[4];
                int tem3 = bytes[5];
                int tem4 = bytes[6];
                if (bytes[3] < 0) {
                    tem1 = 256 + bytes[3];
                }
                if (bytes[4] < 0) {
                    tem2 = 256 + bytes[4];
                }
                if (bytes[5] < 0) {
                    tem3 = 256 + bytes[5];
                }
                if (bytes[6] < 0) {
                    tem4 = 256 + bytes[6];
                }
                String point = ".";
                StringBuffer strBuf = new StringBuffer("(");
                strBuf.append(tem1);
                strBuf.append(point);
                strBuf.append(tem2);
                strBuf.append(point);
                strBuf.append(tem3);
                strBuf.append(point);
                strBuf.append(tem4);
                strBuf.append(")");
                StringBuffer nameBuf = new StringBuffer("");
                for (int i = 0; i < 16; ++i) {
                    nameBuf.append((char)bytes[7 + i]);
                }
                if (count <= 0) {
                    JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("KVM_now"));
                }
            }
        } else if (state[2] == 0 && state[1] == 1 && state[0] == 0) {
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("SOL_now"));
            }
        } else {
            connectEnable = this.showBladeFileLoad(state, count);
        }
        return connectEnable;
    }

    private boolean showBladeFileLoad(int[] state, int count) {
        boolean connectEnable = false;
        if (state[2] == 0 && state[1] == 1 && state[0] == 1) {
            if (count <= 0) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.getString("load_file"));
            }
        } else if (state[2] == 0 && state[1] == 0 && state[0] == 0) {
            connectEnable = true;
        } else {
            Debug.printExc("error data");
        }
        return connectEnable;
    }

    public void connectNewBlade(int bladeNO, boolean isControl, String bladeIP, int port, boolean isNew, boolean secureKvm) throws KVMException {
        BladeThread bladeThr;
        Debug.println("connectNewBlade::::::::" + bladeNO);
        this.clickButton(bladeNO, false);
        Debug.println("connect ip :" + bladeIP + " port :" + port);
        try {
            this.bladeThread = new BladeThread(bladeIP, port, bladeNO, isNew);
            this.bladeThread.setName("BladeThread" + bladeNO);
            this.bladeThread.setEncrytedStatus(secureKvm);
        }
        catch (KVMException e) {
            if (this.kvmInterface.getBladeSize() == 1) {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("Connect_lost_message_one") + " " + bladeIP);
            } else {
                JOptionPane.showMessageDialog(this.kvmInterface.toolbar, this.kvmInterface.kvmUtil.getString("Connect_lost_message") + " " + bladeIP);
            }
            this.clickButton(bladeNO, true);
            return;
        }
        String bladeKey = Integer.toString(bladeNO);
        this.kvmInterface.base.threadGroup.put(bladeKey, this.bladeThread);
        KVMUtil kvmUtil = new KVMUtil();
        this.bladeThread.setKvmUtil(kvmUtil);
        this.bladeThread.setKvmInterface(this.kvmInterface);
        this.bladeThread.bladeCommu.setClient(this.kvmInterface.client);
        this.bladeThread.setUnPackData(new UnPackData());
        this.bladeThread.setBladeNO(bladeNO);
        this.bladeThread.bladeCommu.setBladeNO(bladeNO);
        this.bladeThread.bladeCommu.setKvmInterface(this.kvmInterface);
        kvmUtil.setKvmInterface(this.kvmInterface);
        kvmUtil.setImageData(this.imageData);
        kvmUtil.firstJudge = true;
        ImagePane imagePane = this.getNewImagePane(bladeNO);
        if (this.getImageFloatToolbar(bladeNO) != null && this.getImageFloatToolbar(bladeNO).getVirtualMedia() != null) {
            this.getImageFloatToolbar(bladeNO).getVirtualMedia().setStrIP(bladeIP);
            Debug.println(" vmm link IP :" + bladeIP);
        }
        imagePane.setCursor(this.kvmInterface.base.myCursor);
        PackData pack = new PackData();
        pack.setKvmInterface(this.kvmInterface);
        pack.setPackLenHead(this.bladeThread.getEncrytedStatus());
        imagePane.setPack(pack);
        imagePane.bladeNO = bladeNO;
        imagePane.setControl(isControl);
        imagePane.setBladeThread(this.bladeThread);
        imagePane.setNew(isNew);
        DrawThread drawThread = new DrawThread(bladeNO, imagePane, kvmUtil);
        this.bladeThread.setDrawThread(drawThread);
        drawThread.setName("DrawThread" + bladeKey);
        drawThread.setConn(true);
        drawThread.setTotalConn(true);
        drawThread.setKvmInterface(this.kvmInterface);
        drawThread.setBladeCommu(this.bladeThread.bladeCommu);
        this.kvmInterface.base.tabbedList.add(bladeKey);
        Iterator<String> iter = this.kvmInterface.base.threadGroup.keySet().iterator();
        String name = "";
        while (iter.hasNext()) {
            name = iter.next();
            this.kvmInterface.base.threadGroup.get((Object)name).getDrawThread().isDisplay = false;
        }
        drawThread.isDisplay = true;
        kvmUtil.resetBuf();
        this.bladeThread.bladeHeartTimer = new BladeHeartTimer(this.bladeThread);
        this.bladeThread.bladeHeartTimer.setName("BladeHeart" + bladeNO);
        this.bladeThread.bladeHeartTimer.start();
        this.bladeThread.start();
        drawThread.start();
        this.kvmInterface.tabbedpane.setPreferredSize(new Dimension(kvmUtil.imageWidth + imagePane.getLocation().x, kvmUtil.imageHeight + imagePane.getLocation().y));
        if (this.kvmInterface.actionBlade != 0 && (bladeThr = this.kvmInterface.base.threadGroup.get(String.valueOf(this.kvmInterface.actionBlade))) != null) {
            bladeThr.bladeCommu.sentData(this.kvmInterface.packData.contrRate(0, bladeThr.getBladeNO()));
        }
        this.kvmInterface.actionBlade = bladeNO;
        if (this.kvmInterface.bladeList.size() == 1) {
            this.kvmInterface.tabbedpane.add(imagePane);
        } else {
            this.kvmInterface.tabbedpane.add(BLADE + bladeNO, imagePane);
        }
        this.kvmInterface.tabbedpane.setSelectedComponent(imagePane);
        imagePane.statReceiveTask = imagePane.new ImagePane.StatReceiveTask();
        KVMUtil.startReceiveList(imagePane);
        if (isControl) {
            imagePane.mouseTimerTask = imagePane.new ImagePane.MouseTimerTask();
            KVMUtil.startMouseList(imagePane);
            this.bladeThread.bladeCommu.sentData(this.kvmInterface.packData.connectBlade(bladeNO, this.getImagePane((int)bladeNO).custBit));
            if (this.kvmInterface.getBladeFlag() != null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    Debug.printExc(e.getMessage());
                }
            }
            this.bladeThread.bladeCommu.sentData(this.kvmInterface.packData.contrRate(35, this.bladeThread.getBladeNO()));
            this.bladeThread.bladeCommu.sentData(this.kvmInterface.kvmUtil.getImagePane((int)this.kvmInterface.actionBlade).pack.mouseModeControl((byte)36, (byte)2, this.bladeThread.getBladeNO()));
        } else {
            this.bladeThread.bladeCommu.sentData(this.kvmInterface.packData.monitorBlade(bladeNO));
            this.setMoniKeyState(this.kvmInterface.isFullScreen);
        }
        this.setButtonEnable(true);
        if (null != this.kvmInterface.toolbar.mouseSynButton && isNew) {
            if (this.kvmInterface.base.isMstsc) {
                this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
            } else {
                this.kvmInterface.toolbar.mouseSynButton.setEnabled(false);
            }
        }
        MouseDisplacementImpl.setMode(0);
        this.kvmInterface.clickFlag = false;
    }

    private void clickButton(int bladeNO, boolean enable) {
        if (this.kvmInterface.bladeList.size() == 1) {
            return;
        }
        this.kvmInterface.toolbar.getComponent(4 + bladeNO).setEnabled(enable);
        this.kvmInterface.toolbar.getComponent(4 + bladeNO).addMouseListener(this.bladeMouseListener(enable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectBlade(int bladeNO) {
        Object lock;
        Object object = lock = this.kvmInterface.base.getLock(bladeNO);
        synchronized (object) {
            if (this.kvmInterface.base.threadGroup.size() == 0 || this.kvmInterface.base.threadGroup.get(String.valueOf(bladeNO)) == null) {
                return;
            }
            BladeThread bladeThread = this.kvmInterface.base.threadGroup.remove(String.valueOf(bladeNO));
            this.kvmInterface.clientSocket.bladeMap.remove(String.valueOf(bladeNO));
            ImagePane imagePane = this.getImagePane(bladeNO);
            imagePane.kvmInterface.floatToolbar.destroyVmLink();
            if (!Base.isSynMouse) {
                imagePane.mouseTimerTask = null;
            }
            imagePane.mouseTimerTask = null;
            imagePane.receiveList.cancel();
            imagePane.statReceiveTask = null;
            bladeThread.bladeHeartTimer = null;
            bladeThread.keyState.clear();
            DrawThread drawThread = bladeThread.getDrawThread();
            this.kvmInterface.base.tabbedList.remove(String.valueOf(bladeNO));
            if (drawThread.timer != null) {
                drawThread.timer.cancel();
            }
            drawThread.setConn(false);
            drawThread.lList.add(new byte[]{1, 1, 1, 1, 1});
            drawThread.lList.add(new byte[]{1, 1, 1, 1, 1});
            while (drawThread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {}
            }
            if (!bladeThread.bladeCommu.socket.isClosed()) {
                bladeThread.bladeCommu.sentData(this.kvmInterface.packData.interruptBlade(bladeNO, bladeThread));
            }
            drawThread.setComImage(null);
            drawThread.setPreviImage(null);
            drawThread.getKvmUtil().imageData = null;
            drawThread.getKvmUtil().bladePreInfo = null;
            drawThread.imagePane = null;
            drawThread.lList = null;
            drawThread = null;
            bladeThread.setConn(false);
            try {
                bladeThread.bladeCommu.socket.close();
            }
            catch (IOException e) {
                bladeThread = null;
                Debug.printExc(e.getMessage());
            }
            imagePane.bladeNO = 0;
            imagePane.colorBit = 0;
            imagePane.custBit = 0;
            this.setImagePaneRev(imagePane);
            this.kvmInterface.tabbedpane.getModel().removeChangeListener(this.changeListener);
            JTabbedPane e = this.kvmInterface.tabbedpane;
            synchronized (e) {
                this.kvmInterface.tabbedpane.remove(imagePane);
            }
            imagePane.releaseImagePanel();
            imagePane = null;
            this.clickButton(bladeNO, true);
            if (this.kvmInterface.tabbedpane.getTabCount() == 0) {
                this.setButtonEnable(false);
                this.kvmInterface.actionBlade = 0;
                this.kvmInterface.toolbar.numColorButton.setBackground(Base.LIGHT_OFF);
                this.kvmInterface.toolbar.capsColorButton.setBackground(Base.LIGHT_OFF);
                this.kvmInterface.toolbar.scrollColorButton.setBackground(Base.LIGHT_OFF);
            } else {
                this.kvmInterface.actionBlade = ((ImagePane)this.kvmInterface.tabbedpane.getSelectedComponent()).bladeNO;
                ImagePane imagePane1 = this.getImagePane(this.kvmInterface.actionBlade);
                this.kvmInterface.tabbedpane.setPreferredSize(new Dimension(imagePane1.width + imagePane1.getLocation().x, imagePane1.height + imagePane1.getLocation().y + 5));
                if (null != this.kvmInterface.toolbar.mouseSynButton) {
                    if (imagePane1.isNew()) {
                        if (this.kvmInterface.base.isMstsc) {
                            this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
                        } else {
                            this.kvmInterface.toolbar.mouseSynButton.setEnabled(false);
                        }
                    } else {
                        this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
                    }
                }
                BladeThread bThread = this.kvmInterface.base.threadGroup.get(String.valueOf(imagePane1.bladeNO));
                bThread.getDrawThread().isDisplay = true;
                bThread.kvmUtil.resultDivi.clear();
                bThread.kvmUtil.diviBuff.clear();
                bThread.kvmUtil.resetBuf();
                bThread.getDrawThread().lList.clear();
                bThread.getDrawThread().getComImage().clear();
                bThread.bladeCommu.sentData(this.kvmInterface.packData.connectBlade(this.kvmInterface.actionBlade, this.getImagePane((int)this.kvmInterface.actionBlade).custBit));
                bThread.bladeCommu.sentData(this.kvmInterface.packData.contrRate(35, bThread.getBladeNO()));
                imagePane1.kvmInterface.floatToolbar.setLocation((imagePane1.kvmInterface.floatToolbar.imgwidth - imagePane1.kvmInterface.floatToolbar.getWidth()) / 2, -1);
                if (imagePane1.kvmInterface.floatToolbar.isVirtualMedia()) {
                    imagePane1.kvmInterface.floatToolbar.setFlpLocation((imagePane1.kvmInterface.floatToolbar.imgwidth - imagePane1.kvmInterface.floatToolbar.getFlpWidth()) / 2, imagePane1.kvmInterface.floatToolbar.getHeight() - 1);
                    imagePane1.kvmInterface.floatToolbar.setCDLocation((imagePane1.kvmInterface.floatToolbar.imgwidth - imagePane1.kvmInterface.floatToolbar.getCDWidth()) / 2, imagePane1.kvmInterface.floatToolbar.getHeight() - 1);
                }
            }
        }
    }

    public void setImagePaneRev(ImagePane imagePane) {
        imagePane.setImage(new byte[0x140000]);
        imagePane.repaint();
        this.kvmInterface.base.isDiv = true;
        imagePane.source.newPixels(0, 0, 1280, 1024);
        imagePane.big.drawImage(imagePane.image, 0, 0, imagePane);
        imagePane.transform.setToScale(Base.getScreenSize().getWidth() / 2.0 / 1280.0, Base.getScreenSize().getHeight() / 2.0 / 1024.0);
        imagePane.applyFilter();
        imagePane.repaint();
        this.kvmInterface.base.isDiv = false;
    }

    public void setButtonEnable(boolean buttonEnable) {
        Debug.println("setButtonEnable:::::::" + buttonEnable);
        if (buttonEnable) {
            if (null != this.kvmInterface.toolbar.disConnectBladeButton) {
                this.kvmInterface.toolbar.disConnectBladeButton.setEnabled(true);
            }
            if (null != this.kvmInterface.toolbar.divButton) {
                this.kvmInterface.toolbar.divButton.setEnabled(true);
            }
            if (null != this.kvmInterface.toolbar.mouseSynButton) {
                this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
            }
            if (null != this.kvmInterface.toolbar.setColorBit) {
                this.kvmInterface.toolbar.setColorBit.setEnabled(true);
            }
            this.kvmInterface.toolbar.combineKey.setEnabled(true);
            this.kvmInterface.toolbar.fullButton.setEnabled(true);
            this.kvmInterface.toolbar.imageButton.setEnabled(true);
        } else {
            if (null != this.kvmInterface.toolbar.disConnectBladeButton) {
                this.kvmInterface.toolbar.disConnectBladeButton.setEnabled(false);
            }
            if (null != this.kvmInterface.toolbar.divButton) {
                this.kvmInterface.toolbar.divButton.setEnabled(false);
            }
            if (null != this.kvmInterface.toolbar.mouseSynButton) {
                this.kvmInterface.toolbar.mouseSynButton.setEnabled(false);
            }
            if (null != this.kvmInterface.toolbar.setColorBit) {
                this.kvmInterface.toolbar.setColorBit.setEnabled(false);
            }
            this.kvmInterface.toolbar.combineKey.setEnabled(false);
            this.kvmInterface.toolbar.fullButton.setEnabled(false);
            this.kvmInterface.toolbar.imageButton.setEnabled(true);
        }
        if (this.kvmInterface.getBladeSize() > 1) {
            this.kvmInterface.toolbar.disConnectBladeButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.combineKey.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.fullButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.divButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.refreshButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.imageButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.disConnectBladeButton.addMouseListener(this.buttonMouseListener(buttonEnable));
            this.kvmInterface.toolbar.refreshButton.addMouseListener(this.buttonMouseListener(true));
            this.kvmInterface.toolbar.divButton.addMouseListener(this.buttonMouseListener(buttonEnable));
            this.kvmInterface.toolbar.combineKey.addMouseListener(this.buttonMouseListener(buttonEnable));
            this.kvmInterface.toolbar.fullButton.addMouseListener(this.buttonMouseListener(buttonEnable));
            this.kvmInterface.toolbar.imageButton.addMouseListener(this.buttonMouseListener(true));
            this.kvmInterface.toolbar.helpButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3), BorderFactory.createLineBorder(Color.WHITE)));
            this.kvmInterface.toolbar.helpButton.addMouseListener(this.buttonMouseListener(true));
        }
    }

    public MouseListener buttonMouseListener(final boolean flag) {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (flag) {
                    JButton button = (JButton)e.getSource();
                    button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
                    button.setBackground(new Color(237, 235, 235));
                } else {
                    JButton button = (JButton)e.getSource();
                    button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
                    button.setBackground(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton button = (JButton)e.getSource();
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.WHITE)));
                button.setBackground(null);
            }
        };
        return adapter;
    }

    public MouseListener bladeMouseListener(final boolean flag) {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (flag) {
                    JButton button = (JButton)e.getSource();
                    button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createLineBorder(Color.WHITE)), BorderFactory.createEmptyBorder(6, 3, 6, 3)));
                    button.setBackground(new Color(237, 235, 235));
                } else {
                    JButton button = (JButton)e.getSource();
                    button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5), BorderFactory.createLineBorder(Color.WHITE)));
                    button.setBackground(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JButton button = (JButton)e.getSource();
                button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 5, 8, 5), BorderFactory.createLineBorder(Color.WHITE)));
                button.setBackground(null);
            }
        };
        return adapter;
    }

    public void setFullToolBar(boolean isDiv) {
        if (isDiv) {
            this.kvmInterface.fullScreen.toolBar.removeAll();
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.divButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.mouseSynButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.combineKey);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.mouseModeButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.returnButton);
            if (this.kvmInterface.floatToolbar.isVirtualMedia()) {
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.btnCDMenu);
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.btnFlpMenu);
            }
            if (null != this.kvmInterface.fullScreen.toolBar.powerMenuButton) {
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.powerMenuButton);
            }
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.helpButton);
            this.kvmInterface.fullScreen.toolBar.divButton.setEnabled(false);
            this.kvmInterface.fullScreen.toolBar.mouseSynButton.setEnabled(false);
            this.kvmInterface.fullScreen.toolBar.combineKey.setEnabled(false);
            this.kvmInterface.fullScreen.toolBar.mouseModeButton.setEnabled(false);
        } else {
            this.kvmInterface.fullScreen.toolBar.removeAll();
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.divButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.mouseSynButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.combineKey);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.mouseModeButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.returnButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.combo);
            if (this.kvmInterface.floatToolbar.isVirtualMedia()) {
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.btnCDMenu);
                this.kvmInterface.fullScreen.toolBar.btnCDMenu.setEnabled(true);
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.btnFlpMenu);
                this.kvmInterface.fullScreen.toolBar.btnFlpMenu.setEnabled(true);
            }
            if (null != this.kvmInterface.fullScreen.toolBar.powerMenuButton) {
                this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.powerMenuButton);
                this.kvmInterface.fullScreen.toolBar.powerMenuButton.setEnabled(true);
            }
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.helpButton);
            this.kvmInterface.fullScreen.toolBar.helpButton.setEnabled(true);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.labelnum);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.numColorButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.labelcaps);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.capsColorButton);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.labelscroll);
            this.kvmInterface.fullScreen.toolBar.add(this.kvmInterface.fullScreen.toolBar.scrollColorButton);
            this.kvmInterface.fullScreen.toolBar.divButton.setEnabled(true);
            this.kvmInterface.fullScreen.toolBar.mouseSynButton.setEnabled(true);
            this.kvmInterface.fullScreen.toolBar.combineKey.setEnabled(true);
            this.kvmInterface.fullScreen.toolBar.mouseModeButton.setEnabled(true);
        }
    }

    public void returnToWin() {
        if (this.kvmInterface.base.isDiv) {
            this.kvmInterface.fullScreen.imageParentPane.removeAll();
            this.kvmInterface.fullScreen.setVisible(false);
            this.kvmInterface.fullScreen.toolBarFrame.setVisible(false);
            this.kvmInterface.base.isDiv = false;
            this.setImageTipText(false);
            this.setDrawDisplay(false);
            this.kvmInterface.isFullScreen = false;
            int threadNum = this.kvmInterface.base.tabbedList.size();
            String name = "";
            for (int i = 0; i < threadNum; ++i) {
                name = this.kvmInterface.base.tabbedList.get(i);
                BladeThread bladeThread = this.kvmInterface.base.threadGroup.get(name);
                DrawThread thread = bladeThread.getDrawThread();
                if (name.equals(String.valueOf(this.kvmInterface.actionBlade))) {
                    thread.isDisplay = true;
                    bladeThread.bladeCommu.sentData(this.kvmInterface.packData.contrRate(35, bladeThread.getBladeNO()));
                }
                if (this.kvmInterface.bladeList.size() == 1) {
                    this.kvmInterface.tabbedpane.add(this.getImagePane(thread.bladeNo));
                    continue;
                }
                this.kvmInterface.tabbedpane.add(BLADE + thread.bladeNo, this.getImagePane(thread.bladeNo));
            }
            this.kvmInterface.tabbedpane.setSelectedComponent(this.getImagePane(this.kvmInterface.actionBlade));
        } else {
            this.kvmInterface.fullScreen.imageParentScrollPane.removeAll();
            while (this.kvmInterface.fullScreen.isVisible()) {
                this.kvmInterface.fullScreen.setVisible(false);
            }
            this.kvmInterface.fullScreen.toolBarFrame.setVisible(false);
            this.kvmInterface.isFullScreen = false;
            String name = "";
            int threadNum = this.kvmInterface.base.tabbedList.size();
            for (int i = 0; i < threadNum; ++i) {
                name = this.kvmInterface.base.tabbedList.get(i);
                DrawThread thread = this.kvmInterface.base.threadGroup.get(name).getDrawThread();
                if (!thread.isDisplay) {
                    if (this.kvmInterface.bladeList.size() == 1) {
                        this.kvmInterface.tabbedpane.add(this.getImagePane(thread.bladeNo));
                        continue;
                    }
                    this.kvmInterface.tabbedpane.add(BLADE + thread.bladeNo, this.getImagePane(thread.bladeNo));
                    continue;
                }
                if (this.kvmInterface.bladeList.size() == 1) {
                    this.kvmInterface.tabbedpane.add(this.getImagePane(thread.bladeNo));
                } else {
                    this.kvmInterface.tabbedpane.add(BLADE + thread.bladeNo, this.getImagePane(thread.bladeNo));
                }
                this.kvmInterface.actionBlade = thread.bladeNo;
            }
            this.kvmInterface.tabbedpane.setSelectedComponent(this.getImagePane(this.kvmInterface.actionBlade));
            this.setDrawDisplay(false);
            DrawThread drawThread = this.kvmInterface.base.threadGroup.get(String.valueOf(this.kvmInterface.actionBlade)).getDrawThread();
            drawThread.isDisplay = true;
            drawThread.getBladeCommu().sentData(this.kvmInterface.packData.contrRate(35, drawThread.getBladeNo()));
        }
        ImagePane imagePane = this.getImagePane(this.kvmInterface.actionBlade);
        this.kvmInterface.tabbedpane.setPreferredSize(new Dimension(imagePane.width + 2, imagePane.height + 29));
        if (imagePane.isContr()) {
            this.setNumKeyColor(imagePane.getNum());
            this.setCapsKeyColor(imagePane.getCaps());
            this.setScrollKeyColor(imagePane.getScroll());
        } else {
            this.setMoniKeyState(this.kvmInterface.isFullScreen);
        }
        this.kvmInterface.fullScreen.setCursor(this.kvmInterface.base.defCursor);
        imagePane.setCursor(this.kvmInterface.base.defCursor);
        if (null != this.kvmInterface.toolbar.mouseSynButton) {
            if (imagePane.isNew()) {
                if (this.kvmInterface.base.isMstsc) {
                    this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
                } else {
                    this.kvmInterface.toolbar.mouseSynButton.setEnabled(false);
                }
            } else {
                this.kvmInterface.toolbar.mouseSynButton.setEnabled(true);
            }
        }
        imagePane.setVisible(true);
        imagePane.requestFocus();
        this.kvmInterface.floatToolbar.startStateMenu();
        this.kvmInterface.isReturnToWin = true;
        this.kvmInterface.floatToolbar.setVisible(true);
        if (Base.isSingleMouse) {
            this.kvmInterface.floatToolbar.powerMenu.SingleMouseMenu.setSelected(true);
        } else {
            this.kvmInterface.floatToolbar.powerMenu.SingleMouseMenu.setSelected(false);
        }
        if (null != this.kvmInterface.fullScreen.toolBar.powerMenu) {
            this.kvmInterface.floatToolbar.powerMenu.kineScopeDataCollect = this.kvmInterface.fullScreen.toolBar.powerMenu.kineScopeDataCollect;
        }
        if (null != this.kvmInterface.floatToolbar.powerMenu.kineScopeDataCollect) {
            if (this.kvmInterface.floatToolbar.powerMenu.kineScopeDataCollect.isCollect()) {
                this.kvmInterface.floatToolbar.powerMenu.localKinescopeMenu.setText(this.kvmInterface.kvmUtil.getString("Stop_KinScope"));
            } else {
                this.kvmInterface.floatToolbar.powerMenu.localKinescopeMenu.setText(this.kvmInterface.kvmUtil.getString("localKinescope"));
            }
        } else {
            this.kvmInterface.floatToolbar.powerMenu.localKinescopeMenu.setText(this.kvmInterface.kvmUtil.getString("localKinescope"));
        }
        this.kvmInterface.floatToolbar.btnShow.setIcon(new ImageIcon(this.getClass().getResource("resource/images/float.gif")));
        this.kvmInterface.fullScreen.setVisible(false);
        if (this.kvmInterface.floatToolbar.isVirtualMedia()) {
            this.kvmInterface.fullScreen.cdMenu.setVisible(false);
            this.kvmInterface.fullScreen.flpMenu.setVisible(false);
            this.kvmInterface.floatToolbar.setVirtualMediaVisible(false, false);
            imagePane.add(this.kvmInterface.floatToolbar.getCDPanel());
            imagePane.add(this.kvmInterface.floatToolbar.getFlpPanel());
            this.kvmInterface.floatToolbar.isShowingCD = false;
            this.kvmInterface.floatToolbar.isShowingFlp = false;
        }
        if (KVMUtil.isLinuxOS() && this.kvmInterface.fullScreen.powerPanelDialog.isShowing()) {
            this.kvmInterface.fullScreen.powerPanelDialog.setVisible(false);
        }
        if (null != this.kvmInterface.floatToolbar.helpFrm) {
            this.kvmInterface.floatToolbar.helpFrm.setAlwaysOnTop(false);
        }
        if (this.kvmInterface.toolFrame != null) {
            this.kvmInterface.toolFrame.setVisible(false);
        }
    }

    public static void startMouseList(ImagePane imagePane) {
        if (!Base.isSynMouse) {
            imagePane.mouseTimerTask.setName("MouseTimer");
            imagePane.mouseTimerTask.start();
        }
    }

    public static void startReceiveList(ImagePane imagePane) {
        imagePane.receiveList = new Timer("ReceiveTimer", true);
        imagePane.receiveList.scheduleAtFixedRate((TimerTask)imagePane.statReceiveTask, 0L, 10000L);
    }

    public void addEmptyPane() {
        int num = 4 - this.kvmInterface.base.threadGroup.size();
        if (num <= 2) {
            for (int i = 0; i < num; ++i) {
                FloatPanel temPane = new FloatPanel(this.kvmInterface);
                temPane.setShowtoolBar(false);
                temPane.setBackground(Color.black);
                this.kvmInterface.fullScreen.imageParentPane.add(temPane);
            }
        } else {
            for (int i = 0; i < num; ++i) {
                FloatPanel temPane = new FloatPanel(this.kvmInterface);
                if (i == 0) {
                    temPane.setShowtoolBar(true);
                } else {
                    temPane.setShowtoolBar(false);
                }
                temPane.setBackground(Color.black);
                this.kvmInterface.fullScreen.imageParentPane.add(temPane);
            }
        }
    }

    public void setMoniKeyState(boolean isFullScreen) {
        if (isFullScreen) {
            this.kvmInterface.fullScreen.toolBar.numColorButton.setBackground(Color.GRAY);
            this.kvmInterface.fullScreen.toolBar.capsColorButton.setBackground(Color.GRAY);
            this.kvmInterface.fullScreen.toolBar.scrollColorButton.setBackground(Color.GRAY);
        } else {
            this.kvmInterface.toolbar.numColorButton.setBackground(Color.GRAY);
            this.kvmInterface.toolbar.capsColorButton.setBackground(Color.GRAY);
            this.kvmInterface.toolbar.scrollColorButton.setBackground(Color.GRAY);
        }
    }

    public static int translateToUSBCode(KeyEvent e) {
        int usbCode = 0;
        if (e.isActionKey() || e.getKeyLocation() == 4 || 17 == e.getKeyCode() || 16 == e.getKeyCode() || 18 == e.getKeyCode() || 65406 == e.getKeyCode()) {
            usbCode = KVMUtil.javaCodeToUSB(e);
        } else if (!e.isActionKey()) {
            int scancode = 0;
            if (KVMUtil.isWindowsOS()) {
                scancode = MouseDisplacementImpl.getScanCode();
                for (int i = 0; i < Base.KEY_MAP.length; ++i) {
                    if (scancode != Base.KEY_MAP[i][0]) continue;
                    usbCode = Base.KEY_MAP[i][1];
                    break;
                }
            } else if (KVMUtil.isMacOS()) {
                usbCode = KVMUtil.javaCodeToUSB(e);
            } else if (KVMUtil.isLinux()) {
                if (KeyboardImpl.getScanCode() == 0) {
                    usbCode = KVMUtil.javaCodeToUSB(e);
                } else {
                    scancode = 0xFF & KeyboardImpl.getScanCode();
                    for (int i = 0; i < Base.KEY_MAP.length; ++i) {
                        if (scancode != Base.KEY_MAP[i][0]) continue;
                        usbCode = Base.KEY_MAP[i][1];
                        break;
                    }
                }
            }
        } else {
            usbCode = KVMUtil.javaCodeToUSB(e);
        }
        return usbCode;
    }

    public static void main(String[] args) {
        String tmp1 = "/10.85.138.73:80".substring(1);
        String proxyIp = tmp1.split(":")[0];
        Debug.printExc("proxy ip:" + proxyIp);
        Debug.printExc("proxy port:31035");
    }

    public static Socket getProxySocket(String httpIp, int httpPort, String serverIp, int serverPort) throws URISyntaxException, IOException {
        Debug.printExc("smm ip:" + httpIp);
        ProxySelector selector = ProxySelector.getDefault();
        List<Proxy> proxys = selector.select(new URI("http://" + httpIp + ":" + httpPort));
        ListIterator<Proxy> it = proxys.listIterator();
        while (it.hasNext()) {
            Proxy proxy = (Proxy)it.next();
            Debug.printExc("proxy:" + proxy.address());
            if (!Proxy.Type.HTTP.name().equals(proxy.type().name())) continue;
            String tmp1 = proxy.address().toString().substring(1);
            String proxyIp = tmp1.split(":")[0];
            Debug.printExc("proxy ip:" + proxyIp);
            Debug.printExc("proxy port:31035");
            InetAddress ia = InetAddress.getByName(proxyIp);
            InetSocketAddress isa = new InetSocketAddress(ia, 31035);
            Socket socket = new Socket(new Proxy(Proxy.Type.SOCKS, isa));
            Debug.printExc("server ip:" + serverIp);
            Debug.printExc("server port:" + serverPort);
            InetAddress ia1 = InetAddress.getByName(serverIp);
            InetSocketAddress ept = new InetSocketAddress(ia1, serverPort);
            socket.connect(ept);
            return socket;
        }
        return null;
    }

    public BladeState getBladStateBmc(int bladeNO) throws KVMException {
        BladeState bladeState = new BladeState();
        String bladeIP = this.kvmInterface.client.address.getHostAddress();
        int bladePort = Client.port;
        bladeState.setBladeIP(bladeIP);
        bladeState.setBladePort(bladePort);
        bladeState.setEnable(true);
        bladeState.setNew(true);
        return bladeState;
    }

    private static String getOsName() {
        if (osType != null && "".equals(osType)) {
            osType = System.getProperty("os.name").toLowerCase();
        }
        return osType;
    }

    public static String getOsArch() {
        if (osArch != null && "".equals(osArch)) {
            osArch = System.getProperty("os.arch").toLowerCase();
        }
        return osArch;
    }

    public static boolean isOSTypeByNmae(String oSTypeNmae) {
        return null != KVMUtil.getOsName() && KVMUtil.getOsName().startsWith(oSTypeNmae);
    }

    public static boolean isWindowsOS() {
        return KVMUtil.isOSTypeByNmae("windows");
    }

    public static boolean isLinuxOS1() {
        return KVMUtil.isOSTypeByNmae("linux");
    }

    public static boolean isLinuxOS() {
        return KVMUtil.isOSTypeByNmae("linux") || KVMUtil.isOSTypeByNmae("mac os x");
    }

    public static boolean isLinux() {
        return KVMUtil.isOSTypeByNmae("linux");
    }

    public static boolean isMacOS() {
        return KVMUtil.isOSTypeByNmae("mac os x");
    }

    public static boolean isOsArchByName(String osArch) {
        return null != KVMUtil.getOsArch() && KVMUtil.getOsArch().startsWith(osArch);
    }

    public void setCodeKey(byte codeKeys, int bladeNO) {
        int[] state = KVMUtil.perBitToInt(codeKeys);
        if (state[7] == 1) {
            InterfaceContainer iContainer = null;
            for (int i = 0; i < this.kvmInterface.bladeList.size() && ((iContainer = this.kvmInterface.bladeList.get(i)) == null || iContainer.getBladeNO() != bladeNO); ++i) {
                iContainer = null;
            }
            if (state[0] == 1) {
                if (iContainer != null) {
                    iContainer.setCodeKey(this.kvmInterface.codeKey);
                }
            } else if (iContainer != null) {
                iContainer.setCodeKey(0);
            }
        }
    }

    public static boolean isAdmin() {
        return Base.privilege == 4 || Base.privilege == 3;
    }

    public static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }
}

