#!/bin/bash

if [ -L ${0} ]
then
    REALFILE=$(readlink ${0})
else
    REALFILE=${0}
fi
CUR_DIR=$(dirname ${REALFILE})

cd "${CUR_DIR}"

if [ ! -e "jre/bin" ]; then
    mkdir -p log
    date 
    
    ver="_x86"
    uname -a | grep x86_64 
    if [ $? == 0 ]; then
        ver="_x64"
    fi

    cp -rf "jre/bin${ver}" "jre/bin"
    cp -rf "jre/rt${ver}.jar" "jre/lib/rt.jar"
    cp -rf "tools/wkhtmltopdf/wkhtmltox${ver}" "tools/wkhtmltopdf/Linux"
fi

export JAVA_HOME=jre
export PATH=$JAVA_HOME/bin:$PATH
chmod 777 jre/bin/java jre/bin/keytool
java -jar vconsole_client.jar
