/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cbb.resource.util;

import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public final class XmlParserUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static final String DEV_TYPE_ITEM = "devtype";
    private static final String PROP_SYSOID = "sysoid";
    private static final String PROP_PARENT_TYPE = "parentType";
    private static final String PROP_CHILD_TYPE = "childType";
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_MANUFACTOR = "manufacturer";
    private static final String PROP_VERSION = "version";
    private static final String PROP_DEFAULT_VERSION = "defaultVersion";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeviceTypeRelation> getDeviceTypeDefines() {
        InputStream inputStream = null;
        ClassLoader loader = this.getClass().getClassLoader();
        if (null != loader) {
            inputStream = loader.getResourceAsStream("SecDevTypeSet.xml");
        }
        if (null == inputStream) {
            return null;
        }
        ArrayList<DeviceTypeRelation> devTypes = new ArrayList<DeviceTypeRelation>();
        Document document = null;
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            document = reader.read(inputStream);
            Element root = document.getRootElement();
            Iterator iterator = root.elementIterator(DEV_TYPE_ITEM);
            while (iterator.hasNext()) {
                StringBuffer sb;
                Element devTypeElement = (Element)iterator.next();
                String sysoid = devTypeElement.attributeValue(PROP_SYSOID);
                String parentType = devTypeElement.attributeValue(PROP_PARENT_TYPE);
                String childType = devTypeElement.attributeValue(PROP_CHILD_TYPE);
                String description = devTypeElement.attributeValue(PROP_DESCRIPTION);
                String manufacturer = devTypeElement.attributeValue(PROP_MANUFACTOR);
                String version = devTypeElement.attributeValue(PROP_VERSION);
                String defaultVersion = devTypeElement.attributeValue(PROP_DEFAULT_VERSION);
                DeviceTypeRelation devTypeDef = new DeviceTypeRelation();
                devTypeDef.setManufacturer(manufacturer);
                devTypeDef.setParentType(parentType + "_i18n");
                devTypeDef.setChildType(childType + "_i18n");
                if (sysoid != null && !sysoid.isEmpty()) {
                    if ((sysoid = sysoid.trim()).startsWith(".")) {
                        sysoid = sysoid.substring(1, sysoid.length());
                    }
                    devTypeDef.setRelationSysOid(sysoid);
                }
                if (description != null) {
                    sb = new StringBuffer();
                    sb.append(description).append("_desc_i18n");
                    devTypeDef.setDescription(sb.toString());
                }
                if (manufacturer != null && description != null) {
                    sb = new StringBuffer();
                    sb.append(description).append("_i18n");
                    devTypeDef.setDescription(sb.toString());
                }
                devTypeDef.setVersion(version);
                devTypeDef.setDefaultVersion(defaultVersion);
                devTypes.add(devTypeDef);
            }
            document.clearContent();
        }
        catch (DocumentException e) {
            LOGGER.error((Object)"DocumentException", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"IOException", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"IOException");
            }
        }
        return devTypes;
    }
}

