/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.collector.entity.monitor.CollectorDiskObj;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.springframework.beans.BeanUtils;

public final class AticUtil {
    public static final int ZONE_IP_TYPE_EXCULDE = 1;
    public static final String PACKET_TASK_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.]*$";
    public static final String PACKET_FILE_NAME_REGEX = "^[\\w|\u4e00-\u9fa5|\\!|\\@|\\#|\\$|\\^|\\+|\\-|\\_|\\=|\\}|\\{|\\]|\\[|\\;|\\.|\\*|\\:|\\,|\\/| |%]*$";
    private static final String URL_TIME_ZONE_UTC = "UTC";
    private static final List<String> FILE_TYPE_LIST = new ArrayList<String>();
    private static Log log;
    private static final long MINITUS = 60L;
    private static final long HOUR = 3600L;
    private static final int MAX_COUNT = 0x100000;
    private static int timeout;
    private static String uiConfigFilePath;
    private static String command;
    private static String commandLinuxScCollectorSVC;

    public static String convertIpFromLong2Str(long address) {
        byte[] values = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address >>> 0 & 0xFFL)};
        return (values[0] & 0xFF) + "." + (values[1] & 0xFF) + "." + (values[2] & 0xFF) + "." + (values[3] & 0xFF);
    }

    public static long convertIpFromStr2Long(String strIp) {
        try {
            if (AticUtil.isNull(strIp)) {
                return 0L;
            }
            long[] ip = new long[4];
            int position1 = strIp.indexOf(".");
            int position2 = strIp.indexOf(".", position1 + 1);
            int position3 = strIp.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIp.substring(0, position1));
            ip[1] = Long.parseLong(strIp.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIp.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIp.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String appendOperNameFromBatchOper(BatchOperationResult batchOperationResult) {
        StringBuffer names = new StringBuffer();
        for (BatchOperation bo : batchOperationResult.getResult()) {
            names.append(bo.getTargetName()).append(',');
        }
        return names.toString();
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static boolean isNullForVpn(String str) {
        return str == null || "".equals(str.trim());
    }

    public static long convertTimeString(String time) {
        if (time == null || time.length() == 0) {
            return 0L;
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = formate.parse(time.trim());
            return date.getTime() / 1000L;
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public static String convertTime2DayString(long time) {
        if (time <= 0L) {
            return "";
        }
        SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd");
        return formate.format(new Date(time * 1000L));
    }

    public static String convertTimeLong(Long time) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(time * 1000L));
    }

    public static String convertTime2FormatString(String time) {
        String formateString = "";
        if (!AticUtil.isNull(time)) {
            Long longTime = Long.parseLong(time);
            SimpleDateFormat formate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            formateString = formate.format(new Date(longTime * 1000L));
        }
        return formateString;
    }

    public static ServiceContext getServiceContext() {
        ServiceContext context = ServiceContext.getInstance();
        if (null == context) {
            throw new LegoCheckedException(570506L);
        }
        return context;
    }

    public static String getText(String i18n) {
        return LocaleUtil.INSTANCE.getText(i18n);
    }

    public static String getText(String aTextName, Locale locale) {
        return LocaleUtil.INSTANCE.getText(aTextName, locale);
    }

    public static String getText(String i18n, String[] params) {
        return LocaleUtil.INSTANCE.getText(i18n, params);
    }

    public static String getText(String i18n, Locale locale, String[] params) {
        return LocaleUtil.INSTANCE.getText(i18n, locale, params);
    }

    public static Object copyProperties(Object source, Object target) {
        if (null == source || null == target) {
            return null;
        }
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }

    public static String getMaskStartIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String startIp = subnetUtils.getInfo().getLowAddress();
        Long startIpLong = AticUtil.convertIpFromStr2Long(startIp);
        String startIpStr = AticUtil.convertIpFromLong2Str(startIpLong - 1L);
        return startIpStr;
    }

    public static String getMaskEndIp(String ip, String mask) {
        if (mask.equals("255.255.255.255")) {
            return ip;
        }
        SubnetUtils subnetUtils = new SubnetUtils(ip, mask);
        String endIp = subnetUtils.getInfo().getHighAddress();
        Long endIpLong = AticUtil.convertIpFromStr2Long(endIp);
        String endIpStr = AticUtil.convertIpFromLong2Str(endIpLong + 1L);
        return endIpStr;
    }

    public static boolean isReSubmit(HttpSession session, StringBuffer submitToken) {
        StringBuffer token = null;
        if (session.getAttribute("submitToken") != null) {
            token = new StringBuffer((String)session.getAttribute("submitToken"));
        }
        if (null != token && token.toString().equals(submitToken.toString())) {
            return true;
        }
        session.setAttribute("submitToken", (Object)submitToken.toString());
        return false;
    }

    public static List<String> splitIpUtil(String ip, String mask, int maskDigit) {
        if (null == ip || null == mask) {
            return null;
        }
        ArrayList<String> iPList = new ArrayList<String>();
        if (mask.equals("255.255.255.255")) {
            iPList.add(ip);
            return iPList;
        }
        String startIp = AticUtil.getMaskStartIp(ip, mask);
        String endIp = AticUtil.getMaskEndIp(ip, mask);
        Long slong = AticUtil.convertIpFromStr2Long(startIp);
        Long elong = AticUtil.convertIpFromStr2Long(endIp);
        ArrayList<String> splitIpList = new ArrayList<String>();
        long flag = (long)Math.pow(2.0, 32 - maskDigit);
        splitIpList.add(startIp);
        boolean isAdd = true;
        while (isAdd) {
            String splitIpString;
            if ((slong = Long.valueOf(slong + flag)) < elong) {
                isAdd = true;
                splitIpString = AticUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            if (slong.equals(elong)) {
                isAdd = false;
                splitIpString = AticUtil.convertIpFromLong2Str(slong);
                splitIpList.add(splitIpString);
                continue;
            }
            isAdd = false;
        }
        return splitIpList;
    }

    public static String getMask(Integer maskBit) {
        StringBuffer mask = new StringBuffer();
        int a = -1;
        a = 0 == maskBit ? 0 : (a <<= 32 - maskBit);
        mask.append((a & 0xFF000000) >>> 24);
        mask.append('.');
        mask.append((a & 0xFF0000) >> 16);
        mask.append('.');
        mask.append((a & 0xFF00) >> 8);
        mask.append('.');
        mask.append(a & 0xFF);
        return mask.toString();
    }

    public static Integer getMaskBit(String mask) {
        Integer maskBit = 0;
        if (null == mask || "".equals(mask)) {
            return maskBit;
        }
        String[] maskSplit = mask.split("\\.");
        String bmask = "";
        for (int i = 0; i < maskSplit.length; ++i) {
            int maskNum = Integer.parseInt(maskSplit[i]);
            bmask = bmask.concat(Integer.toBinaryString(maskNum));
        }
        maskBit = bmask.lastIndexOf("1") + 1;
        return maskBit;
    }

    public static String stringFilter(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static Boolean isNum(String str) {
        return str.matches("^[0-9]+$");
    }

    public static Boolean isFileName(String fileName) {
        String fileNameReg = "^[\\u4e00-\\u9fa5a-zA-Z0-9\\@\\.\\_\\-]{1,}$";
        if (fileName.matches(fileNameReg) && !fileNameReg.contains("..")) {
            return true;
        }
        return false;
    }

    public static Boolean isPcapFileName(String fileName) {
        if (fileName.matches(PACKET_FILE_NAME_REGEX) && !PACKET_FILE_NAME_REGEX.contains("..")) {
            return true;
        }
        return false;
    }

    public static boolean checkFilePath(String exportFolderPath, String downFileFile) {
        try {
            File tempFile = new File(downFileFile);
            File exportFolderFile = new File(exportFolderPath);
            if (tempFile.getCanonicalPath().startsWith(exportFolderFile.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException e) {
            log.error((Object)"getCanonicalPath IOException error");
        }
        return false;
    }

    public static void deleteTempFile(String downFileName) {
        Boolean result;
        String downloadFileName = "";
        try {
            downloadFileName = new String(downFileName.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"downloadFile", (Throwable)e);
            return;
        }
        File file = new File(downloadFileName);
        if (file.exists() && file.isFile() && !(result = Boolean.valueOf(file.delete())).booleanValue()) {
            log.error((Object)"delete file error");
        }
    }

    public static String processFilterSubAttackName(long attackType) {
        String attackTypeName = "";
        return attackTypeName;
    }

    public static boolean isValidReportTaskName(String value) {
        String taskNameRegex = "(?!null$)[\u4e00-\u9fa5|a-zA-Z0-9|\\@|\\.|\\_|\\-]*$";
        return value.matches(taskNameRegex) && value.length() <= 32;
    }

    public static List<String[]> getFinalIpList(List<String[]> includeIpList, List<String[]> excludeIpList) {
        int n = excludeIpList.size();
        for (int m = 0; m < n; ++m) {
            ArrayList<String[]> newIncludeIpList = new ArrayList<String[]>();
            Iterator<String[]> i = includeIpList.iterator();
            while (i.hasNext()) {
                String[] includeIp = i.next();
                String[] excludeIp = excludeIpList.get(m);
                newIncludeIpList.addAll(IPUtil.getIpRangeExceptOther(includeIp, excludeIp));
                i.remove();
            }
            includeIpList.addAll(newIncludeIpList);
        }
        includeIpList = AticUtil.cleanUpIpList(includeIpList);
        return includeIpList;
    }

    public static List<String[]> cleanUpIpList(List<String[]> ipList) {
        Collections.sort(ipList, new Comparator<String[]>(){

            @Override
            public int compare(String[] ip1, String[] ip2) {
                return IPUtil.compareTo(ip1[0], ip2[0]);
            }
        });
        ArrayList<String[]> returnIpList = new ArrayList<String[]>();
        int k = ipList.size();
        for (int i = 0; i < k; ++i) {
            String[] tempIp;
            String[] ip = ipList.get(i);
            String startIp = ip[0];
            String endIp = ip[1];
            while (i < k - 1 && IPUtil.compareTo(endIp, IPUtil.ipPrevious((tempIp = ipList.get(i + 1))[0])) >= 0) {
                endIp = IPUtil.compareTo(endIp, tempIp[1]) >= 0 ? endIp : tempIp[1];
                ++i;
            }
            String[] returnIp = new String[]{startIp, endIp};
            returnIpList.add(returnIp);
        }
        return returnIpList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(File fileName, String saveFilePath) {
        Boolean isSaveOk = false;
        FileInputStream fileInput = null;
        FileOutputStream fileOutput = null;
        try {
            int bytesRead;
            fileInput = new FileInputStream(fileName);
            fileOutput = new FileOutputStream(saveFilePath);
            byte[] buff = new byte[0x100000];
            while (-1 != (bytesRead = fileInput.read(buff, 0, buff.length))) {
                fileOutput.write(buff, 0, bytesRead);
            }
            isSaveOk = true;
        }
        catch (IOException e) {
            try {
                log.error((Object)"downloadFile", (Throwable)e);
            }
            catch (Throwable throwable) {
                AticUtil.closeInputStream(fileInput);
                AticUtil.closeOutputStream(fileOutput);
                throw throwable;
            }
            AticUtil.closeInputStream(fileInput);
            AticUtil.closeOutputStream(fileOutput);
        }
        AticUtil.closeInputStream(fileInput);
        AticUtil.closeOutputStream(fileOutput);
        return isSaveOk;
    }

    private static void closeInputStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                input = null;
            }
            finally {
                input = null;
            }
        }
    }

    private static void closeOutputStream(OutputStream output) {
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException e) {
                output = null;
            }
            finally {
                output = null;
            }
        }
    }

    public static boolean validateSpecialStr(String validateStr) {
        String regex = "^[\\w|\u4e00-\u9fa5|=|\\-|/|_|!|@|#|$|*|^|:|,|.|+|}|{]*$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(validateStr).matches();
    }

    public static boolean validatePwd(String password) {
        String regex = "^[a-zA-Z|0-9|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]+$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(password).matches();
    }

    public static boolean validateUrl(String url) {
        String regex1 = "^(https://.+)$";
        Pattern pattern = Pattern.compile(regex1);
        if (!pattern.matcher(url).matches()) {
            return false;
        }
        return AticUtil.validateSpecialStr(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileType(File file, String fileType) {
        FileInputStream is = null;
        try {
            String hexStr;
            byte[] b = new byte[4];
            is = new FileInputStream(file);
            if (-1 != is.read(b, 0, b.length) && null != (hexStr = AticUtil.bytesToHexString(b))) {
                boolean bl = hexStr.toUpperCase(Locale.getDefault()).contains(fileType.toUpperCase(Locale.getDefault()));
                return bl;
            }
        }
        catch (IOException e) {
            log.error((Object)"checkFileType error");
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"is.close() error");
                }
            }
        }
        return false;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static boolean checkDateFormat(String dateRegex, String date) {
        String regex = "[0-9:\\ \\-\\/]+";
        if (!date.matches(regex)) {
            return false;
        }
        if (dateRegex == null) {
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(dateRegex);
            format.setLenient(false);
            format.parse(date.trim());
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static boolean validateParameterNames(HttpServletRequest request, String[] whiteList) {
        Map requestMap = request.getParameterMap();
        if (null == requestMap) {
            return true;
        }
        Set ss = requestMap.keySet();
        if (null == ss) {
            return true;
        }
        HashSet<String> whiteParaSet = new HashSet<String>();
        whiteParaSet.addAll(Arrays.asList("cfNameHF", "_dc", "_", "struts.token.name", "token", "submitToken", "csrfToken"));
        whiteParaSet.addAll(Arrays.asList(whiteList));
        return whiteParaSet.containsAll(ss);
    }

    public static String getcleanedMessage(String message) {
        if (null == message) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public static boolean validateIpv4(String ip) {
        String ipHeadStr;
        if (AticUtil.isNull(ip)) {
            return false;
        }
        String regex1 = "^((22[0-3]|2[0-1]\\d|1\\d{2}|[1-9]\\d|[1-9])\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.(25[0-5]|2[0-4]\\d|1\\d{2}|[0-9]\\d|[0-9]))?$";
        return ip.matches(regex1) && !StringUtils.equals((CharSequence)(ipHeadStr = ip.split("\\.")[0]), (CharSequence)"127");
    }

    public static void redirectLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            request.getSession().invalidate();
            response.sendRedirect(request.getContextPath() + "/pages/common/exception.jsp?timeout=true");
        }
        catch (IOException e) {
            log.error((Object)"sendRedirect fail", (Throwable)e);
        }
    }

    public static String htmlEncode(String text) {
        if (null != text && !text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("(", "&#40;");
            text = text.replace(")", "&#41;");
        }
        return text;
    }

    public static String formateTime(long millisecond) {
        if (millisecond <= 0L) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(millisecond * 1000L));
    }

    public static int getDestinationPort(int port) {
        return port > 0 ? port : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyValue(InputStream inputStream, String key) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"find content  fail");
        }
        catch (IOException e) {
            log.error((Object)"read content fail", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"when close file  error happen.I can do nothing", (Throwable)e);
                }
            }
        }
        return properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(String fileName) {
        String content = null;
        String encoding = "UTF-8";
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            Long filelength = file.length();
            byte[] filecontent = new byte[filelength.intValue()];
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                while (-1 != in.read(filecontent)) {
                    content = new String(filecontent, 0, filecontent.length, encoding);
                }
                String string = content;
                return string;
            }
            catch (FileNotFoundException e) {
                log.error((Object)"no file.", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"read error", (Throwable)e);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"close error.", (Throwable)e);
                    }
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyContent(String filePath, String key, String value) {
        FileInputStream fiStream = null;
        InputStreamReader inReader = null;
        BufferedReader br = null;
        FileOutputStream foStream = null;
        OutputStreamWriter outReader = null;
        BufferedWriter bw = null;
        StringBuffer sbf = new StringBuffer();
        try {
            fiStream = new FileInputStream(filePath);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains(key)) {
                    line = line.replace(key, value);
                }
                sbf.append(line);
            }
            foStream = new FileOutputStream(filePath, false);
            outReader = new OutputStreamWriter((OutputStream)foStream, "gbk");
            bw = new BufferedWriter(outReader);
            bw.write(sbf.toString());
        }
        catch (IOException e) {
            boolean bl;
            try {
                log.error((Object)"write error");
                bl = false;
            }
            catch (Throwable throwable) {
                AticUtil.closeBufferedReader(br);
                AticUtil.closeInputStreamReader(inReader);
                AticUtil.closeFileInputStream(fiStream);
                AticUtil.closeBufferedWriter(bw);
                AticUtil.closeOutputStreamWriter(outReader);
                AticUtil.closeFileOutputStream(foStream);
                throw throwable;
            }
            AticUtil.closeBufferedReader(br);
            AticUtil.closeInputStreamReader(inReader);
            AticUtil.closeFileInputStream(fiStream);
            AticUtil.closeBufferedWriter(bw);
            AticUtil.closeOutputStreamWriter(outReader);
            AticUtil.closeFileOutputStream(foStream);
            return bl;
        }
        AticUtil.closeBufferedReader(br);
        AticUtil.closeInputStreamReader(inReader);
        AticUtil.closeFileInputStream(fiStream);
        AticUtil.closeBufferedWriter(bw);
        AticUtil.closeOutputStreamWriter(outReader);
        AticUtil.closeFileOutputStream(foStream);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyPropertyValue(String filePath, String key, String value) {
        FileInputStream fiStream = null;
        InputStreamReader inReader = null;
        BufferedReader br = null;
        FileOutputStream foStream = null;
        OutputStreamWriter outReader = null;
        BufferedWriter bw = null;
        StringBuffer sbf = new StringBuffer();
        try {
            fiStream = new FileInputStream(filePath);
            inReader = new InputStreamReader((InputStream)fiStream, "gbk");
            br = new BufferedReader(inReader);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.contains(key)) {
                    line = key + " = " + value;
                }
                sbf.append(line);
                sbf.append(System.getProperty("line.separator"));
            }
            foStream = new FileOutputStream(filePath, false);
            outReader = new OutputStreamWriter((OutputStream)foStream, "gbk");
            bw = new BufferedWriter(outReader);
            bw.write(sbf.toString());
        }
        catch (IOException e) {
            boolean bl;
            try {
                log.error((Object)"write error");
                bl = false;
            }
            catch (Throwable throwable) {
                AticUtil.closeBufferedReader(br);
                AticUtil.closeInputStreamReader(inReader);
                AticUtil.closeFileInputStream(fiStream);
                AticUtil.closeBufferedWriter(bw);
                AticUtil.closeOutputStreamWriter(outReader);
                AticUtil.closeFileOutputStream(foStream);
                throw throwable;
            }
            AticUtil.closeBufferedReader(br);
            AticUtil.closeInputStreamReader(inReader);
            AticUtil.closeFileInputStream(fiStream);
            AticUtil.closeBufferedWriter(bw);
            AticUtil.closeOutputStreamWriter(outReader);
            AticUtil.closeFileOutputStream(foStream);
            return bl;
        }
        AticUtil.closeBufferedReader(br);
        AticUtil.closeInputStreamReader(inReader);
        AticUtil.closeFileInputStream(fiStream);
        AticUtil.closeBufferedWriter(bw);
        AticUtil.closeOutputStreamWriter(outReader);
        AticUtil.closeFileOutputStream(foStream);
        return true;
    }

    private static void closeBufferedReader(BufferedReader br) {
        if (null != br) {
            try {
                br.close();
            }
            catch (IOException e) {
                log.error((Object)"when close br error happen.I can do nothing");
            }
        }
    }

    private static void closeInputStreamReader(InputStreamReader inReader) {
        if (null != inReader) {
            try {
                inReader.close();
            }
            catch (IOException e) {
                log.error((Object)"when close inReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileInputStream(FileInputStream fiStream) {
        if (null != fiStream) {
            try {
                fiStream.close();
            }
            catch (IOException e) {
                log.error((Object)"when close fileReader error happen.I can do nothing");
            }
        }
    }

    private static void closeBufferedWriter(BufferedWriter bw) {
        if (null != bw) {
            try {
                bw.close();
            }
            catch (IOException e) {
                log.error((Object)"when close bw error happen.I can do nothing");
            }
        }
    }

    private static void closeOutputStreamWriter(OutputStreamWriter outReader) {
        if (null != outReader) {
            try {
                outReader.close();
            }
            catch (IOException e) {
                log.error((Object)"when close outReader error happen.I can do nothing");
            }
        }
    }

    private static void closeFileOutputStream(FileOutputStream foStream) {
        if (null != foStream) {
            try {
                foStream.close();
            }
            catch (IOException e) {
                log.error((Object)"when close foStream error happen.I can do nothing");
            }
        }
    }

    public static String getDuration(long duration) {
        long hours = duration / 3600L;
        long minitus = duration % 3600L / 60L;
        long seconds = duration % 60L;
        return AticUtil.getPartDescription(hours) + ":" + AticUtil.getPartDescription(minitus) + ":" + AticUtil.getPartDescription(seconds);
    }

    private static String getPartDescription(long value) {
        StringBuffer description = new StringBuffer();
        if (value < 10L) {
            if (value == 0L) {
                description.append("00");
            } else {
                description.append("0" + value);
            }
        } else {
            description.append(value);
        }
        return description.toString();
    }

    public static boolean isCmdSucess(List<String> cmdResult) {
        if (cmdResult.isEmpty()) {
            return false;
        }
        for (String result : cmdResult) {
            if (result.contains("Error: The specified user-defined geographic location does not exist")) continue;
            if (result.contains("Error: The IP address does not exist")) {
                return true;
            }
            if (result.contains("Being referred to by geographic location set")) {
                return false;
            }
            if (result.contains("Error:")) {
                return false;
            }
            if (result.contains("remain space of CF card is less than")) {
                return false;
            }
            if (result.contains("Info: The system is busy in collecting the current configuration. Please wait...")) {
                return false;
            }
            if (!result.contains("The system is busy in saving or comparing the current configuration. Please wait...")) continue;
            return false;
        }
        return true;
    }

    public static Integer cmdResult(List<String> cmdResult) {
        if (cmdResult.isEmpty()) {
            return 571806;
        }
        for (String cmd : cmdResult) {
            String cmdResultLowcase = cmd.toLowerCase(Locale.ENGLISH);
            if (cmdResultLowcase.contains("Error: Invalid IP address".toLowerCase(Locale.ENGLISH))) {
                return 571208;
            }
            if (cmdResultLowcase.contains("Error: The number of IP addresses of traffic diversion reaches limit already, no more IP addresses can be added to the device".toLowerCase(Locale.ENGLISH))) {
                return 571209;
            }
            if (cmdResultLowcase.contains("Error: Please specify IP address of next hop first".toLowerCase(Locale.ENGLISH))) {
                return 571210;
            }
            if (cmdResultLowcase.contains("Error: Traffic IP addresses conflict".toLowerCase(Locale.ENGLISH))) {
                return 571211;
            }
            if (cmdResultLowcase.contains("The route already exists.".toLowerCase(Locale.ENGLISH))) {
                return 571801;
            }
            if (cmdResultLowcase.contains("The specified route does not exist.".toLowerCase(Locale.ENGLISH))) {
                return 571802;
            }
            if (cmdResultLowcase.contains("The destination address is invalid.".toLowerCase(Locale.ENGLISH))) {
                return 571814;
            }
            if (cmdResultLowcase.contains("The destination address cannot be a multicast address.".toLowerCase(Locale.ENGLISH))) {
                return 571814;
            }
            if (cmdResultLowcase.contains("anti-ddos np-rule defend destination-ip".toLowerCase(Locale.ENGLISH)) && cmdResultLowcase.contains("Error: Unrecognized command found at".toLowerCase(Locale.ENGLISH))) {
                return 571817;
            }
            if (cmdResultLowcase.contains("Error: The IP address does not exist".toLowerCase(Locale.ENGLISH))) {
                return 1;
            }
            if (cmdResultLowcase.contains("Error: This specified item does not exist".toLowerCase(Locale.ENGLISH))) {
                return 572219;
            }
            if (cmdResultLowcase.contains("Error: The specified item has already existed.".toLowerCase(Locale.ENGLISH))) {
                return 572220;
            }
            if (cmdResultLowcase.contains("Error: The number of configured items has reached the upper limit.".toLowerCase(Locale.ENGLISH))) {
                return 572221;
            }
            if (cmdResultLowcase.contains("Error:".toLowerCase(Locale.ENGLISH))) {
                return 571813;
            }
            if (cmdResultLowcase.contains("The dynamic NP rule number has reached the upper limit".toLowerCase(Locale.ENGLISH))) {
                return 571818;
            }
            if (cmdResultLowcase.contains("Info: The system is busy in collecting the current configuration. Please wait...".toLowerCase(Locale.ENGLISH))) {
                return 571217;
            }
            if (!cmdResultLowcase.contains("The system is busy in saving or comparing the current configuration. Please wait...".toLowerCase(Locale.ENGLISH))) continue;
            return 571217;
        }
        return 1;
    }

    public static String getDDoSVersion(String devTypeName) {
        if (devTypeName == null || "".equals(devTypeName)) {
            return "";
        }
        if (devTypeName.equalsIgnoreCase("Eudemon8000E-X3") || devTypeName.equalsIgnoreCase("Eudemon8000E-X8") || devTypeName.equalsIgnoreCase("Eudemon8000E-X16")) {
            return "4";
        }
        if (devTypeName.equalsIgnoreCase("USG5300ADD") || devTypeName.equalsIgnoreCase("USG5300ADI") || devTypeName.equalsIgnoreCase("Eudemon1000E-D") || devTypeName.equalsIgnoreCase("Eudemon1000E-I")) {
            return "2";
        }
        if (devTypeName.equalsIgnoreCase("Eudemon8000E") || devTypeName.equalsIgnoreCase("USG9300")) {
            return "1";
        }
        return "";
    }

    public static String transferDiskInfo(List<CollectorDiskObj> distInfoList) {
        if (distInfoList != null && !distInfoList.isEmpty()) {
            StringBuffer diskInfoBuf = new StringBuffer();
            for (CollectorDiskObj cdoTmp : distInfoList) {
                NumberFormat nf = NumberFormat.getInstance();
                nf.setMaximumFractionDigits(1);
                String tmpSize = nf.format((double)cdoTmp.getDiskSize() / 1024.0);
                diskInfoBuf.append(cdoTmp.getDiskName());
                diskInfoBuf.append(':');
                diskInfoBuf.append(tmpSize);
                diskInfoBuf.append("GB,");
                diskInfoBuf.append(cdoTmp.getDiskUseRatio());
                diskInfoBuf.append("%; ");
            }
            return diskInfoBuf.toString();
        }
        return "";
    }

    public static boolean hasCollectorService() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        log.info((Object)("hasCollectorService enter. system version is " + version));
        if (1 == version) {
            return AticUtil.hasCollectorServiceLinux();
        }
        return AticUtil.hasCollectorServiceWindows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean hasCollectorServiceLinux() {
        boolean hasCollectorService;
        block11: {
            hasCollectorService = false;
            InputStream in = null;
            BufferedReader read = null;
            InputStream errorIn = null;
            BufferedReader errorRead = null;
            try {
                String line;
                String[] cmd = new String[]{"/bin/sh", "-c", commandLinuxScCollectorSVC};
                Process p = Runtime.getRuntime().exec(cmd);
                in = p.getInputStream();
                if (null != in) {
                    read = new BufferedReader(new InputStreamReader(in, "utf-8"));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = read.readLine()) != null && buffer.length() <= 0x100000) {
                        buffer.append(line);
                        if (!Pattern.matches("\\d+", line)) continue;
                        hasCollectorService = true;
                    }
                    log.info((Object)("buffer content is:" + buffer.toString()));
                }
                if (null != (errorIn = p.getErrorStream())) {
                    errorRead = new BufferedReader(new InputStreamReader(errorIn, "utf-8"));
                    StringBuffer errorBuffer = new StringBuffer();
                    while ((line = errorRead.readLine()) != null) {
                        errorBuffer.append(line);
                    }
                    log.error((Object)("buffer content is:" + errorBuffer.toString()));
                }
                AticUtil.closeInputStream(in);
            }
            catch (IOException e) {
                log.error((Object)"hasCollectorService error", (Throwable)e);
                break block11;
            }
            catch (RuntimeException e2) {
                log.error((Object)"hasCollectorService error", (Throwable)e2);
                break block11;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                AticUtil.closeInputStream(in);
                AticUtil.closeReader(read);
                AticUtil.closeInputStream(errorIn);
                AticUtil.closeReader(errorRead);
            }
            AticUtil.closeReader(read);
            AticUtil.closeInputStream(errorIn);
            AticUtil.closeReader(errorRead);
        }
        return hasCollectorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean hasCollectorServiceWindows() {
        BufferedReader errorRead;
        InputStream errorIn;
        BufferedReader read;
        InputStream in;
        boolean hasCollectorService;
        block9: {
            hasCollectorService = false;
            in = null;
            read = null;
            errorIn = null;
            errorRead = null;
            try {
                String line;
                Process p = Runtime.getRuntime().exec(command);
                in = p.getInputStream();
                if (null != in) {
                    read = new BufferedReader(new InputStreamReader(in, "utf-8"));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = read.readLine()) != null && buffer.length() <= 0x100000) {
                        buffer.append(line);
                        if (!line.contains("DDOSCOLLECTORSVC")) continue;
                        hasCollectorService = true;
                    }
                    log.info((Object)("buffer content is:" + buffer.toString()));
                }
                if (null == (errorIn = p.getErrorStream())) break block9;
                errorRead = new BufferedReader(new InputStreamReader(errorIn, "utf-8"));
                StringBuffer errorBuffer = new StringBuffer();
                while ((line = errorRead.readLine()) != null) {
                    errorBuffer.append(line);
                }
                log.error((Object)("buffer content is:" + errorBuffer.toString()));
            }
            catch (IOException e) {
                log.error((Object)"hasCollectorService error", (Throwable)e);
                AticUtil.closeInputStream(in);
                AticUtil.closeReader(read);
                AticUtil.closeInputStream(errorIn);
                AticUtil.closeReader(errorRead);
            }
            catch (RuntimeException e2) {
                log.error((Object)"hasCollectorService error", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        AticUtil.closeInputStream(in);
                        AticUtil.closeReader(read);
                        AticUtil.closeInputStream(errorIn);
                        AticUtil.closeReader(errorRead);
                        throw throwable;
                    }
                }
                AticUtil.closeInputStream(in);
                AticUtil.closeReader(read);
                AticUtil.closeInputStream(errorIn);
                AticUtil.closeReader(errorRead);
            }
        }
        AticUtil.closeInputStream(in);
        AticUtil.closeReader(read);
        AticUtil.closeInputStream(errorIn);
        AticUtil.closeReader(errorRead);
        return hasCollectorService;
    }

    public static String formatIpAddress(String ip) {
        if (!IPUtil.isIpv6(ip)) {
            return ip;
        }
        return IPUtil.convert2CompleteIpV6AllZero(ip);
    }

    public static String convertDevSyslogTime(String time) {
        if (time == null || time.length() == 0) {
            return time;
        }
        SimpleDateFormat f = null;
        try {
            f = time.trim().indexOf("-") != -1 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US) : new SimpleDateFormat("MMM dd yyyy HH:mm:ss", Locale.US);
            Date dd = f.parse(time.trim());
            long t = dd.getTime() / 1000L;
            return String.valueOf(t);
        }
        catch (Exception e) {
            log.error((Object)"convertDevSyslogTime error", (Throwable)e);
            return time;
        }
    }

    public static String convertNfaTime(String time) {
        if (time == null || time.length() == 0) {
            return time;
        }
        SimpleDateFormat f = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.US);
        try {
            Date dd = f.parse(time.trim());
            long t = dd.getTime() / 1000L;
            return String.valueOf(t);
        }
        catch (Exception e) {
            log.error((Object)"convertNfaTime error", (Throwable)e);
            return time;
        }
    }

    public static String convertFromIntToWildcard(int num, String iptype) {
        if ("IPV6".equals(iptype)) {
            return String.valueOf(num);
        }
        int limit = 32;
        StringBuilder mask = new StringBuilder(limit);
        while (mask.length() != num) {
            mask.append('1');
        }
        while (mask.length() != limit) {
            mask.append('0');
        }
        String maskStr = AticUtil.convertIpFromLong2Str(Long.valueOf(mask.toString(), 2));
        String sourceIpMask = maskStr.replace(".", "/");
        StringBuffer wildMask = new StringBuffer();
        String[] ipMask = sourceIpMask.split("/");
        for (int n = 0; n < ipMask.length; ++n) {
            int tempMask = 255 - Integer.parseInt(ipMask[n]);
            wildMask.append(tempMask).append('.');
        }
        String wildcard = wildMask.toString().substring(0, wildMask.length() - 1);
        return wildcard;
    }

    public static int getTimeout() {
        return timeout;
    }

    public static void setTimeout(int timeout) {
        AticUtil.timeout = timeout;
    }

    private static void closeReader(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error((Object)"close reader IOException:", (Throwable)e);
            }
            finally {
                reader = null;
            }
        }
    }

    public static Boolean isAttackEnd(String status) {
        return !status.trim().equalsIgnoreCase("Ongoing");
    }

    public static boolean checkFileName(String downFileName, String downFileType) {
        if (AticUtil.isNull(downFileName)) {
            return false;
        }
        int index = downFileName.lastIndexOf(".");
        if (index > 0) {
            String onlyFileName = downFileName.substring(0, index);
            String fileRealType = downFileName.substring(index + 1, downFileName.length());
            if (AticUtil.isFileName(onlyFileName).booleanValue() && (AticUtil.isNull(downFileType) ? AticUtil.getFileTypeList().contains(fileRealType.toLowerCase(Locale.US)) : downFileType.equalsIgnoreCase(fileRealType))) {
                return true;
            }
        }
        return false;
    }

    private static List<String> getFileTypeList() {
        return Collections.unmodifiableList(FILE_TYPE_LIST);
    }

    public static boolean judgmentEcho(String cmdResult) {
        if (cmdResult.contains("Info: The system is busy in collecting the current configuration. Please wait...")) {
            return true;
        }
        return cmdResult.contains("The system is busy in saving or comparing the current configuration. Please wait...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUIConfig(String key) {
        String applicationPath = System.getProperty("user.dir");
        String pathName = new File(applicationPath).getParent() + uiConfigFilePath;
        File file = new File(pathName);
        Properties properties = new Properties();
        BufferedInputStream resourceAsStream = null;
        try {
            resourceAsStream = new BufferedInputStream(new FileInputStream(file));
            properties.loadFromXML(resourceAsStream);
        }
        catch (IOException e1) {
            log.error((Object)"read UIConfig error.", (Throwable)e1);
        }
        finally {
            if (null != resourceAsStream) {
                try {
                    ((InputStream)resourceAsStream).close();
                }
                catch (IOException e) {
                    log.error((Object)"close resource error. ", (Throwable)e);
                }
            }
        }
        log.info((Object)("key: " + key + ", value : " + properties.getProperty(key)));
        return properties.getProperty(key);
    }

    public static String curTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        log.info((Object)("curTimeZone : " + timeZone.getID()));
        log.info((Object)timeZone.getDisplayName());
        try {
            return URLEncoder.encode(timeZone.getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URL_TIME_ZONE_UTC;
        }
    }

    static {
        FILE_TYPE_LIST.add("csv");
        FILE_TYPE_LIST.add("xls");
        FILE_TYPE_LIST.add("xml");
        log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
        timeout = -1;
        uiConfigFilePath = File.separator + "vsm_conf" + File.separator + "antiddos" + File.separator + "UIConfig.xml";
        command = "sc query DDOSCOLLECTORSVC";
        commandLinuxScCollectorSVC = "ps -ef | grep java | grep antiddos_collector | grep -v grep | awk '{print $2}'";
    }
}

