/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.util;

import com.hs.atic.util.AticUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Locale;

public final class LocaleUtil
implements LocaleProvider {
    public static final LocaleUtil INSTANCE = new LocaleUtil();
    private final transient TextProvider textProvider = new TextProviderFactory().createInstance(this.getClass(), (LocaleProvider)this);

    private LocaleUtil() {
    }

    public Locale getCurrentUserLocale() {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            locale = ActionContext.getContext().getLocale();
        }
        if (null == locale) {
            locale = this.getOSLanguage();
        }
        return locale;
    }

    public String getText(String textName) {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            return this.textProvider.getText(textName);
        }
        locale = this.getOSLanguage();
        String returnStr = this.getText(textName, locale);
        if (AticUtil.isNull(returnStr)) {
            returnStr = textName;
        }
        return returnStr;
    }

    public String getText(String textName, Locale locale) {
        return LocalizedTextUtil.findDefaultText((String)textName, (Locale)locale);
    }

    public String getText(String textName, String[] params) {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            return this.textProvider.getText(textName, params);
        }
        locale = this.getOSLanguage();
        String returnStr = this.getText(textName, locale, params);
        if (AticUtil.isNull(returnStr)) {
            returnStr = textName;
        }
        return returnStr;
    }

    public String getText(String textName, Locale locale, String[] params) {
        return LocalizedTextUtil.findDefaultText((String)textName, (Locale)locale, (Object[])params);
    }

    public Locale getLocale() {
        Locale locale = null;
        if (null != ActionContext.getContext()) {
            locale = ActionContext.getContext().getLocale();
        }
        if (null == locale) {
            locale = this.getOSLanguage();
        }
        return locale;
    }

    public Locale getOSLanguage() {
        Locale locale = null;
        String language = System.getProperty("user.language");
        locale = "zh".equalsIgnoreCase(language) ? new Locale("zh", "CN") : new Locale("en");
        return locale;
    }
}

