/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.resource.dao;

import com.hs.lego.cbb.resource.common.ResourceConstDefine;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.MainDeviceType;
import com.hs.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.hs.lego.cbb.resource.sdk.model.SubDeviceType;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.tree.DataElement;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class DeviceTypeInfoDao
extends HibernateDaoSupport {
    public static final String MAINDEVICETYPENAME = "T_maindevicetype";
    public static final String SUBDEVICETYPENAME = "T_subdevicetype";
    public static final String OBJNAMEOFDEVICE = "TopoObject";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int TOPO_TYPE_NODE = 0;
    private static final int TOPO_TYPE_GROUP = 3;

    public DeviceTypeInfoDao(SessionFactory factory) {
        this.setSessionFactory(factory);
    }

    public DeviceTypeInfoDao() {
    }

    public void addDeviceMainTypeList(List<String> mainTypes) {
        for (String devType : mainTypes) {
            MainDeviceType devTypeNode = new MainDeviceType(devType);
            this.getHibernateTemplate().save((Object)devTypeNode);
        }
    }

    public void addDevMainType(String devType) {
        MainDeviceType devTypeNode = new MainDeviceType(devType);
        this.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
    }

    public void addDevSubType(String devType) {
        SubDeviceType devTypeNode = new SubDeviceType(devType);
        super.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
    }

    public void deleteAll(String tableName) {
        if (this.checkParams(tableName)) {
            StringBuilder sb = new StringBuilder();
            sb.append("delete from ");
            sb.append(tableName);
            this.updateBySql(sb.toString());
        }
    }

    private boolean checkParams(String name) {
        String regular;
        return null != name && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", name);
    }

    public void addDeviceSubTypeLise(List<String> subTypes) {
        for (String devType : subTypes) {
            SubDeviceType devTypeNode = new SubDeviceType(devType);
            this.getHibernateTemplate().saveOrUpdate((Object)devTypeNode);
        }
    }

    public void setDeviceType(Long deviceId, String mainType, String subType) {
        TopoObject device = (TopoObject)this.getHibernateTemplate().get(TopoObject.class, (Serializable)deviceId);
        if (device != null) {
            device.setMainType(mainType);
            device.setSubType(subType);
            this.getHibernateTemplate().saveOrUpdate((Object)device);
        }
    }

    public List<MainDeviceTypeState> getDeviceStateInfo() {
        List results = this.getHibernateTemplate().loadAll(MainDeviceType.class);
        ArrayList<MainDeviceTypeState> states = new ArrayList<MainDeviceTypeState>();
        for (MainDeviceType mainType : results) {
            String hsql = "select count(*) from  TopoObject d where d.mainType=?";
            Long count = (Long)this.getHibernateTemplate().find(hsql, new Object[]{mainType.getName()}).get(0);
            MainDeviceTypeState state = new MainDeviceTypeState();
            state.setMainDeviceTypeName(mainType.getName());
            state.setDeviceCount(count);
            states.add(state);
        }
        return states;
    }

    public List<TopoObject> getDevLisetByMainType(String mainType) {
        String hsql = "from TopoObject d where d.mainType=?";
        return this.getHibernateTemplate().find(hsql, new Object[]{mainType});
    }

    public List<TopoObject> getAllDevice() {
        String hsql = "from TopoObject";
        return this.getHibernateTemplate().find(hsql, new Object[0]);
    }

    public List<String> getDevSubTypesByMainType(String devMainType) {
        String hsql = "select r.childType from DeviceTypeRelation r where r.parentType=?";
        return this.getHibernateTemplate().find(hsql, new Object[]{devMainType});
    }

    public Long getDeviceRelationId(String mainDevType, String subDevType) {
        List result = this.getHibernateTemplate().find("select r.id from DeviceTypeRelation r where r.parentType=? and r.childType=?", new Object[]{mainDevType, subDevType});
        if (result == null || result.isEmpty()) {
            return null;
        }
        return (Long)result.get(0);
    }

    public long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    public Boolean registerDeviceType(DeviceTypeRelation deviceTypeDef) {
        String childType = deviceTypeDef.getChildType();
        if (childType != null) {
            List results = this.getHibernateTemplate().find("from DeviceTypeRelation t where t.childType=?", new Object[]{childType});
            if (null != results && !results.isEmpty()) {
                DeviceTypeRelation deviceTypeRelation = (DeviceTypeRelation)results.get(0);
                deviceTypeRelation.setChildType(childType);
                deviceTypeRelation.setDescription(deviceTypeDef.getDescription());
                deviceTypeRelation.setManufacturer(deviceTypeDef.getManufacturer());
                deviceTypeRelation.setPageUrl(deviceTypeDef.getPageUrl());
                deviceTypeRelation.setParentType(deviceTypeDef.getParentType());
                deviceTypeRelation.setRelationSysOid(deviceTypeDef.getRelationSysOid());
                this.getHibernateTemplate().update((Object)deviceTypeRelation);
            } else {
                this.getHibernateTemplate().save((Object)deviceTypeDef);
                this.addDevMainType(deviceTypeDef.getParentType());
                this.addDevSubType(deviceTypeDef.getChildType());
            }
            return true;
        }
        return false;
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Boolean hiddenTypeWithoutChild) {
        return this.getDeviceTypeTreeBase(null, hiddenTypeWithoutChild, false);
    }

    public RootDataElement getDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.getDeviceTypeTreeBase(userId, hiddenTypeWithoutChild, true);
    }

    public RootDataElement getOnlineDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.getOnlineDeviceTypeTreeBase(userId, hiddenTypeWithoutChild, true);
    }

    public RootDataElement getDeviceTypeTreeWithoutDev(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.getDeviceTypeTreeBase(userId, hiddenTypeWithoutChild, false);
    }

    public RootDataElement getDeviceTypeTreeBase(Long userId, Boolean hiddenTypeWithoutChild, Boolean showDev) {
        RootDataElement rootData = new RootDataElement();
        Long typeId = 0L;
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, DataElement> mainTypeNode = new HashMap<String, DataElement>();
        for (DeviceTypeRelation relation : devTypeLst) {
            Long l = typeId;
            Long l2 = typeId = Long.valueOf(typeId + 1L);
            String mainType = relation.getParentType();
            String subType = relation.getChildType();
            DataElement mainTypeEle = (DataElement)mainTypeNode.get(mainType);
            if (mainTypeEle == null) {
                mainTypeEle = new DataElement();
                rootData.addChildEle(mainTypeEle);
                mainTypeEle.setDisName(mainType);
                mainTypeEle.setEleType(3L);
                mainTypeEle.setEntityId(mainType);
                mainTypeEle.setId(typeId);
                mainTypeNode.put(mainType, mainTypeEle);
            }
            Long l3 = typeId;
            Long l4 = typeId = Long.valueOf(typeId + 1L);
            DataElement subTypeEle = new DataElement();
            subTypeEle.setDisName(subType);
            subTypeEle.setEleType(3L);
            subTypeEle.setEntityId(subType);
            subTypeEle.setId(typeId);
            mainTypeEle.addChildEle(subTypeEle);
            this.addDeviceList(mainType, subType, userId, subTypeEle);
            if (hiddenTypeWithoutChild.booleanValue() && subTypeEle.getChildUIElement().isEmpty()) {
                mainTypeEle.removeChildEleUI(subTypeEle);
            }
            if (showDev.booleanValue()) continue;
            subTypeEle.removeChildEle();
        }
        if (hiddenTypeWithoutChild.booleanValue()) {
            Set set = mainTypeNode.entrySet();
            for (Map.Entry temp : set) {
                DataElement mainTypeEle = (DataElement)temp.getValue();
                if (!mainTypeEle.getChildUIElement().isEmpty()) continue;
                rootData.removeChildEleUI(mainTypeEle);
            }
        }
        return rootData;
    }

    public RootDataElement getOnlineDeviceTypeTreeBase(Long userId, Boolean hiddenTypeWithoutChild, Boolean showDev) {
        RootDataElement rootData = new RootDataElement();
        Long typeId = 0L;
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, DataElement> mainTypeNode = new HashMap<String, DataElement>();
        for (DeviceTypeRelation relation : devTypeLst) {
            Long l = typeId;
            Long l2 = typeId = Long.valueOf(typeId + 1L);
            String mainType = relation.getParentType();
            String subType = relation.getChildType();
            DataElement mainTypeEle = (DataElement)mainTypeNode.get(mainType);
            if (mainTypeEle == null) {
                mainTypeEle = new DataElement();
                rootData.addChildEle(mainTypeEle);
                mainTypeEle.setDisName(mainType);
                mainTypeEle.setEleType(3L);
                mainTypeEle.setEntityId(mainType);
                mainTypeEle.setId(typeId);
                mainTypeNode.put(mainType, mainTypeEle);
            }
            Long l3 = typeId;
            Long l4 = typeId = Long.valueOf(typeId + 1L);
            DataElement subTypeEle = new DataElement();
            subTypeEle.setDisName(subType);
            subTypeEle.setEleType(3L);
            subTypeEle.setEntityId(subType);
            subTypeEle.setId(typeId);
            mainTypeEle.addChildEle(subTypeEle);
            this.addOnlineDeviceList(mainType, subType, userId, subTypeEle);
            if (!hiddenTypeWithoutChild.booleanValue() || !subTypeEle.getChildUIElement().isEmpty()) continue;
            mainTypeEle.removeChildEleUI(subTypeEle);
        }
        if (hiddenTypeWithoutChild.booleanValue()) {
            Set set = mainTypeNode.entrySet();
            for (Map.Entry temp : set) {
                DataElement mainTypeEle = (DataElement)temp.getValue();
                if (!mainTypeEle.getChildUIElement().isEmpty()) continue;
                rootData.removeChildEleUI(mainTypeEle);
            }
        }
        return rootData;
    }

    protected void addDeviceList(String mainType, String subType, Long userId, DataElement parentEle) {
        StringBuilder hSqlCount = new StringBuilder();
        hSqlCount.append("select t.moId, t.name from TopoObject t where t.mainType=?");
        hSqlCount.append(" and t.subType=?");
        hSqlCount.append(" and t.isTopMo=true ");
        if (userId != null) {
            hSqlCount.append(" and t.moId in (");
            hSqlCount.append(ResourceConstDefine.getHQueryStringbyUserId(userId));
            hSqlCount.append(" )");
        }
        LOGGER.info((Object)("hSqlCount is : " + hSqlCount));
        for (Object[] item : this.getHibernateTemplate().find(hSqlCount.toString(), new Object[]{mainType, subType})) {
            Long moId = (Long)item[0];
            String disName = (String)item[1];
            DataElement ele = new DataElement();
            ele.setDisName(disName);
            ele.setEleType(0L);
            ele.setId(moId);
            ele.setEntityId(String.valueOf(moId));
            parentEle.addChildEle(ele);
        }
    }

    protected void addOnlineDeviceList(String mainType, String subType, Long userId, DataElement parentEle) {
        StringBuilder hSqlCount = new StringBuilder();
        hSqlCount.append("select t.moId, t.name, m.status from TopoObject t, ManagedObject m where m.moId=t.moId and t.mainType=?");
        hSqlCount.append(" and t.subType=?");
        hSqlCount.append(" and m.status is not null ");
        hSqlCount.append(" and t.isTopMo = true ");
        if (userId != null) {
            hSqlCount.append(" and t.moId in (");
            hSqlCount.append(ResourceConstDefine.getHQueryStringbyUserId(userId));
            hSqlCount.append(" )");
        }
        LOGGER.info((Object)("hSqlCount is : " + hSqlCount));
        for (Object[] item : this.getHibernateTemplate().find(hSqlCount.toString(), new Object[]{mainType, subType})) {
            Long moId = (Long)item[0];
            String disName = (String)item[1];
            int status = (Integer)item[2];
            if (status == -2) continue;
            DataElement ele = new DataElement();
            ele.setDisName(disName);
            ele.setEleType(0L);
            ele.setId(moId);
            ele.setEntityId(String.valueOf(moId));
            parentEle.addChildEle(ele);
        }
    }

    public Map<String, Set<String>> getDeviceTypeList() {
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, Set<String>> datas = new HashMap<String, Set<String>>();
        for (DeviceTypeRelation relation : devTypeLst) {
            String mainType = relation.getParentType();
            String subType = relation.getChildType();
            HashSet<String> val = (HashSet<String>)datas.get(mainType);
            if (val == null) {
                val = new HashSet<String>();
                datas.put(mainType, val);
            }
            val.add(subType);
        }
        return datas;
    }

    public Map<String, Long> getDeviceTypeState(String mainDevType, Long userId) {
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, Long> stateData = new HashMap<String, Long>();
        for (DeviceTypeRelation relation : devTypeLst) {
            String subType = relation.getChildType();
            this.getDeviceTypeState(mainDevType, subType, userId, stateData);
        }
        return stateData;
    }

    protected void getDeviceTypeState(String mainType, String subType, Long userId, Map<String, Long> stateData) {
        StringBuilder hSqlCount = new StringBuilder();
        hSqlCount.append("select count(*) from TopoObject t where t.mainType=?");
        hSqlCount.append(" and t.subType=?");
        if (userId != null) {
            hSqlCount.append(" and t.moId in (");
            hSqlCount.append(ResourceConstDefine.getHQueryStringbyUserId(userId));
            hSqlCount.append(" )");
        }
        Long count = (Long)this.getHibernateTemplate().find(hSqlCount.toString(), new Object[]{mainType, subType}).listIterator().next();
        stateData.put(subType, count);
    }

    public Map<String, Map<String, Long>> getDeviceTypeState(Long userId) {
        List devTypeLst = this.getHibernateTemplate().loadAll(DeviceTypeRelation.class);
        HashMap<String, Map<String, Long>> datas = new HashMap<String, Map<String, Long>>();
        for (DeviceTypeRelation relation : devTypeLst) {
            String mainType = relation.getParentType();
            String subType = relation.getChildType();
            HashMap<String, Long> stateData = (HashMap<String, Long>)datas.get(mainType);
            if (stateData == null) {
                stateData = new HashMap<String, Long>();
                datas.put(mainType, stateData);
            }
            this.getDeviceTypeState(mainType, subType, userId, stateData);
        }
        return datas;
    }

    public int updateBySql(String sql) {
        return (Integer)super.getHibernateTemplate().execute((HibernateCallback)new HBNCallback(sql));
    }

    private static class HBNCallback
    implements HibernateCallback<Object> {
        private String sql;

        public HBNCallback(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            return session.createSQLQuery(this.sql).executeUpdate();
        }
    }
}

