/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.resource.service;

import com.hs.lego.cbb.resource.common.ResourceConstDefine;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.base.util.ConverterUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceDataExplore
implements IDataExplore {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);
    private ICommonDao commonDao;

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    @Override
    public List<?> getDataList(int begin, int count, TopoObjectQueryCondition condtion) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        return this.commonDao.findPage(this.getHSqlByQueryCondition(condtion, param), begin, count, param);
    }

    @Override
    public long getTotalDataCount(TopoObjectQueryCondition condtion) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        String hSqlPre = "select count(*) " + this.getHSqlByQueryCondition(condtion, param);
        return this.commonDao.getTotalCount(hSqlPre, param);
    }

    @Override
    public List<?> getDataList(TopoObjectQueryCondition queryCondition) {
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        return this.commonDao.findByHql(this.getHSqlByQueryCondition(queryCondition, param), param);
    }

    protected String getHSqlByQueryCondition(TopoObjectQueryCondition queryCondition, Map<Integer, String> param) {
        StringBuilder sql = new StringBuilder();
        if (queryCondition != null) {
            if (null != queryCondition.getDeviceNameLikeQuery() && !"".equals(queryCondition.getDeviceNameLikeQuery())) {
                String deviceName = ConverterUtil.getInstance().convertString(queryCondition.getDeviceNameLikeQuery().trim(), true);
                queryCondition.setDeviceNameLikeQuery(deviceName);
            }
            if (null != queryCondition.getDevIpAddressLikeQuery() && !"".equals(queryCondition.getDevIpAddressLikeQuery())) {
                String ip = ConverterUtil.getInstance().convertString(queryCondition.getDevIpAddressLikeQuery().trim(), true);
                queryCondition.setDevIpAddressLikeQuery(ip);
            }
            String hSqlApp = queryCondition.getQuerySql(param);
            if (queryCondition.getUserId() != null) {
                sql.append("from TopoObject d where d.moId in (");
                sql.append(ResourceConstDefine.getHQueryStringbyUserId(Long.valueOf(queryCondition.getUserId())));
                sql.append(" )");
                if (!hSqlApp.isEmpty()) {
                    sql.append(" and ");
                    sql.append(hSqlApp);
                }
            } else {
                sql.append("from TopoObject");
                if (!hSqlApp.isEmpty()) {
                    sql.append(" d where ");
                    sql.append(hSqlApp);
                }
            }
        } else {
            sql.append("from TopoObject");
        }
        return sql.toString();
    }

    @Override
    public TopoObject getRootMO() {
        String hql = "from TopoObject topo where topo.mainType='lego.dic.legosystem.maintype' and topo.subType='lego.dic.legosystem.subtype' and topo.name=?";
        List topoObjectList = this.commonDao.find(hql, (Object)"Management System");
        if (null != topoObjectList) {
            return (TopoObject)topoObjectList.get(0);
        }
        return new TopoObject();
    }
}

