/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.resource.service;

import com.hs.lego.cbb.resource.dao.DeviceTypeInfoDao;
import com.hs.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.hs.lego.cbb.resource.sdk.model.MainDeviceTypeState;
import com.hs.lego.cbb.resource.sdk.model.TopoObject;
import com.hs.lego.cbb.resource.sdk.service.IDeviceTypeMgr;
import com.hs.lego.cbb.resource.util.InitDeviceTypeData;
import com.hs.lego.core.sdk.util.tree.RootDataElement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SessionFactory;

public class DeviceTypeMgr
implements IDeviceTypeMgr {
    private DeviceTypeInfoDao deviceTypeInfoDao;

    public DeviceTypeMgr() {
    }

    public DeviceTypeMgr(SessionFactory factory) {
        this.deviceTypeInfoDao = new DeviceTypeInfoDao(factory);
    }

    @Override
    public List<TopoObject> getDeviceListByMainTypeName(String mainTypeName) {
        return this.deviceTypeInfoDao.getDevLisetByMainType(mainTypeName);
    }

    @Override
    public List<MainDeviceTypeState> getMainDeviceTypeList() {
        return this.deviceTypeInfoDao.getDeviceStateInfo();
    }

    @Override
    public List<TopoObject> getAllDevice() {
        return this.deviceTypeInfoDao.getAllDevice();
    }

    @Override
    public List<String> getDevSubTypesByMainType(String devMainType) {
        return this.deviceTypeInfoDao.getDevSubTypesByMainType(devMainType);
    }

    @Override
    public Boolean registerDeviceType(DeviceTypeRelation deviceTypeDef) {
        return this.deviceTypeInfoDao.registerDeviceType(deviceTypeDef);
    }

    @Override
    public RootDataElement getDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.deviceTypeInfoDao.getDeviceTypeTree(userId, hiddenTypeWithoutChild);
    }

    @Override
    public RootDataElement getOnlineDeviceTypeTree(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.deviceTypeInfoDao.getOnlineDeviceTypeTree(userId, hiddenTypeWithoutChild);
    }

    @Override
    public RootDataElement getDeviceTypeTreeWithoutDev(Long userId, Boolean hiddenTypeWithoutChild) {
        return this.deviceTypeInfoDao.getDeviceTypeTreeWithoutDev(userId, hiddenTypeWithoutChild);
    }

    @Override
    public RootDataElement getDeviceTypeTreeWithoutDev(Boolean hiddenTypeWithoutChild) {
        return this.deviceTypeInfoDao.getDeviceTypeTreeWithoutDev(hiddenTypeWithoutChild);
    }

    @Override
    public Map<String, Set<String>> getDeviceTypes() {
        return this.deviceTypeInfoDao.getDeviceTypeList();
    }

    @Override
    public Map<String, Map<String, Long>> getDeviceStateInfo(Long userId) {
        return this.deviceTypeInfoDao.getDeviceTypeState(userId);
    }

    @Override
    public Map<String, Long> getDeviceStateInfo(String mainDevType, Long userId) {
        return this.deviceTypeInfoDao.getDeviceTypeState(mainDevType, userId);
    }

    public void start() {
        InitDeviceTypeData devTypeInit = new InitDeviceTypeData();
        devTypeInit.setCommonDao(this.deviceTypeInfoDao);
        devTypeInit.initDevieMap();
    }

    public DeviceTypeInfoDao getDeviceTypeInfoDao() {
        return this.deviceTypeInfoDao;
    }

    public void setDeviceTypeInfoDao(DeviceTypeInfoDao deviceTypeInfoDao) {
        this.deviceTypeInfoDao = deviceTypeInfoDao;
    }
}

