/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.dao.impl;

import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class TaskDAOImpl
extends HibernateDaoSupport
implements ITaskDAO {
    @Override
    public long addTask(Task task) {
        Long id = (Long)super.getHibernateTemplate().save((Object)task);
        return id;
    }

    @Override
    public void updateTask(Task task) {
        Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
        if (null == tempTask) {
            throw new LegoCheckedException(201L);
        }
        super.getHibernateTemplate().merge((Object)task);
    }

    @Override
    public void deleteTask(Task task) {
        Task tempTask = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)task.getTaskId());
        if (null == tempTask) {
            throw new LegoCheckedException(201L);
        }
        super.getHibernateTemplate().delete((Object)task);
    }

    @Override
    public Task readTask(long taskId) {
        Task task = null;
        task = (Task)this.getHibernateTemplate().get(Task.class, (Serializable)Long.valueOf(taskId));
        if (null == task) {
            throw new LegoCheckedException(201L);
        }
        return task;
    }

    @Override
    public List<Task> queryTask(Map<String, Object> condition) {
        String hql = this.getHqlByCondition(condition);
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    @Override
    public Paging findPage(Map<String, Object> condition, int firstRowIndex, int totalRow) {
        String hql = this.getHqlByCondition(condition);
        FindPageHiberCallBack callBack = new FindPageHiberCallBack(hql, firstRowIndex, totalRow);
        List task = (List)this.getHibernateTemplate().execute((HibernateCallback)callBack);
        Paging rePaging = new Paging();
        rePaging.setData(task);
        long iCount = 0L;
        iCount = this.getCount(hql);
        rePaging.setCount((int)iCount);
        return rePaging;
    }

    private String getHqlByCondition(Map<String, Object> condition) {
        StringBuilder hql = new StringBuilder("from Task t where t.taskId > 0 ");
        if (null == condition) {
            return hql.toString();
        }
        String orderKey = "";
        String oerder = "";
        for (Map.Entry<String, Object> entry : condition.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if ("taskName".equalsIgnoreCase(key)) {
                hql.append(" and t.taskName like '%");
                hql.append(value.toString().trim());
                hql.append("%'");
            } else if ("taskType".equalsIgnoreCase(key)) {
                hql.append(" and t.taskType.taskType = '");
                hql.append(value);
                hql.append('\'');
            } else if ("taskLevel".equalsIgnoreCase(key)) {
                hql.append(" and t.taskLevel = ");
                hql.append(value);
            } else if ("taskStatus".equalsIgnoreCase(key)) {
                hql.append(" and t.taskStatus = ");
                hql.append(value);
            } else if ("executeType".equalsIgnoreCase(key)) {
                hql.append(" and t.executeType = ");
                hql.append(value);
            } else if ("taskCategory".equalsIgnoreCase(key)) {
                hql.append(" and t.taskCategory = ");
                hql.append(value);
            }
            if (!key.equalsIgnoreCase("DESC") && !key.equalsIgnoreCase("ASC")) continue;
            oerder = key;
            orderKey = "order by " + value + " ";
        }
        hql.append(orderKey);
        hql.append(oerder);
        return hql.toString();
    }

    public long getCount(String hql) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) ");
        sBufTotle.append(hql);
        return this.getTotalCount(sBufTotle.toString());
    }

    private long getTotalCount(String hql) {
        return (Long)super.getHibernateTemplate().find(hql, new Object[0]).listIterator().next();
    }

    @Override
    public Boolean nameIsExist(String taskName) {
        StringBuilder hql = new StringBuilder("from Task t where t.taskName =?");
        List taskList = super.getHibernateTemplate().find(hql.toString(), new Object[]{taskName});
        if (null != taskList && !taskList.isEmpty()) {
            return true;
        }
        return false;
    }

    private static final class FindPageHiberCallBack
    implements HibernateCallback {
        private String hql;
        private int firstRowIndex;
        private int totalRow;

        public FindPageHiberCallBack(String hql, int firstRowIndex, int totalRow) {
            this.hql = hql;
            this.firstRowIndex = firstRowIndex;
            this.totalRow = totalRow;
        }

        public Object doInHibernate(Session session) {
            Query q = session.createQuery(this.hql);
            q.setFirstResult(this.firstRowIndex);
            q.setMaxResults(this.totalRow);
            return q.list();
        }
    }
}

