/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.cbb.task.manager;

import com.hs.lego.cbb.task.dao.ITaskDAO;
import com.hs.lego.cbb.task.dao.ITaskResultDAO;
import com.hs.lego.cbb.task.manager.ITaskManager;
import com.hs.lego.cbb.task.manager.service.ISchedulerService;
import com.hs.lego.cbb.task.sdk.TaskTimeUtil;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskType;
import com.hs.lego.cbb.task.sdk.service.TaskExecuteType;
import com.hs.lego.cbb.task.sdk.service.TaskPeriodType;
import com.hs.lego.cbb.task.sdk.service.TaskStatus;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.service.IRegistryPointManager;
import com.hs.lego.core.sdk.base.event.StatusChangedEvent;
import com.hs.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.hs.lego.core.sdk.base.model.Status;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.quartz.JobDataMap;
import org.quartz.impl.JobDetailImpl;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TaskManager
implements ITaskManager,
SystemStatusChangedListener,
DisposableBean,
IRegistryChangeListener,
InitializingBean {
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private IRegistryPointManager regPointMgr;
    private IExtensionRegistry registry;
    private ISchedulerService scheduler;
    private ITaskDAO taskDao;
    private ITaskResultDAO taskResultDao;
    private Map<String, Class<?>> jobBeanMap = new HashMap();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void start(Task task) {
        TaskType type = task.getTaskType();
        if (null == type) return;
        Class<?> cl = this.getClassLoader(type);
        if (null == cl) {
            return;
        }
        JobDetailImpl jobDetail = new JobDetailImpl(type.getTaskTypeName(), "DEFAULT", cl);
        JobDataMap data = this.getJobData(task);
        String name = this.getTaskName(task);
        if (TaskExecuteType.single.getValue() == task.getExecuteType().intValue()) {
            Date currentTime;
            Date baseTime = task.getBaseTime();
            if (baseTime.after(currentTime = new Date())) {
                jobDetail.setDurability(false);
                this.scheduler.schedule(jobDetail, name, task.getBaseTime(), data);
                return;
            }
            task.setTaskStatus(TaskStatus.finish.getValue());
            task.setNextTime(null);
            this.taskDao.updateTask(task);
            this.log.error((Object)(name + " should be finish! "));
            return;
        }
        Date endDate = null;
        endDate = null != task.getEndTime() ? task.getEndTime() : TaskTimeUtil.getEndDateWithCount(task);
        Date now = new Date();
        if (null != endDate && endDate.before(now)) {
            task.setTaskStatus(TaskStatus.finish.getValue());
            task.setNextTime(null);
            this.taskDao.updateTask(task);
            this.log.error((Object)(name + " should be finish! "));
            return;
        }
        Calendar runTime = Calendar.getInstance();
        runTime.setTime(task.getBaseTime());
        StringBuilder cronExpression = this.getCronExpression(runTime, task);
        Date baseTime = task.getBaseTime();
        jobDetail.setDurability(true);
        this.scheduler.schedule(jobDetail, this.getTaskName(task), baseTime, endDate, cronExpression.toString(), data);
    }

    private Class<?> getClassLoader(TaskType type) {
        Class<?> cl = null;
        try {
            ClassLoader loader;
            cl = this.jobBeanMap.get(type.getTaskTypeClassName());
            if (null == cl && null != (loader = this.getClass().getClassLoader())) {
                cl = loader.loadClass(type.getTaskTypeClassName());
            }
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)(type.getTaskTypeClassName() + " Not Found! "), (Throwable)e);
        }
        return cl;
    }

    private StringBuilder getCronExpression(Calendar runTime, Task task) {
        StringBuilder cronExpression = new StringBuilder();
        cronExpression.append(runTime.get(13));
        cronExpression.append(' ');
        cronExpression.append(runTime.get(12));
        cronExpression.append(' ');
        cronExpression.append(runTime.get(11));
        cronExpression.append(' ');
        if (TaskPeriodType.date.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append("* * ?");
        } else if (TaskPeriodType.week.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append("? * ");
            cronExpression.append(runTime.get(7));
        } else if (TaskPeriodType.month.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(runTime.get(5));
            cronExpression.append(" * ?");
        }
        return cronExpression;
    }

    @Override
    public void stop(Task task) {
        this.scheduler.stop(this.getTaskName(task));
    }

    @Override
    public void pause(Task task) {
        this.scheduler.pause(this.getTaskName(task));
    }

    @Override
    public void resume(Task task) {
        this.scheduler.resume(this.getTaskName(task));
    }

    @Override
    public void runAtOnce(Task task) {
        this.scheduler.runAtOnce(this.getTaskName(task), this.getJobData(task), task.getTaskType().getTaskTypeName());
    }

    private String getTaskName(Task task) {
        String name = null;
        if (null != task && null != task.getTaskType()) {
            name = task.getTaskType().getTaskTypeClassName() + "-" + task.getTaskId();
        }
        return name;
    }

    private JobDataMap getJobData(Task task) {
        JobDataMap data = new JobDataMap();
        data.put("task", (Object)task);
        data.put("taskdao", (Object)this.taskDao);
        data.put("taskresultdao", (Object)this.taskResultDao);
        return data;
    }

    public void afterPropertiesSet() {
        List<Task> tasks;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskStatus", TaskStatus.idle.getValue());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("taskStatus", TaskStatus.running.getValue());
        List<Task> taskRunings = this.taskDao.queryTask(param);
        if (null != taskRunings && !taskRunings.isEmpty()) {
            for (Task task : taskRunings) {
                task.setTaskStatus(TaskStatus.idle.getValue());
                this.taskDao.updateTask(task);
            }
        }
        if (null != (tasks = this.taskDao.queryTask(params)) && !tasks.isEmpty()) {
            for (Task task : tasks) {
                try {
                    this.start(task);
                }
                catch (Exception e) {
                    this.log.error((Object)(task.getTaskName() + " start error   "), (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public void setScheduler(ISchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    private void initExtension() {
        List<IExtension> extensions;
        Properties props = new Properties();
        props.setProperty("task", "com.hs.lego.cbb.task");
        Map<String, List<IExtension>> map = this.regPointMgr.createRegistryPoints(this, this.registry, props);
        if (!map.isEmpty() && !(extensions = map.get("com.hs.lego.cbb.task")).isEmpty()) {
            for (IExtension ext : extensions) {
                IConfigurationElement[] elements;
                for (IConfigurationElement configurationElement : elements = ext.getConfigurationElements()) {
                    this.inintJobBeanMap(configurationElement);
                }
            }
        }
    }

    private void inintJobBeanMap(IConfigurationElement configurationElement) {
    }

    public void setRegPointMgr(IRegistryPointManager regPointMgr) {
        this.regPointMgr = regPointMgr;
    }

    public void setRegistry(IExtensionRegistry registry) {
        this.registry = registry;
    }

    public void registryChanged(IRegistryChangeEvent arg0) {
    }

    @Override
    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_INIT) {
            this.initExtension();
        }
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }

    public ITaskDAO getTaskDao() {
        return this.taskDao;
    }

    public ITaskResultDAO getTaskResultDao() {
        return this.taskResultDao;
    }

    public void setTaskResultDao(ITaskResultDAO taskResultDao) {
        this.taskResultDao = taskResultDao;
    }

    public ISchedulerService getScheduler() {
        return this.scheduler;
    }
}

