/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.com.south.sdk.ping;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LegoPing {
    private static final Log SLOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int MAX_STRING_SIZE = 10240;
    private String osname = System.getProperty("os.name");
    private String pingCmd = "ping -w 0 -n 1";
    private String pingPath = null;
    private String localip = this.getLocalhostIp();
    private int numTry = 3;

    public boolean ping(String host, int retries, int pingTimeout) {
        boolean result = this.execPing(host, retries, pingTimeout);
        if (!result) {
            SLOGGER.info((Object)("ping failed: " + host));
        }
        return result;
    }

    private String getLocalhostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            SLOGGER.error((Object)"get localaddess failed: ", (Throwable)e);
            return null;
        }
    }

    private String getSolarisPing(String host) {
        this.pingCmd = null == this.localip ? (null == this.pingPath ? "/usr/sbin/ping " : this.pingPath) : (null == this.pingPath ? "/usr/sbin/ping -i " + this.localip : this.pingPath + " -i" + " " + this.localip);
        return this.pingCmd + " " + host + " " + this.numTry;
    }

    private String getLinuxPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "/bin/ping -c " + retries + " -w " + this.numTry : this.pingPath + " -c " + retries + " -w" + " " + this.numTry;
        return this.pingCmd + " " + host;
    }

    private String getFreeBSDPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "/sbin/ping -c " + retries : this.pingPath + " -c " + retries;
        return this.pingCmd + " " + host;
    }

    private String getWindowsPing(String host, int retries, int pingTimeout) {
        this.pingCmd = null == this.pingPath ? "ping -n " + retries + " -w" : this.pingPath + " -n " + retries + " -w";
        return this.pingCmd + " " + pingTimeout * 1000 + " " + host;
    }

    private String getNonWinPing(String host, int retries) {
        this.pingCmd = null == this.pingPath ? "ping -n " + retries : this.pingPath + " -n " + retries;
        return this.pingCmd + " " + host;
    }

    private boolean execPing(String host, int retries, int pingTimeout) {
        String cmd = this.pingCmd + " " + host;
        SLOGGER.debug((Object)("osname:" + this.osname));
        if (this.osname.startsWith("SunOS") || this.osname.startsWith("Solaris")) {
            cmd = this.getSolarisPing(host);
        } else if (this.osname.startsWith("Linux")) {
            cmd = this.getLinuxPing(host, retries);
        } else if (this.osname.startsWith("FreeBSD")) {
            cmd = this.getFreeBSDPing(host, retries);
        } else if (this.osname.toLowerCase(Locale.US).contains("windows")) {
            cmd = this.getWindowsPing(host, retries, pingTimeout);
        } else if (!this.osname.startsWith("Windows")) {
            cmd = this.getNonWinPing(host, retries);
        }
        return this.execCmd(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execCmd(String pingCmdTemp) {
        String[] para = pingCmdTemp.split("\\s+");
        ProcessBuilder pb = new ProcessBuilder(para);
        pb.redirectErrorStream(true);
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e1) {
            SLOGGER.error((Object)"execCmd IOException error");
        }
        InputStreamReader ir = null;
        BufferedReader input = null;
        if (null == process) {
            SLOGGER.error((Object)"execCmd init process object occurs error, then process is null.");
            return false;
        }
        try {
            String line;
            ArrayList<String> reponse = new ArrayList<String>();
            ir = new InputStreamReader(process.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            while ((line = ((LineNumberReader)input).readLine()) != null && line.length() <= 10240 && reponse.size() <= 10240) {
                if ("".equals(line)) continue;
                reponse.add(line);
            }
            if (this.osname.toLowerCase(Locale.US).contains("windows")) {
                boolean bl = this.parseWindowsResult(reponse);
                return bl;
            }
            if (this.osname.startsWith("Linux") || this.osname.startsWith("FreeBSD")) {
                boolean bl = this.parseLinuxResult(reponse);
                return bl;
            }
            SLOGGER.error((Object)("none support os: " + this.osname));
        }
        catch (IOException ex) {
            SLOGGER.error((Object)"parse response execCmd occurs error.");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    SLOGGER.error((Object)"close io occurs error");
                }
            }
            if (null != ir) {
                try {
                    ir.close();
                }
                catch (IOException e) {
                    SLOGGER.error((Object)"close io occurs error");
                }
            }
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                SLOGGER.error((Object)"close io occurs error", (Throwable)e);
            }
        }
        return false;
    }

    private boolean parseWindowsResult(List<String> result) {
        for (String line : result) {
            if (line.indexOf("s TTL=") == -1) continue;
            return true;
        }
        return false;
    }

    private boolean parseLinuxResult(List<String> result) {
        for (String line : result) {
            if (line.indexOf("64 bytes from") == -1) continue;
            return true;
        }
        return false;
    }

    public String getPingPath() {
        return this.pingPath;
    }

    public void setPingPath(String pingPath) {
        this.pingPath = pingPath;
    }
}

