/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.com.south.sdk.ping;

import com.hs.lego.com.south.sdk.ping.LegoPing;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.webnms.sdk.service.IPingService;
import java.util.List;

public class PingServiceImpl
implements IPingService {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private int timeout = 10;
    private int retries = 1;
    private LegoPing legoPing = new LegoPing();

    @Override
    public boolean ping(String host) {
        return this.ping(host, this.retries, this.timeout);
    }

    @Override
    public boolean ping(String host, int retriesTemp, int timeoutTemp) {
        try {
            int i = 0;
            if (i < retriesTemp) {
                return this.legoPing.ping(host, retriesTemp, this.timeout);
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error((Object)"ping IOException");
            return false;
        }
    }

    @Override
    public Boolean[] batchPing(List<String> ipList, int retriesTemp, int timeoutTemp) {
        Boolean[] result = new Boolean[ipList.size()];
        for (int i = 0; i < ipList.size(); ++i) {
            boolean res = this.ping(ipList.get(i), retriesTemp, timeoutTemp);
            result[i] = res;
        }
        return result;
    }

    @Override
    public int getPingTimeout() {
        return this.timeout;
    }

    @Override
    public void setPingTimeout(int timeoutTemp) {
        this.timeout = timeoutTemp;
    }
}

