/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.cache;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ICacheService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;

public class CacheService
implements ICacheService<String, Object>,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private ICacheService<String, Object> cache;
    private final Object lock = new Object();

    @Override
    public boolean clear() {
        if (null != this.cache) {
            return this.cache.clear();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.containsKey(key);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.keySet();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.put(key, value);
            }
            return null;
        }
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        if (null != this.cache) {
            return this.cache.put(key, value, expiry);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value, int ttl) {
        if (null != this.cache) {
            return this.cache.put(key, value, ttl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(String key) {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.remove(key);
            }
            return null;
        }
    }

    @Override
    public int size() {
        if (null != this.cache) {
            return this.cache.size();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Object> values() {
        Object object = this.lock;
        synchronized (object) {
            if (null != this.cache) {
                return this.cache.values();
            }
            return null;
        }
    }

    public void setCache(ICacheService<String, Object> cache) {
        this.cache = cache;
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean containsKey(String key, boolean updateTime) {
        if (null != this.cache) {
            return this.cache.containsKey(key, updateTime);
        }
        return false;
    }

    @Override
    public Object get(String key, boolean updateTime) {
        if (null != this.cache) {
            return this.cache.get(key, updateTime);
        }
        return false;
    }

    @Override
    public Set<String> keySet(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.keySet(updateTime);
        }
        return null;
    }

    @Override
    public int size(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.size(updateTime);
        }
        return 0;
    }

    @Override
    public Collection<Object> values(boolean updateTime) {
        if (null != this.cache) {
            return this.cache.values(updateTime);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decreaseCachedDataCount(String key) {
        Object object = this.lock;
        synchronized (object) {
            Long inCount = (Long)this.get(key);
            if (inCount == null) {
                LOGGER.warn((Object)("the key does not exist, key is : " + key));
            } else if (inCount > 0L) {
                inCount = inCount - 1L;
                this.put(key, (Object)inCount);
            }
            LOGGER.info((Object)("decreaseCachedDataCount, theeeee key is : " + key + ", value is : " + inCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increaseCachedDataCount(String key) {
        Object object = this.lock;
        synchronized (object) {
            Long inCount = (Long)this.get(key);
            if (inCount == null) {
                this.put(key, (Object)1L);
            } else {
                inCount = inCount + 1L;
                this.put(key, (Object)inCount);
            }
            LOGGER.info((Object)("increaseCachedDataCounts, theeeee key is : " + key + ", value is : " + inCount));
        }
    }
}

