/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.cache.local;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ICacheService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class LocalCacheImpl
implements ICacheService<String, Object> {
    private static final int NUM_1000 = 1000;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private ConcurrentHashMap<String, Object>[] caches;
    private ConcurrentHashMap<String, Long> expiryCache;
    private ConcurrentHashMap<String, Integer> intervalCache;
    private ConcurrentHashMap<String, Integer> saveToCache;
    private ScheduledExecutorService scheduleService;
    private int expiryInterval = 10;
    private int moduleSize = 10;

    public LocalCacheImpl() {
        this.init();
    }

    public LocalCacheImpl(int expiryInterval, int moduleSize) {
        this.expiryInterval = expiryInterval;
        this.moduleSize = moduleSize;
        this.init();
    }

    private void init() {
        this.caches = new ConcurrentHashMap[this.moduleSize];
        for (int i = 0; i < this.moduleSize; ++i) {
            this.caches[i] = new ConcurrentHashMap();
        }
        this.expiryCache = new ConcurrentHashMap();
        this.intervalCache = new ConcurrentHashMap();
        this.saveToCache = new ConcurrentHashMap();
        this.scheduleService = Executors.newScheduledThreadPool(1);
        this.scheduleService.scheduleAtFixedRate(new CheckOutOfDateSchedule(this.caches, this.expiryCache), 0L, (long)this.expiryInterval * 60L, TimeUnit.SECONDS);
        this.log.info((Object)"Local Cache CheckService is start!");
    }

    @Override
    public boolean clear() {
        if (this.caches != null) {
            for (ConcurrentHashMap<String, Object> cache : this.caches) {
                cache.clear();
            }
        }
        if (this.expiryCache != null) {
            this.expiryCache.clear();
        }
        if (this.intervalCache != null) {
            this.intervalCache.clear();
        }
        return true;
    }

    @Override
    public boolean containsKey(String key) {
        this.checkValidate(key);
        return this.getCache(key).containsKey(key);
    }

    @Override
    public boolean containsKey(String key, boolean updateTime) {
        this.checkValidate(key, true);
        return this.getCache(key).containsKey(key);
    }

    @Override
    public Object get(String key) {
        this.checkValidate(key);
        return this.getCache(key).get(key);
    }

    @Override
    public Object get(String key, boolean updateTime) {
        this.checkValidate(key, true);
        return this.getCache(key).get(key);
    }

    @Override
    public Set<String> keySet() {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    @Override
    public Set<String> keySet(boolean updateTime) {
        this.checkAll();
        return this.expiryCache.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        Object result = this.getCache(key).put(key, value);
        this.expiryCache.put(key, -1L);
        return result;
    }

    @Override
    public Object put(String key, Object value, Date expiry) {
        Date now = new Date();
        int ttl = (int)(expiry.getTime() - now.getTime()) / 1000;
        this.saveToCache.put(key, ttl);
        return this.put(key, value, ttl);
    }

    @Override
    public Object put(String key, Object value, int ttl) {
        Object result = this.getCache(key).put(key, value);
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, ttl);
        this.expiryCache.put(key, calendar.getTime().getTime());
        this.intervalCache.put(key, ttl);
        return result;
    }

    @Override
    public Object remove(String key) {
        Object result = this.getCache(key).remove(key);
        this.expiryCache.remove(key);
        this.intervalCache.remove(key);
        return result;
    }

    @Override
    public int size() {
        this.checkAll();
        return this.expiryCache.size();
    }

    @Override
    public int size(boolean updateTime) {
        this.checkAll(updateTime);
        return this.expiryCache.size();
    }

    @Override
    public Collection<Object> values() {
        this.checkAll();
        ArrayList<Object> values = new ArrayList<Object>();
        for (ConcurrentHashMap<String, Object> cache : this.caches) {
            values.addAll(cache.values());
        }
        return values;
    }

    @Override
    public Collection<Object> values(boolean updateTime) {
        this.checkAll(updateTime);
        ArrayList<Object> values = new ArrayList<Object>();
        for (ConcurrentHashMap<String, Object> cache : this.caches) {
            values.addAll(cache.values());
        }
        return values;
    }

    private ConcurrentHashMap<String, Object> getCache(String key) {
        long hashCode = key.hashCode();
        if (hashCode < 0L) {
            hashCode = -hashCode;
        }
        int moudleNum = (int)hashCode % this.moduleSize;
        return this.caches[moudleNum];
    }

    private void checkValidate(String key) {
        if (null == key) {
            return;
        }
        if (this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                this.saveToCache.remove(key);
            }
        } else {
            if (null != this.saveToCache && this.saveToCache.get(key) != null) {
                return;
            }
            if (this.intervalCache.get(key) == null) {
                return;
            }
            int ttl = this.intervalCache.get(key);
            Object value = this.getCache(key).get(key);
            this.put(key, value, ttl);
        }
    }

    private void checkValidate(String key, boolean updateTime) {
        this.log.info((Object)("updateTime: " + updateTime));
        if (key != null && this.expiryCache.get(key) != null && this.expiryCache.get(key) != -1L && new Date(this.expiryCache.get(key)).before(new Date())) {
            this.getCache(key).remove(key);
            this.expiryCache.remove(key);
            this.intervalCache.remove(key);
        }
    }

    private void checkAll() {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key);
        }
    }

    private void checkAll(boolean updateTime) {
        for (String key : this.expiryCache.keySet()) {
            this.checkValidate(key, updateTime);
        }
    }

    @Override
    public void destroy() {
        try {
            this.clear();
            if (this.scheduleService != null) {
                this.scheduleService.shutdown();
            }
            this.scheduleService = null;
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
        }
        this.log.info((Object)"Destory local cache resources.");
    }

    @Override
    public void decreaseCachedDataCount(String key) {
    }

    @Override
    public void increaseCachedDataCount(String key) {
    }

    class CheckOutOfDateSchedule
    implements Runnable {
        ConcurrentHashMap<String, Object>[] caches;
        ConcurrentHashMap<String, Long> expiryCache;

        public CheckOutOfDateSchedule(ConcurrentHashMap<String, Object>[] caches, ConcurrentHashMap<String, Long> expiryCache) {
            this.caches = caches;
            this.expiryCache = expiryCache;
        }

        @Override
        public void run() {
            this.check();
        }

        public void check() {
            for (ConcurrentHashMap<String, Object> cache : this.caches) {
                for (String key : cache.keySet()) {
                    long date;
                    if (this.expiryCache.get(key) == null || (date = this.expiryCache.get(key).longValue()) <= 0L || !new Date(date).before(new Date())) continue;
                    this.doRemoveCache(cache, key);
                }
            }
        }

        private void doRemoveCache(ConcurrentHashMap<String, Object> cache, String key) {
            if (LocalCacheImpl.this.saveToCache.containsKey(key)) {
                LocalCacheImpl.this.saveToCache.remove(key);
            }
            LocalCacheImpl.this.intervalCache.remove(key);
            this.expiryCache.remove(key);
            cache.remove(key);
        }
    }
}

