/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.base.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;

class LegoDBProperties {
    public static final String MYSQL = "mysql";
    public static final String SQLSERVER = "sqlserver";
    private static final String LEGO_PROPERTIES = "lego.properties";
    private static final Properties PROPS = new Properties();
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    private LegoDBProperties() {
    }

    public static String getDBType() {
        String dbType = MYSQL;
        String value = PROPS.getProperty("hibernate.connection.url");
        if (null != value && value.toLowerCase(Locale.US).indexOf(SQLSERVER) >= 0) {
            dbType = SQLSERVER;
        }
        return dbType;
    }

    static {
        InputStream instream = null;
        try {
            ClassLoader loader = LegoDBProperties.class.getClassLoader();
            if (loader == null) {
                throw new IOException();
            }
            instream = loader.getResourceAsStream(LEGO_PROPERTIES);
            if (instream == null) {
                throw new IOException();
            }
            PROPS.load(instream);
        }
        catch (IOException e) {
            log.error((Object)"read lego.properties fail.");
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream of lego.properties fail.");
                }
            }
        }
    }
}

