/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.structure;

import com.hs.lego.core.sdk.base.event.ApplicationStatusChangedListener;
import com.hs.lego.core.sdk.base.event.EventTrigger;
import com.hs.lego.core.sdk.base.event.StatusChangedListener;
import com.hs.lego.core.sdk.base.model.AppInfo;
import com.hs.lego.core.sdk.base.model.ServiceInfo;
import com.hs.lego.core.sdk.base.model.Status;
import com.hs.lego.core.sdk.base.structure.IApplication;
import com.hs.lego.core.sdk.base.structure.ICallback;
import com.hs.lego.core.sdk.base.structure.ILifecycle;
import com.hs.lego.core.sdk.base.structure.IService;
import com.hs.lego.core.sdk.base.structure.ISystem;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbsApplication
implements IApplication,
ILifecycle,
DisposableBean {
    protected List<IService> services = new ArrayList<IService>();
    protected List<StatusChangedListener> listeners = new ArrayList<StatusChangedListener>();
    protected AppInfo appinfo;
    protected ISystem container;
    protected Status status;
    private ClassLoader curLoader;
    private String identify;
    private final Object lock = new Object();

    public void setIdentify(String uuid) {
        this.identify = uuid;
    }

    public String getIdentify() {
        return this.identify;
    }

    public ClassLoader getCurLoader() {
        return this.curLoader;
    }

    public void setCurLoader(ClassLoader curLoader) {
        this.curLoader = curLoader;
    }

    @Override
    public void registerService(IService service) {
    }

    @Override
    public void setContainer(ISystem container) {
        this.container = container;
    }

    public ISystem getContainer() {
        return this.container;
    }

    @Override
    public AppInfo getInfor() {
        return this.appinfo;
    }

    @Override
    public void setAppInfor(AppInfo appInfor) {
        this.appinfo = appInfor;
    }

    @Override
    public IApplication getSelf() {
        return this;
    }

    public void addService(IService service) {
        this.services.add(service);
    }

    public List<IService> getServices() {
        return this.services;
    }

    @Override
    @Deprecated
    public void initialize(ICallback[] callback) {
        Thread.currentThread().setContextClassLoader(this.container.getContextClassLoader());
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                this.container.publishService(this.appinfo, service);
                ((ILifecycle)((Object)service)).initialize(callback);
            }
        }
        Thread.currentThread().setContextClassLoader(this.curLoader);
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    public void start(List<ICallback> callback) {
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                ((ILifecycle)((Object)service)).start(callback);
            }
        }
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    @Deprecated
    public void stop(ICallback[] callback) {
        if (null == this.appinfo) {
            return;
        }
        List<ServiceInfo<?>> srvInfors = this.appinfo.getServices();
        if (!srvInfors.isEmpty()) {
            Iterator<ServiceInfo<?>> iterator = srvInfors.iterator();
            while (iterator.hasNext()) {
                ServiceInfo<?> srvInfor = iterator.next();
                IService service = (IService)srvInfor.getService();
                if (service instanceof ILifecycle) {
                    ((ILifecycle)((Object)service)).stop(callback);
                }
                this.container.unpublishService(service);
                iterator.remove();
            }
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    @Override
    public void initialize(List<ICallback> callback) {
        Thread.currentThread().setContextClassLoader(this.container.getContextClassLoader());
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                this.container.publishService(this.appinfo, service);
                ((ILifecycle)((Object)service)).initialize(callback);
            }
        }
        Thread.currentThread().setContextClassLoader(this.curLoader);
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_INIT);
    }

    @Override
    @Deprecated
    public void start(ICallback[] callback) {
        if (!this.services.isEmpty()) {
            for (IService service : this.services) {
                if (!(service instanceof ILifecycle)) continue;
                ((ILifecycle)((Object)service)).start(callback);
            }
        }
        for (ICallback call : callback) {
            call.invoke(this);
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_STARTED);
    }

    @Override
    public void stop(List<ICallback> callback) {
        if (null == this.appinfo) {
            return;
        }
        List<ServiceInfo<?>> srvInfors = this.appinfo.getServices();
        if (!srvInfors.isEmpty()) {
            Iterator<ServiceInfo<?>> iterator = srvInfors.iterator();
            while (iterator.hasNext()) {
                ServiceInfo<?> srvInfor = iterator.next();
                IService service = (IService)srvInfor.getService();
                if (service instanceof ILifecycle) {
                    ((ILifecycle)((Object)service)).stop(callback);
                }
                this.container.unpublishService(service);
                iterator.remove();
            }
        }
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_STOPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusChangeListener(EventListener listener) {
        if (listener instanceof ApplicationStatusChangedListener) {
            Object object = this.lock;
            synchronized (object) {
                this.listeners.add((ApplicationStatusChangedListener)listener);
            }
        }
    }

    public List<StatusChangedListener> getStatusChangeLiserners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remStatusChangeListener(EventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Status getCurrentStatus() {
        return this.status;
    }

    @Override
    public void setCurrentStatus(Status statusParam) {
        this.status = statusParam;
    }

    public void destroy() {
        this.stop(new ArrayList<ICallback>());
        EventTrigger.getInstance().fireEventListener(this, this.listeners, Status.STATUS_DESTROYED);
        this.listeners.clear();
    }
}

