/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class ExcelFileUtil
extends FileUtil {
    public static final int DATA_START_ROW = 3;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int NUM_2 = 2;
    private static final int COLUMNWIDTH = 8000;
    private HSSFWorkbook workbook = new HSSFWorkbook();
    private FileOutputStream writeFileOut;

    public ExcelFileUtil() {
        this.setStrExtend("xls");
    }

    @Override
    public void writeFile(List<List<String>> dataLst) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found exception");
            return;
        }
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
        cellTitle.setCellType(1);
        cellTitle.setCellValue(this.getTitle());
        HSSFRow rowColUsr = sheet.createRow(1);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(2);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(1);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.RED.index);
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.GREEN.index);
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 3;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(1);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(lstStr.get(cellNumOfRow));
                    continue;
                }
                cell.setCellValue("");
            }
            ++rowNumOfSheet;
        }
    }

    @Override
    public void closeFile() throws IOException {
        if (null != this.getWriteFileOut()) {
            this.workbook.write((OutputStream)this.getWriteFileOut());
            this.getWriteFileOut().flush();
            this.getWriteFileOut().close();
        }
    }

    public FileOutputStream getWriteFileOut() {
        return this.writeFileOut;
    }

    public void setWriteFileOut(FileOutputStream writeFileOut) {
        this.writeFileOut = writeFileOut;
    }

    @Override
    public void writeFile(List<List<String>> dataLst, String detailPath) {
        if (this.getWriteFileName() == null) {
            return;
        }
        try {
            this.writeFileOut = new FileOutputStream(this.getWriteFileName());
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"file not found exception");
            return;
        }
        int num = this.getColTitle().size();
        HSSFSheet sheet = this.workbook.createSheet();
        HSSFRow rowTitle = sheet.createRow(0);
        HSSFCell cellTitle = rowTitle.createCell((int)((short)(num / 2)));
        cellTitle.setCellType(1);
        cellTitle.setCellValue(this.getTitle());
        HSSFRow rowColUsr = sheet.createRow(1);
        HSSFCell cellUsr = rowColUsr.createCell(0);
        cellUsr.setCellValue(this.getStrUsrName());
        HSSFCell cellTime = rowColUsr.createCell(1);
        cellTime.setCellValue(ExcelFileUtil.getNowTime());
        HSSFRow rowColTitle = sheet.createRow(2);
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            HSSFCell cellColTitle = rowColTitle.createCell(i);
            cellColTitle.setCellType(1);
            cellColTitle.setCellValue(this.getColTitle().get(i));
        }
        HSSFCellStyle styleRed = this.workbook.createCellStyle();
        HSSFCellStyle styleGreen = this.workbook.createCellStyle();
        HSSFFont fontRed = this.workbook.createFont();
        fontRed.setColor(HSSFColor.RED.index);
        HSSFFont fontGreen = this.workbook.createFont();
        fontGreen.setColor(HSSFColor.GREEN.index);
        styleRed.setFont(fontRed);
        styleGreen.setFont(fontGreen);
        int rowNumOfSheet = 3;
        for (List<String> lstStr : dataLst) {
            HSSFRow row = sheet.createRow(rowNumOfSheet);
            for (int cellNumOfRow = 0; cellNumOfRow < lstStr.size(); cellNumOfRow = (int)((short)(cellNumOfRow + 1))) {
                HSSFCell cell = row.createCell(cellNumOfRow);
                cell.setCellType(1);
                if (null != lstStr.get(cellNumOfRow)) {
                    cell.setCellValue(lstStr.get(cellNumOfRow));
                } else {
                    cell.setCellValue("");
                }
                String logId = lstStr.get(lstStr.size() - 1);
                if (logId == null || cellNumOfRow != lstStr.size() - 1) continue;
                HSSFCellStyle linkStyle = this.workbook.createCellStyle();
                HSSFFont font = this.workbook.createFont();
                font.setFontName("Arial");
                font.setUnderline((byte)1);
                font.setColor(HSSFColor.BLUE.index);
                linkStyle.setFont(font);
                String strVal = "";
                if (null != lstStr.get(cellNumOfRow)) {
                    strVal = lstStr.get(cellNumOfRow);
                }
                cell.setCellStyle(linkStyle);
                cell.setCellFormula("HYPERLINK(\"" + detailPath + logId + ".txt\",\"" + strVal + "\")");
            }
            ++rowNumOfSheet;
        }
    }
}

