/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.file.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileZip {
    private static FileZip instance = new FileZip();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String inputFilePath, String zipFilePath, String baseName) {
        ZipOutputStream zOut = null;
        try {
            zOut = new ZipOutputStream(new FileOutputStream(new String(zipFilePath.getBytes("gb2312"), "utf-8")));
            LOGGER.debug((Object)"zip-->begin");
            FileZip.zip(zOut, new File(inputFilePath), baseName);
            LOGGER.debug((Object)"zip-->end");
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"file not found exception");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Exception", (Throwable)e);
        }
        finally {
            try {
                if (zOut != null) {
                    zOut.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zOut, File file, String base) {
        FileInputStream in = null;
        try {
            LOGGER.info((Object)("zip file-->" + file.getName()));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                if (null != listFiles) {
                    zOut.putNextEntry(new ZipEntry(base + "/"));
                    base = base.length() == 0 ? "" : base + "/";
                    for (int i = 0; i < listFiles.length; ++i) {
                        FileZip.zip(zOut, listFiles[i], base + listFiles[i].getName());
                    }
                }
            } else {
                if (base.equals("")) {
                    base = file.getName();
                }
                zOut.putNextEntry(new ZipEntry(base));
                LOGGER.info((Object)(file.getPath() + "," + base));
                in = new FileInputStream(file);
                byte[] content = new byte[40960];
                while (in.read(content) != -1) {
                    zOut.write(content);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)"file not found exception");
        }
        catch (IOException e) {
            LOGGER.error((Object)"IOException error");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception", (Throwable)e);
            }
        }
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                Boolean result = file.delete();
                if (!result.booleanValue()) {
                    LOGGER.error((Object)"del file error");
                }
            } else if (file.isDirectory()) {
                Boolean result;
                File[] files = file.listFiles();
                if (null != files) {
                    for (int i = 0; i < files.length; ++i) {
                        this.deleteFile(files[i]);
                    }
                }
                if (!(result = Boolean.valueOf(file.delete())).booleanValue()) {
                    LOGGER.error((Object)"del file error");
                }
            }
        } else {
            LOGGER.error((Object)"file is not exzist");
        }
    }

    public static FileZip getInstance() {
        return instance;
    }
}

