/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class AESUtil {
    public static String parseByte2HexStr(byte[] byteBuffer) {
        String result = "";
        StringBuffer buf = new StringBuffer();
        buf.append(result);
        for (int i = 0; i < byteBuffer.length; ++i) {
            String hexStr = Integer.toHexString(byteBuffer[i] & 0xFF);
            if (hexStr.length() == 1) {
                hexStr = "0" + hexStr;
            }
            buf.append(hexStr);
        }
        result = buf.toString();
        return result;
    }

    public static byte[] parseHexStr2Byte(String parseHex) {
        if (parseHex == null || parseHex.length() < 1) {
            return new byte[0];
        }
        byte[] returnByte = new byte[parseHex.length() / 2];
        for (int j = 0; j < parseHex.length() / 2; ++j) {
            int highHex = Integer.parseInt(parseHex.substring(j * 2, j * 2 + 1), 16);
            int lowHex = Integer.parseInt(parseHex.substring(j * 2 + 1, j * 2 + 2), 16);
            returnByte[j] = (byte)(highHex * 16 + lowHex);
        }
        return returnByte;
    }

    public static String getPBKDF2SHA256Pwd(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String algorithm = "PBKDF2WithHmacSHA256";
        int derivedKeyLength = 256;
        int iterations = 10000;
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), new byte[32], iterations, derivedKeyLength);
        SecretKeyFactory f = SecretKeyFactory.getInstance(algorithm);
        byte[] secPwd = f.generateSecret(spec).getEncoded();
        return AESUtil.parseByte2HexStr(secPwd);
    }
}

