/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class AddressUtil {
    private static final String INSTALLED_IPADDRESS_PROP = "nms.server.host";
    private static final String INSTALLED_IPADDRESS_COLLECTOR = "rmi.server.hostname";
    private static final String DEFAULT_IPADDRESS = "127.0.0.1";
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    private AddressUtil() {
    }

    public static boolean checkLocalIP(String ip) {
        if (null == ip || ip.length() <= 0) {
            return false;
        }
        if (DEFAULT_IPADDRESS.equals(ip)) {
            return true;
        }
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> ifs = NetworkInterface.getNetworkInterfaces();
            if (null == ifs) {
                return false;
            }
            while (ifs.hasMoreElements()) {
                Enumeration<InetAddress> addrs = ifs.nextElement().getInetAddresses();
                while (addrs.hasMoreElements()) {
                    if (!ip.equals(addrs.nextElement().getHostAddress())) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return false;
    }

    public static String getLocalIP() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        String hostName = addr.getHostName();
        InetAddress[] ipsAddr = null;
        try {
            ipsAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        if (ipsAddr.length > 0) {
            return ipsAddr[0].getHostAddress();
        }
        return "";
    }

    public static String getRealLocalServerIp() {
        String ipAddress = System.getProperty(INSTALLED_IPADDRESS_PROP);
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return ipAddress;
        }
        return DEFAULT_IPADDRESS;
    }

    public static String getRealLocalColletorIp() {
        int version = AticInstallUtil.getInstance().getAticInstallOS();
        if (1 == version) {
            String collectorIP = System.getProperty("java.rmi.server.hostname");
            return collectorIP;
        }
        String ipAddress = AddressUtil.getProductRegInfo();
        if (ipAddress != null && !"".equals(ipAddress)) {
            return ipAddress;
        }
        return DEFAULT_IPADDRESS;
    }

    private static String getProductRegInfo() {
        String infoStr = "";
        Map<String, String> regmap = AddressUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Apache Software Foundation\\Procrun 2.0\\DDOSCOLLECTORSVC\\Parameters\\Java");
        if (null != regmap && !regmap.isEmpty()) {
            infoStr = regmap.get(INSTALLED_IPADDRESS_COLLECTOR);
        }
        return infoStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readRegPath(String regPath) {
        Process ps = null;
        BufferedReader ir = null;
        HashMap<String, String> regMap = new HashMap<String, String>();
        if (!AddressUtil.validateCmd(regPath)) {
            return null;
        }
        try {
            String line;
            ps = Runtime.getRuntime().exec("reg query \"" + regPath + "\"");
            ps.getOutputStream().close();
            InputStreamReader in = new InputStreamReader(ps.getInputStream(), "UTF-8");
            ir = new BufferedReader(in);
            while ((line = ir.readLine()) != null) {
                if (!line.trim().contains("rmi.server.hostname=")) continue;
                String[] regs = line.trim().split("rmi.server.hostname=");
                String[] values = regs[1].split("\\\\0");
                regMap.put(INSTALLED_IPADDRESS_COLLECTOR, values[0].trim());
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("readRegPath" + e));
        }
        finally {
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("readRegPath" + e));
                }
            }
        }
        return regMap;
    }

    private static boolean validateCmd(String arg) {
        String[] badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"};
        arg = Normalizer.normalize(arg, Normalizer.Form.NFKC);
        for (String bad : badInput) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }

    public static long ipToLong(String ipaddress) {
        long[] ip = new long[4];
        int position1 = ipaddress.indexOf(".");
        int position2 = ipaddress.indexOf(".", position1 + 1);
        int position3 = ipaddress.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(ipaddress.substring(0, position1));
        ip[1] = Long.parseLong(ipaddress.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(ipaddress.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(ipaddress.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIP(long ipaddress) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ipaddress >>> 24));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFFFL) >>> 16));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFL) >>> 8));
        sb.append('.');
        sb.append(String.valueOf(ipaddress & 0xFFL));
        return sb.toString();
    }

    public static boolean ipValid(String ip) {
        if (null == ip) {
            return false;
        }
        String regex = "^([1-9]|[1-9]\\d|1\\d{2}|2[0-1]\\d|22[0-3]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(ip);
        boolean isIp = m.matches();
        if (isIp) {
            String[] iPArray = ip.split("\\.");
            if (iPArray.length != 4) {
                return false;
            }
            int val = Integer.parseInt(iPArray[0]);
            return val != 127;
        }
        return false;
    }

    public static String maskToIp(int mask) {
        String part = "";
        int x = mask / 8;
        int y = mask % 8;
        for (int i = 0; i < x; ++i) {
            if (x == 4) {
                part = "255.255.255.255";
                break;
            }
            part = part + "255.";
        }
        int sum = 0;
        int constant = 256;
        for (int i = 0; i < y; ++i) {
            sum += (constant >>= 1);
        }
        StringBuffer buf = new StringBuffer();
        if (x != 4) {
            for (int i = 0; i < 3 - x; ++i) {
                buf = buf.append(".0");
            }
            part = part + sum + buf.toString();
        }
        return part;
    }

    public static String getLocalIpAddr() {
        String localIp = AddressUtil.getRealLocalServerIp();
        try {
            if (localIp.equals(DEFAULT_IPADDRESS)) {
                localIp = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error((Object)"hostname is not fit /etc/hosts config.");
            localIp = null;
        }
        if (StringUtils.isEmpty((CharSequence)localIp) || localIp.startsWith("0.") || DEFAULT_IPADDRESS.equals(localIp)) {
            localIp = AddressUtil.networkLocalAddr();
        }
        LOGGER.info((Object)("Get Local Ip: " + localIp));
        return localIp;
    }

    private static String networkLocalAddr() {
        String localIp = DEFAULT_IPADDRESS;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localIp;
            }
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String hostAddress;
                    InetAddress inetAddress = addresses.nextElement();
                    if (inetAddress.isLoopbackAddress() || !inetAddress.isSiteLocalAddress() || DEFAULT_IPADDRESS.equals(hostAddress = inetAddress.getHostAddress())) continue;
                    return hostAddress;
                }
            }
            LOGGER.error((Object)("Can't get our ip address, interfaces are:" + interfaces));
        }
        catch (Exception e) {
            LOGGER.error((Object)"get network localIp error!", (Throwable)e);
        }
        return localIp;
    }
}

