/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.sdk.exception.LegoCheckedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IPUtil {
    static final String REGEX = "((25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|0?[1-9]\\d|0?0?\\d)";
    private static final String IPV4 = "ipv4";
    private static final String IPV6 = "ipv6";
    private static final int IPV4_SEGNUM = 4;
    private static final int IPV6_SEGNUM = 8;
    private static final int IPV4_MAX = 255;
    private static final int IPV6_MAX = 65535;

    private IPUtil() {
    }

    public static boolean isIpv4(String ip) {
        IPUtil.checkNull(ip);
        Matcher m = Pattern.compile(REGEX).matcher(ip);
        return m.matches();
    }

    public static boolean isIpv6(String ip) {
        int i;
        IPUtil.checkNull(ip);
        int idx = ip.indexOf("::");
        if (idx == -1) {
            String[] items = ip.split(":");
            if (items.length != 8) {
                return false;
            }
            for (int i2 = 0; i2 < items.length; ++i2) {
                if (IPUtil.isHex(items[i2])) continue;
                return false;
            }
            return true;
        }
        if (idx != ip.lastIndexOf("::")) {
            return false;
        }
        String item = null;
        String[] items = ip.split("::");
        String[] items0 = new String[]{};
        String[] items1 = new String[]{};
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (null == item || item.isEmpty()) continue;
            if (i == 0) {
                if (item.startsWith(":")) {
                    return false;
                }
                items0 = item.split(":");
                continue;
            }
            if (i != 1) continue;
            if (item.endsWith(":")) {
                return false;
            }
            items1 = item.split(":");
        }
        if (items0.length + items1.length > 7) {
            return false;
        }
        for (i = 0; i < items0.length; ++i) {
            if (items0[i].isEmpty() || IPUtil.isHex(items0[i])) continue;
            return false;
        }
        for (i = 0; i < items1.length; ++i) {
            if (items1[i].isEmpty() || IPUtil.isHex(items1[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isHex(String str) {
        IPUtil.checkNull(str);
        str = str.trim();
        if (str.length() == 0 || str.length() > 4) {
            return false;
        }
        str = str.toLowerCase(Locale.US);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f') continue;
            return false;
        }
        return true;
    }

    public static String[] getSubnetRange(String ip, int subnetmask) {
        String hostBinary;
        IPUtil.checkNull(ip);
        String type = null;
        if (IPUtil.isIpv4(ip)) {
            type = IPV4;
            hostBinary = IPUtil.ip2Binary(ip);
        } else if (IPUtil.isIpv6(ip)) {
            type = IPV6;
            ip = IPUtil.convert2CompleteIpV6(ip);
            hostBinary = IPUtil.ip2Binary(ip);
        } else {
            throw new IllegalArgumentException("unknown type , ip [" + ip + "]");
        }
        IPUtil.checkMask(subnetmask, type);
        String subMaskBinary = IPUtil.getSubnetMaskBinary(subnetmask, type);
        String subnetAddr = IPUtil.getSubnetAddrByIPAndMask(hostBinary, subMaskBinary, type);
        String broadCastAddr = IPUtil.getBroadCastAddrByIPAndMask(hostBinary, subMaskBinary, type);
        Integer ipSegment = 0;
        int limit = IPV4.equals(type) ? 32 : 128;
        StringBuilder firstIP = new StringBuilder(limit);
        StringBuilder lastIP = new StringBuilder(limit);
        if (IPV4.equals(type)) {
            int i;
            ipSegment = 0;
            for (i = 0; i < 4; ++i) {
                ipSegment = Integer.parseInt(subnetAddr.substring(8 * i, 8 * i + 8), 2);
                firstIP.append(String.valueOf(ipSegment));
                if (i == 3) continue;
                firstIP.append('.');
            }
            ipSegment = 0;
            for (i = 0; i < 4; ++i) {
                ipSegment = Integer.parseInt(broadCastAddr.substring(8 * i, 8 * i + 8), 2);
                lastIP.append(String.valueOf(ipSegment));
                if (i == 3) continue;
                lastIP.append('.');
            }
        } else if (IPV6.equals(type)) {
            String c;
            int i;
            ipSegment = 0;
            for (i = 0; i < 8; ++i) {
                c = subnetAddr.substring(16 * i, 16 * i + 16);
                ipSegment = Integer.valueOf(c, 2);
                firstIP.append(Integer.toHexString(ipSegment));
                if (i == 7) continue;
                firstIP.append(':');
            }
            for (i = 0; i < 8; ++i) {
                c = broadCastAddr.substring(16 * i, 16 * i + 16);
                ipSegment = Integer.valueOf(c, 2);
                lastIP.append(Integer.toHexString(ipSegment));
                if (i == 7) continue;
                lastIP.append(':');
            }
        }
        String[] result = new String[2];
        if (IPV6.equals(type)) {
            result[0] = IPUtil.compressIPv6(firstIP.toString());
            result[1] = IPUtil.compressIPv6(lastIP.toString());
        } else {
            result[0] = firstIP.toString();
            result[1] = lastIP.toString();
        }
        return result;
    }

    public static String[] getNetworkSegment(String startip, String endip) {
        IPUtil.checkIp(startip, endip);
        LinkedList<String> list = new LinkedList<String>();
        int mask = IPUtil.getSubnetMaskNumByIpRange(startip, endip);
        String[] sr1 = IPUtil.getSubnetRange(startip, mask);
        short a = IPUtil.compareTo(startip, sr1[0]);
        if (a != 0 && a != 1) {
            throw new LegoCheckedException("error...");
        }
        IPUtil.processHeadDeep(startip, endip, mask, list);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> getNetworMask(String[] ips) {
        ArrayList<String> ipp = new ArrayList<String>();
        for (String ip : ips) {
            String[] iped = ip.split("/");
            int mask = 8 - Integer.parseInt(iped[1]);
            if (mask > 0) {
                int num = 1;
                for (int i = 0; i < mask; ++i) {
                    num = 2 * num;
                }
                String[] one = ip.split(".0");
                Integer a = Integer.valueOf(one[0]);
                for (int i = 0; i < num; ++i) {
                    Integer n = a;
                    Integer n2 = a = Integer.valueOf(a + 1);
                    ipp.add(String.valueOf(n) + ".0.0.0/8");
                }
                continue;
            }
            ipp.add(ip);
        }
        return ipp;
    }

    private static List<String> processHeadDeep(String startip, String endip, int mask, List<String> list) {
        int tempMask = mask;
        boolean flag = true;
        while (flag) {
            String[] ipRange = IPUtil.getSubnetRange(startip, tempMask);
            short a = IPUtil.compareTo(startip, ipRange[0]);
            if (a != 0) {
                ++tempMask;
                continue;
            }
            flag = false;
            short b = IPUtil.compareTo(endip, ipRange[1]);
            if (b == 0) {
                list.add(IPUtil.compressIPv6(startip) + "/" + tempMask);
                break;
            }
            if (b == -1) {
                IPUtil.processHeadDeep(ipRange[0], endip, ++tempMask, list);
                continue;
            }
            if (b != 1) continue;
            list.add(IPUtil.compressIPv6(startip) + "/" + tempMask);
            IPUtil.processHeadDeep(IPUtil.ipNext(ipRange[1]), endip, mask, list);
        }
        return list;
    }

    public static boolean isInIpRange(String[] ipRange, String ip) {
        if (null == ipRange || ipRange.length != 2) {
            throw new IllegalArgumentException("current arguments invalid. statrRange: " + Arrays.toString(ipRange));
        }
        String ssip = ipRange[0];
        String seip = ipRange[1];
        if (!IPUtil.checkIp(ip, ssip, seip)) {
            throw new IllegalArgumentException("the ip type of range is not unified: ipRange: " + Arrays.toString(ipRange) + " ip: " + ip);
        }
        if (IPUtil.compareTo(ssip, seip) == 1) {
            throw new IllegalArgumentException("the item of start range is value inversion: ipRange: " + Arrays.toString(ipRange) + " ip: " + ip);
        }
        short b = IPUtil.compareTo(ssip, ip);
        short c = IPUtil.compareTo(ip, seip);
        if (b == 0 || c == 0) {
            return true;
        }
        return b == -1 && c == -1;
    }

    private static boolean checkIp(String ip, String ssip, String seip) {
        return IPUtil.isIpv4(ssip) && IPUtil.isIpv4(seip) && IPUtil.isIpv4(ip) || IPUtil.isIpv6(ssip) && IPUtil.isIpv6(seip) && IPUtil.isIpv6(ip);
    }

    public static List<String[]> getIpRangeExceptOther(String[] statrRange, String[] endRange) {
        String[] str1;
        String n;
        String[] str;
        if (null == statrRange || statrRange.length != 2 || null == endRange || endRange.length != 2) {
            throw new IllegalArgumentException("current arguments invalid. statrRange: " + Arrays.toString(statrRange) + "  --  endRange: " + Arrays.toString(endRange));
        }
        String ssip = statrRange[0];
        String seip = statrRange[1];
        String esip = endRange[0];
        String eeip = endRange[1];
        if (!(IPUtil.isIpv4(ssip) && IPUtil.isIpv4(seip) || IPUtil.isIpv6(ssip) && IPUtil.isIpv6(seip))) {
            throw new IllegalArgumentException("the ip type of range is not unified: statrRange: " + Arrays.toString(statrRange));
        }
        if (IPUtil.compareTo(ssip, seip) == 1) {
            throw new IllegalArgumentException("the item of start range is value inversion: statrRange: " + Arrays.toString(statrRange));
        }
        if (!(IPUtil.isIpv4(esip) && IPUtil.isIpv4(eeip) || IPUtil.isIpv6(esip) && IPUtil.isIpv6(eeip))) {
            throw new IllegalArgumentException("the ip type of end range is not unified: endRange: " + Arrays.toString(endRange));
        }
        if (IPUtil.compareTo(esip, eeip) == 1) {
            throw new IllegalArgumentException("the item of end range is value inversion: endRange: " + Arrays.toString(endRange));
        }
        short a = IPUtil.compareTo(ssip, esip);
        short b = IPUtil.compareTo(ssip, eeip);
        short c = IPUtil.compareTo(seip, esip);
        short d = IPUtil.compareTo(seip, eeip);
        LinkedList<String[]> list = new LinkedList<String[]>();
        if (b > 0) {
            list.add(statrRange);
        } else if (b == 0) {
            if (IPUtil.compareTo(IPUtil.ipNext(ssip), seip) < 1) {
                str = new String[]{IPUtil.ipNext(ssip), seip};
                list.add(str);
            }
        } else if (d > 0) {
            if (a >= 0) {
                if (IPUtil.compareTo(IPUtil.ipNext(eeip), seip) < 1) {
                    str = new String[]{IPUtil.ipNext(eeip), seip};
                    list.add(str);
                }
            } else {
                String n2;
                String m = IPUtil.ipNext(eeip);
                if (IPUtil.compareTo(m, seip) < 1) {
                    String[] str2 = new String[]{m, seip};
                    list.add(str2);
                }
                if (IPUtil.compareTo(ssip, n2 = IPUtil.ipPrevious(esip)) < 1) {
                    String[] str12 = new String[]{ssip, n2};
                    list.add(str12);
                }
            }
        } else if (d == 0) {
            if (a < 0 && IPUtil.compareTo(ssip, n = IPUtil.ipPrevious(esip)) < 1) {
                str1 = new String[]{ssip, n};
                list.add(str1);
            }
        } else if (a < 0) {
            if (c >= 0) {
                n = IPUtil.ipPrevious(esip);
                if (IPUtil.compareTo(ssip, n) < 1) {
                    str1 = new String[]{ssip, n};
                    list.add(str1);
                }
            } else {
                list.add(statrRange);
            }
        }
        for (String[] sa : list) {
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = IPUtil.compressIPv6(sa[i]);
            }
        }
        return list;
    }

    public static List<String[]> getMergeIpRange(String[] statrRange, String[] endRange) {
        String[] str;
        if (null == statrRange || statrRange.length != 2 || null == endRange || endRange.length != 2) {
            throw new IllegalArgumentException("current arguments invalid. statrRange: " + Arrays.toString(statrRange) + "  --  endRange: " + Arrays.toString(endRange));
        }
        String ssip = statrRange[0];
        String seip = statrRange[1];
        String esip = endRange[0];
        String eeip = endRange[1];
        if (!(IPUtil.isIpv4(ssip) && IPUtil.isIpv4(seip) || IPUtil.isIpv6(ssip) && IPUtil.isIpv6(seip))) {
            throw new IllegalArgumentException("the ip type of range is not unified: statrRange: " + Arrays.toString(statrRange));
        }
        if (IPUtil.compareTo(ssip, seip) == 1) {
            throw new IllegalArgumentException("the item of start range is value inversion: statrRange: " + Arrays.toString(statrRange));
        }
        if (!(IPUtil.isIpv4(esip) && IPUtil.isIpv4(eeip) || IPUtil.isIpv6(esip) && IPUtil.isIpv6(eeip))) {
            throw new IllegalArgumentException("the ip type of end range is not unified: endRange: " + Arrays.toString(endRange));
        }
        if (IPUtil.compareTo(esip, eeip) == 1) {
            throw new IllegalArgumentException("the item of end range is value inversion: endRange: " + Arrays.toString(endRange));
        }
        short a = IPUtil.compareTo(ssip, esip);
        short b = IPUtil.compareTo(ssip, eeip);
        short c = IPUtil.compareTo(seip, esip);
        short d = IPUtil.compareTo(seip, eeip);
        LinkedList<String[]> list = new LinkedList<String[]>();
        if (b > 0) {
            list.add(statrRange);
            list.add(endRange);
        } else if (b == 0) {
            str = new String[]{ssip, ssip};
            list.add(str);
        } else if (d >= 0) {
            if (a >= 0) {
                str = new String[]{ssip, eeip};
                list.add(str);
            } else {
                str = new String[]{esip, eeip};
                list.add(str);
            }
        } else if (a >= 0) {
            str = new String[]{ssip, seip};
            list.add(str);
        } else if (c >= 0) {
            String[] str1 = new String[]{esip, seip};
            list.add(str1);
        } else {
            list.add(statrRange);
            list.add(endRange);
        }
        for (String[] sa : list) {
            for (int i = 0; i < sa.length; ++i) {
                sa[i] = IPUtil.compressIPv6(sa[i]);
            }
        }
        return list;
    }

    public static List<String> spiltNetworkSegmentByMask(String ipAndMask, int splitMask) {
        if (null == ipAndMask) {
            throw new IllegalArgumentException("arguments of this method is invalid,ipAndMask: null splitMask: " + splitMask);
        }
        String[] ipAndMaskArray = ipAndMask.split("/");
        if (ipAndMaskArray.length != 2) {
            throw new IllegalArgumentException("arguments of this method is invalid,ipAndMask is composed of ip and mask, and the splitter is '/'");
        }
        String ip = ipAndMaskArray[0];
        String ipType = IPUtil.getIpType(ip);
        int mask = Integer.parseInt(ipAndMaskArray[1]);
        IPUtil.checkMask(mask, ipType);
        String[] ipRange = IPUtil.getSubnetRange(ip, mask);
        if (splitMask < mask) {
            throw new IllegalArgumentException("arguments of this method is invalid, splitMask is must bigger than subnet mask splitMask: " + splitMask + " subnet mask: " + mask);
        }
        return IPUtil.spiltNetworkSegmentByMask(ipRange, splitMask);
    }

    public static String compressIPv6(String ip) {
        block15: {
            IPUtil.checkNull(ip);
            if (!IPUtil.isIpv6(ip)) {
                return ip;
            }
            ip = IPUtil.convert2CompleteIpV6(ip);
            int x = 0;
            String t = null;
            String[] ips = ip.split(":");
            StringBuffer sb = new StringBuffer(256);
            for (int i = 0; i < ips.length; ++i) {
                x = Integer.parseInt(ips[i], 16);
                ips[i] = t = Integer.toHexString(x);
                sb.append(t);
                if (i == ips.length - 1) continue;
                sb.append(':');
            }
            ip = sb.toString();
            int pt = -1;
            int cn = 0;
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            for (int i = 0; i < ips.length; ++i) {
                String s = ips[i];
                if ("0".equals(s)) {
                    if (cn == 0) {
                        pt = i;
                        map.put(pt, 0);
                    }
                    ++cn;
                } else {
                    if (cn > 0) {
                        map.put(pt, cn);
                    }
                    if (i != ips.length - 1) {
                        pt = -1;
                        cn = 0;
                    }
                }
                if (i != ips.length - 1 || !map.containsKey(pt)) continue;
                map.put(pt, cn);
            }
            Set set = map.entrySet();
            Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
            Arrays.sort(entries, new Comparator<Map.Entry<Integer, Integer>>(){

                @Override
                public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            Map.Entry[] entryArray = entries;
            int n = entryArray.length;
            int n2 = 0;
            if (n2 >= n) break block15;
            Map.Entry e = entryArray[n2];
            int key = (Integer)e.getKey();
            int value = (Integer)e.getValue();
            int adx = 0;
            int bdx = 0;
            for (int i = 0; i < key; ++i) {
                adx += ips[i].length();
                ++adx;
            }
            bdx = adx + 2 * value;
            if (key + value == 8 && key == 0) {
                ip = "::";
            } else if (key == 0) {
                ip = "::" + ip.substring(bdx);
            } else if (key + value == 8) {
                ip = ip.substring(0, adx) + ":";
            } else {
                String a = ip.substring(0, adx);
                String b = ip.substring(bdx);
                StringBuilder sx = new StringBuilder();
                sx.append(a).append(':').append(b);
                ip = sx.toString();
            }
        }
        return ip;
    }

    public static List<String> spiltNetworkSegmentByMask(String[] ipRange, int splitMask) {
        if (ipRange == null) {
            throw new IllegalArgumentException("arguments of this method is invalid,ipRange is null");
        }
        if (ipRange.length != 2 || IPUtil.compareTo(ipRange[0], ipRange[1]) != -1) {
            throw new IllegalArgumentException("arguments of this method is invalid,ipRange: " + Arrays.toString(ipRange));
        }
        String sip = ipRange[0];
        String eip = ipRange[1];
        int mask = IPUtil.getSubnetMaskNumByIpRange(sip, eip);
        if (splitMask < mask) {
            throw new IllegalArgumentException("arguments of this method is invalid, splitMask is must bigger than subnet mask splitMask: " + splitMask + " subnet mask: " + mask);
        }
        LinkedList<String> list = new LinkedList<String>();
        IPUtil.getDeepSplit(sip, eip, splitMask, list);
        return list;
    }

    private static void getDeepSplit(String startip, String endip, int splitMask, List<String> list) {
        String[] range = IPUtil.getSubnetRange(startip, splitMask);
        short b = IPUtil.compareTo(range[1], endip);
        if (b == 0) {
            startip = IPUtil.compressIPv6(startip);
            list.add(startip + "/" + splitMask);
        } else if (b == -1) {
            startip = IPUtil.compressIPv6(startip);
            list.add(startip + "/" + splitMask);
            IPUtil.getDeepSplit(IPUtil.ipNext(range[1]), endip, splitMask, list);
        }
    }

    private static String getSubnetAddrByIPAndMask(String hostAddr, String subMaskBinary, String type) {
        int i = 0;
        int limit = 0;
        if (IPV4.equals(type)) {
            limit = 32;
        } else if (IPV6.equals(type)) {
            limit = 128;
        }
        StringBuilder subnetAddr = new StringBuilder(limit);
        while (i != limit) {
            if ("1".equals(hostAddr.substring(i, i + 1)) && hostAddr.substring(i, i + 1).equals(subMaskBinary.substring(i, i + 1))) {
                subnetAddr.append('1');
            } else {
                subnetAddr.append('0');
            }
            ++i;
        }
        return subnetAddr.toString();
    }

    private static String getBroadCastAddrByIPAndMask(String hostAddr, String subMaskBinary, String type) {
        int i = 0;
        int limit = 0;
        if (type.equals(IPV4)) {
            limit = 32;
        } else if (type.equals(IPV6)) {
            limit = 128;
        }
        StringBuilder broadCastAddr = new StringBuilder(limit);
        while (i != limit) {
            if (hostAddr.substring(i, i + 1).equals(subMaskBinary.substring(i, i + 1)) || "0".equals(subMaskBinary.substring(i, i + 1))) {
                broadCastAddr.append('1');
            } else {
                broadCastAddr.append('0');
            }
            ++i;
        }
        return broadCastAddr.toString();
    }

    private static String getSubnetMaskBinary(int num, String type) {
        int limit = 0;
        if (type.equals(IPV4)) {
            limit = 32;
        } else if (type.equals(IPV6)) {
            limit = 128;
        }
        StringBuilder mask = new StringBuilder(limit);
        while (mask.length() != num) {
            mask.append('1');
        }
        while (mask.length() != limit) {
            mask.append('0');
        }
        return mask.toString();
    }

    private static int getSubnetMaskNumByIpRange(String startip, String endip) {
        IPUtil.checkNull(startip);
        IPUtil.checkNull(endip);
        String startipBinary = null;
        String endipBinary = null;
        String type = null;
        if (IPUtil.isIpv4(startip) && IPUtil.isIpv4(endip)) {
            type = IPV4;
            startipBinary = IPUtil.ip2Binary(startip);
            endipBinary = IPUtil.ip2Binary(endip);
        } else if (IPUtil.isIpv6(startip) && IPUtil.isIpv6(endip)) {
            type = IPV6;
            startip = IPUtil.convert2CompleteIpV6(startip);
            endip = IPUtil.convert2CompleteIpV6(endip);
            startipBinary = IPUtil.ip2Binary(startip);
            endipBinary = IPUtil.ip2Binary(endip);
        } else {
            throw new IllegalArgumentException("unknown type , ip range [" + startip + " - " + endip + "]");
        }
        int limit = IPUtil.getIPLength(type);
        int returnResult = 0;
        for (int i = 0; i != limit && startipBinary.substring(i, i + 1).equals(endipBinary.substring(i, i + 1)); ++i) {
            ++returnResult;
        }
        return returnResult;
    }

    public static String convert2CompleteIpV6(String ip) {
        IPUtil.checkNull(ip);
        if (!IPUtil.isIpv6(ip)) {
            throw new IllegalArgumentException("current ip is not ipv6 ip address.");
        }
        String ipV6 = ip;
        int idx = ip.indexOf("::");
        if (idx > 0) {
            String[] s = ip.split(":");
            int len = 0;
            for (String m : s) {
                if (null == m || m.isEmpty()) continue;
                ++len;
            }
            int size = 8 - len;
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                tmp.append(":0");
            }
            if (ip.length() - 2 != idx) {
                tmp.append(':');
            }
            ipV6 = ip.replace("::", tmp.toString());
        } else if (idx == 0) {
            if (ip.length() == 2) {
                ipV6 = ip.replace("::", "0:0:0:0:0:0:0:0");
            } else {
                String[] s = ip.split(":");
                int len = IPUtil.countStringArr(s);
                int size = 8 - len;
                StringBuilder tmp = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    tmp.append("0:");
                }
                ipV6 = ip.replace("::", tmp.toString());
            }
        }
        ipV6 = ipV6.toLowerCase(Locale.US);
        return ipV6;
    }

    private static int countStringArr(String[] s) {
        int len = 0;
        for (String m : s) {
            if (null == m || m.isEmpty()) continue;
            ++len;
        }
        return len;
    }

    public static String convert2CompleteIpV6AllZero(String ip) {
        String result = IPUtil.convert2CompleteIpV6(ip);
        if (!IPUtil.isIpv6(result)) {
            throw new IllegalArgumentException("current ip is not ipv6 ip address.");
        }
        String[] ipArray = result.split(":");
        StringBuilder tmp = new StringBuilder(128);
        for (int i = 0; i < ipArray.length; ++i) {
            tmp.append(IPUtil.left0(ipArray[i], 4));
            if (i == ipArray.length - 1) continue;
            tmp.append(':');
        }
        result = tmp.toString();
        result = result.toLowerCase(Locale.US);
        return result;
    }

    private static String ip2Binary(String ip) {
        IPUtil.checkNull(ip);
        StringBuilder result = new StringBuilder();
        if (IPUtil.isIpv4(ip)) {
            String[] ipArray = ip.split("[.]");
            for (int i = 0; i < ipArray.length; ++i) {
                result.append(IPUtil.left0(Integer.toBinaryString(Integer.parseInt(ipArray[i])), 8));
            }
        } else if (IPUtil.isIpv6(ip)) {
            ip = IPUtil.convert2CompleteIpV6(ip);
            String[] ipArray = ip.split(":");
            Integer x = 0;
            for (int i = 0; i < ipArray.length; ++i) {
                x = Integer.valueOf(ipArray[i], 16);
                result.append(IPUtil.left0(Integer.toBinaryString(x), 16));
            }
        } else {
            throw new IllegalArgumentException("unknown type , ip [" + ip + "]");
        }
        return result.toString();
    }

    private static String left0(String num, int len) {
        while (num.length() != len) {
            num = "0" + num;
        }
        return num;
    }

    private static int getIPLength(String type) {
        int limit = 0;
        if (IPV4.equals(type)) {
            limit = 32;
        } else if (IPV6.equals(type)) {
            limit = 128;
        }
        return limit;
    }

    public static short compareTo(String startip, String endip) {
        IPUtil.checkNull(startip);
        IPUtil.checkNull(endip);
        String startipBinary = null;
        String endipBinary = null;
        String type = null;
        if (IPUtil.isIpv4(startip) && IPUtil.isIpv4(endip)) {
            type = IPV4;
            startipBinary = IPUtil.ip2Binary(startip);
            endipBinary = IPUtil.ip2Binary(endip);
        } else if (IPUtil.isIpv6(startip) && IPUtil.isIpv6(endip)) {
            type = IPV6;
            startip = IPUtil.convert2CompleteIpV6(startip);
            endip = IPUtil.convert2CompleteIpV6(endip);
            startipBinary = IPUtil.ip2Binary(startip);
            endipBinary = IPUtil.ip2Binary(endip);
        } else {
            throw new IllegalArgumentException("unknown type , ip range [" + startip + " - " + endip + "]");
        }
        int limit = IPUtil.getIPLength(type);
        for (int i = 0; i != limit; ++i) {
            char b;
            char a = startipBinary.substring(i, i + 1).toCharArray()[0];
            if (a > (b = endipBinary.substring(i, i + 1).toCharArray()[0])) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            if (i != limit - 1 || a != b) continue;
            return 0;
        }
        return 0;
    }

    public static String ipNext(String ip) {
        if (IPUtil.isIpv4(ip)) {
            String[] array = ip.split("[.]");
            int[] part = new int[4];
            for (int i = 0; i < array.length; ++i) {
                part[i] = Integer.parseInt(array[i]);
            }
            IPUtil.computeCurrIpNextValue(array, part, part.length - 1, IPV4);
            StringBuilder rs = new StringBuilder();
            for (int i = 0; i < part.length; ++i) {
                rs.append(part[i]);
                if (i == part.length - 1) continue;
                rs.append('.');
            }
            return rs.toString();
        }
        if (IPUtil.isIpv6(ip)) {
            ip = IPUtil.convert2CompleteIpV6(ip);
            String[] array = ip.split(":");
            int[] part = new int[8];
            for (int i = 0; i < array.length; ++i) {
                part[i] = Integer.parseInt(array[i], 16);
            }
            IPUtil.computeCurrIpNextValue(array, part, part.length - 1, IPV6);
            StringBuilder rs = new StringBuilder();
            for (int i = 0; i < part.length; ++i) {
                rs.append(Integer.toHexString(part[i]));
                if (i == part.length - 1) continue;
                rs.append(':');
            }
            String ipv6 = rs.toString();
            return IPUtil.compressIPv6(ipv6);
        }
        throw new IllegalArgumentException("unknown type , ip [" + ip + "]");
    }

    public static String ipPrevious(String ip) {
        if (IPUtil.isIpv4(ip)) {
            String[] array = ip.split("[.]");
            int[] part = new int[4];
            for (int i = 0; i < array.length; ++i) {
                part[i] = Integer.parseInt(array[i]);
            }
            IPUtil.computeCurrIpPreviousValue(part, part.length - 1, IPV4);
            StringBuilder rs = new StringBuilder();
            for (int i = 0; i < part.length; ++i) {
                rs.append(part[i]);
                if (i == part.length - 1) continue;
                rs.append('.');
            }
            return rs.toString();
        }
        if (IPUtil.isIpv6(ip)) {
            ip = IPUtil.convert2CompleteIpV6(ip);
            String[] array = ip.split(":");
            int[] part = new int[8];
            for (int i = 0; i < array.length; ++i) {
                part[i] = Integer.parseInt(array[i], 16);
            }
            IPUtil.computeCurrIpPreviousValue(part, part.length - 1, IPV6);
            StringBuilder rs = new StringBuilder();
            for (int i = 0; i < part.length; ++i) {
                rs.append(Integer.toHexString(part[i]));
                if (i == part.length - 1) continue;
                rs.append(':');
            }
            String ipv6 = rs.toString();
            return IPUtil.compressIPv6(ipv6);
        }
        throw new IllegalArgumentException("unknown type , ip [" + ip + "]");
    }

    private static void computeCurrIpPreviousValue(int[] part, int j, String type) {
        int maxValue = 0;
        if (IPV4.equals(type)) {
            maxValue = 255;
        } else if (IPV6.equals(type)) {
            maxValue = 65535;
        }
        if (part[j] > 0) {
            int n = j;
            part[n] = part[n] - 1;
            for (int i = j + 1; i < part.length; ++i) {
                part[i] = maxValue;
            }
        } else {
            if (j == 0) {
                return;
            }
            IPUtil.computeCurrIpPreviousValue(part, --j, type);
        }
    }

    private static void computeCurrIpNextValue(String[] array, int[] part, int j, String type) {
        int maxValue = 0;
        if (IPV4.equals(type)) {
            maxValue = 255;
        } else if (IPV6.equals(type)) {
            maxValue = 65535;
        }
        if (part[j] < maxValue) {
            int n = j;
            part[n] = part[n] + 1;
            for (int i = j + 1; i < array.length; ++i) {
                if (IPV4.equals(type)) {
                    part[i] = 0;
                    continue;
                }
                if (!IPV6.equals(type)) continue;
                part[i] = 0;
            }
        } else {
            if (j == 0) {
                return;
            }
            IPUtil.computeCurrIpNextValue(array, part, --j, type);
        }
    }

    private static void checkNull(String str) {
        if (null == str) {
            throw new IllegalArgumentException("input parameter of str is null.");
        }
    }

    private static void checkIp(String startip, String endip) {
        if (!(IPUtil.isIpv4(startip) && IPUtil.isIpv4(endip) || IPUtil.isIpv6(startip) && IPUtil.isIpv6(endip))) {
            throw new IllegalArgumentException("the parameters of startip and endip are different source type.");
        }
    }

    public static void checkMask(int subnetmask, String type) {
        String numReg = "([0-9]\\d*)";
        Matcher m = Pattern.compile("([0-9]\\d*)").matcher(String.valueOf(subnetmask));
        if (m.matches()) {
            if (IPV4.equals(type) && (subnetmask > 32 || subnetmask < 0)) {
                throw new IllegalArgumentException("the subnetmask of ipv4 is must smaller than 32 and bigger than 0.");
            }
            if (IPV6.equals(type) && (subnetmask > 128 || subnetmask < 0)) {
                throw new IllegalArgumentException("the subnetmask of ipv6 is must smaller than 128 and bigger than 0.");
            }
        } else {
            throw new IllegalArgumentException("the subnetmask of ip is must number type.");
        }
    }

    private static String getIpType(String ip) {
        String type = null;
        if (IPUtil.isIpv4(ip)) {
            type = IPV4;
        } else if (IPUtil.isIpv6(ip)) {
            type = IPV6;
        } else {
            throw new IllegalArgumentException("unknown type , ip [" + ip + "]");
        }
        return type;
    }
}

