/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LegoCmdUtil {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static LegoCmdUtil instance = new LegoCmdUtil();

    public void runbatParams(String path, String[] params) {
        StringBuffer sb = new StringBuffer();
        sb.append("cmd /c start /b ");
        sb.append(path.replace("\\/", "/").replace(" ", "\" \""));
        if (null != params && params.length > 0) {
            for (String param : params) {
                sb.append(" " + param);
            }
        }
        this.runbat(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runbat(String cmd) {
        LOGGER.debug((Object)("Run Windows Program:" + cmd));
        Runtime runtime = Runtime.getRuntime();
        Process child = null;
        InputStream in = null;
        InputStream err = null;
        BufferedReader bufferedReader = null;
        BufferedReader errBufferedReader = null;
        try {
            child = runtime.exec(cmd);
            String output = null;
            int isSuccessful = 0;
            err = child.getErrorStream();
            errBufferedReader = new BufferedReader(new InputStreamReader(err, "utf-8"));
            while (null != (output = errBufferedReader.readLine())) {
            }
            in = child.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(in, "utf-8"));
            output = bufferedReader.readLine();
            while (output != null) {
                output = bufferedReader.readLine();
                LOGGER.debug((Object)output);
            }
            try {
                isSuccessful = child.waitFor();
                LOGGER.debug((Object)("CMD excute result:" + isSuccessful));
            }
            catch (Exception e) {
                LOGGER.error((Object)("exception when child.waitFor() windows cmd output, cmd is : " + cmd), (Throwable)e);
            }
            this.closeStream(in, bufferedReader);
            this.closeStream(err, errBufferedReader);
            if (child != null) {
                child.destroy();
            }
        }
        catch (IOException ioe) {
            try {
                LOGGER.error((Object)("exception when exec windows cmd, cmd is : " + cmd));
                this.closeStream(in, bufferedReader);
                this.closeStream(err, errBufferedReader);
                if (child != null) {
                    child.destroy();
                }
            }
            catch (Throwable throwable) {
                this.closeStream(in, bufferedReader);
                this.closeStream(err, errBufferedReader);
                if (child != null) {
                    child.destroy();
                }
                throw throwable;
            }
        }
    }

    public static LegoCmdUtil getInstance() {
        return instance;
    }

    private void closeStream(InputStream input, BufferedReader reader) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"exception when input.close()");
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"exception when reader.close()");
            }
        }
    }
}

