/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class LegoProperties {
    private static final String DEFAULT_PROPERTIES = "default.properties";
    private static final String SYSTEM_PROPERTIES = "conf/lego.properties";
    private static final Properties PROPS = new Properties();
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static LegoProperties instance = new LegoProperties();

    public String getProperty(String key, String defaultValue) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            value = defaultValue;
        }
        return value;
    }

    public int getInt(String key) {
        String value = PROPS.getProperty(key);
        if (null == value || value.length() <= 0) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public int getPort() {
        return this.getInt("base.rmi_port");
    }

    public String getIPAddressProp() {
        return PROPS.getProperty("base.appmanager_server");
    }

    public int getNorthAlarmTrapPort() {
        return this.getInt("trapport.northAlarm");
    }

    public int getRemoteNotifyTrapPort() {
        return this.getInt("trapport.remoteNotify");
    }

    public static LegoProperties getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inStream = null;
        try {
            ClassLoader loader = LegoProperties.class.getClassLoader();
            if (null == loader) {
                throw new IOException();
            }
            inStream = loader.getResourceAsStream(DEFAULT_PROPERTIES);
            if (null == inStream) {
                throw new IOException();
            }
            PROPS.load(inStream);
        }
        catch (IOException e) {
            log.error((Object)"read default.properties fail.");
        }
        finally {
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"close InputStream of default.properties fail.");
                }
            }
        }
        File file = new File(SYSTEM_PROPERTIES);
        if (file.exists()) {
            FileInputStream fis = null;
            InputStreamReader fr = null;
            try {
                fis = new FileInputStream(file);
                fr = new InputStreamReader((InputStream)fis, "UTF-8");
                PROPS.load(fr);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"read lego.properties fail.");
            }
            catch (IOException e) {
                log.error((Object)"read lego.properties fail.");
            }
            finally {
                if (null != fr) {
                    try {
                        fr.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"read lego.properties fail.");
                    }
                }
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"read lego.properties fail.");
                    }
                }
            }
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)PROPS);
        System.setProperties(sysProps);
        log.debug((Object)PROPS);
    }
}

