/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import com.hs.lego.com.south.sdk.ping.PingServiceImpl;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.webnms.sdk.service.IPingService;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class TestPortUtil {
    private static TestPortUtil instanse = new TestPortUtil();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private IPingService pingUtil = new PingServiceImpl();

    public static TestPortUtil getInstanse() {
        return instanse;
    }

    public Boolean ipReachable(String hostIp) {
        Boolean reachable;
        try {
            reachable = this.pingUtil.ping(hostIp, 0, 3);
        }
        catch (Exception e) {
            reachable = false;
            LOGGER.error((Object)("up down level NMS pinging ip : " + hostIp + "...... failed"), (Throwable)e);
        }
        return reachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean portEnable(String hostIp, int port) {
        Boolean enable = Boolean.TRUE;
        SSLSocketFactory sslSocketFactory = null;
        Socket sslSocket = null;
        sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket obj = null;
        try {
            obj = sslSocketFactory.createSocket(hostIp, port);
            if (obj instanceof SSLSocket) {
                sslSocket = (SSLSocket)obj;
            }
        }
        catch (UnknownHostException e1) {
            LOGGER.error((Object)e1);
        }
        catch (IOException e1) {
            LOGGER.error((Object)"IOException error");
        }
        finally {
            try {
                if (sslSocket != null) {
                    sslSocket.close();
                } else {
                    enable = false;
                }
                if (null != obj) {
                    obj.close();
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)"exception when close socket");
            }
        }
        return enable;
    }
}

