/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class TimeUtil {
    public static final int MILLISECOND = 60000;
    public static final int SECOND_TO_DAY = 86400;
    public static final int SECOND_TO_HOUR = 3600;
    public static final int SECOND_TO_MIUTE = 60;

    private TimeUtil() {
    }

    public static Date getAftertime(int minutes) {
        Date date = new Date();
        long time = date.getTime() + (long)minutes * 60000L;
        date.setTime(time);
        return date;
    }

    public static String getInterval(Date startDate) {
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        long startTime = startDate.getTime();
        long intervalTime = (currentTime - startTime) / 1000L;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        day = (int)(intervalTime / 86400L);
        hour = (int)(intervalTime % 86400L) / 3600;
        minute = (int)(intervalTime % 3600L) / 60;
        second = (int)(intervalTime % 60L);
        return day + "day" + hour + "hour" + minute + "minute" + second + "second";
    }

    public static String getInterval(long startTime) {
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        long intervalTime = (currentTime - startTime) / 1000L;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        day = (int)(intervalTime / 86400L);
        hour = (int)(intervalTime % 86400L) / 3600;
        minute = (int)(intervalTime % 3600L) / 60;
        second = (int)(intervalTime % 60L);
        return day + "day" + hour + "hour" + minute + "minute" + second + "second";
    }

    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static String getCurrentDate(SimpleDateFormat dateFormat) {
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static int getDaysofMonth(long milliseconds) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(milliseconds);
        int days = c.getActualMaximum(5);
        return days;
    }
}

