/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.syslog.service;

import com.hs.lego.core.sdk.comm.SortUnit;
import com.hs.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.hs.lego.core.system.syslog.service.TranslateObject;
import java.util.List;

public final class ConstructHsql {
    private ConstructHsql() {
    }

    public static String constructOptLogQueryHsql(OptLogQCondition oOptLogQCondition) {
        StringBuffer hsqlBuf = new StringBuffer(" as d ");
        boolean[] bEnter = new boolean[]{false};
        if (-1 != oOptLogQCondition.getiOptResult()) {
            hsqlBuf.append("WHERE d.opResult = ");
            hsqlBuf.append(oOptLogQCondition.getiOptResult());
            bEnter[0] = true;
        }
        if (null != oOptLogQCondition.getDataBeginTime()) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.opTime >= ");
            hsqlBuf.append(oOptLogQCondition.getDataBeginTime().getTime());
        }
        if (null != oOptLogQCondition.getDataEndTime()) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            long temp = oOptLogQCondition.getDataEndTime().getTime() + 1000L;
            hsqlBuf.append("d.opTime < ");
            hsqlBuf.append(temp);
        }
        ConstructHsql.constructOptLogSecondQueryHsql(oOptLogQCondition, hsqlBuf, bEnter);
        ConstructHsql.constructOptLogThridQueryHsql(oOptLogQCondition, hsqlBuf, bEnter);
        return ConstructHsql.constructOptLogFourthQueryHsql(oOptLogQCondition, hsqlBuf, bEnter);
    }

    private static void constructOptLogSecondQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter) {
        List<String> lstStrOptFunctionType = oOptLogQCondition.getLstOptFunctionType();
        if (null != lstStrOptFunctionType && !lstStrOptFunctionType.isEmpty()) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.optModuleName in ('");
            int iLength = oOptLogQCondition.getLstOptFunctionType().size();
            for (int i = 0; i < iLength; ++i) {
                hsqlBuf.append(lstStrOptFunctionType.get(i));
                if (iLength - 1 == i) {
                    hsqlBuf.append("')");
                    continue;
                }
                hsqlBuf.append("','");
            }
        }
    }

    private static void constructOptLogThridQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter) {
        List<Integer> lstInterSecLevel = oOptLogQCondition.getLstSecLevel();
        if (null != lstInterSecLevel) {
            if (!bEnter[0]) {
                hsqlBuf.append("WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.riskLevel in (");
            int iLength = lstInterSecLevel.size();
            for (int i = 0; i < iLength; ++i) {
                hsqlBuf.append(lstInterSecLevel.get(i));
                if (iLength - 1 == i) {
                    hsqlBuf.append(')');
                    continue;
                }
                hsqlBuf.append(',');
            }
        }
    }

    private static String constructOptLogFourthQueryHsql(OptLogQCondition oOptLogQCondition, StringBuffer hsqlBuf, boolean[] bEnter) {
        List<String> lstStrUserName = oOptLogQCondition.getLstUserName();
        if (null != lstStrUserName) {
            if (!bEnter[0]) {
                hsqlBuf.append(" WHERE ");
                bEnter[0] = true;
            } else {
                hsqlBuf.append(" and ");
            }
            hsqlBuf.append("d.opUser in ('");
            int iLength0 = oOptLogQCondition.getLstUserName().size();
            for (int i = 0; i < iLength0; ++i) {
                hsqlBuf.append(lstStrUserName.get(i));
                if (iLength0 - 1 == i) {
                    hsqlBuf.append("')");
                    continue;
                }
                hsqlBuf.append("','");
            }
        }
        return hsqlBuf.toString();
    }

    public static String constructSelHql(OptLogQCondition oOptLogQCondition, String hsql) {
        SortUnit su = oOptLogQCondition.getSortunit();
        StringBuffer sBuf = new StringBuffer(hsql);
        if (null != su) {
            String field = TranslateObject.getDoFieldNameByBoFieldName(su.getFieldName());
            sBuf.append(" order by ");
            sBuf.append(field);
            sBuf.append(" " + su.getSortType());
            if (!"opTime".equals(field)) {
                sBuf.append(", d.opTime desc");
            }
        } else {
            sBuf.append(" order by d.opTime desc");
        }
        return sBuf.toString();
    }
}

