/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.syslog.service;

import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.persistance.dao.ICommonDao;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.file.util.FileFactory;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.file.util.FileZip;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.dao.IOptLogDao;
import com.hs.lego.core.system.syslog.sdk.model.OptLogDetailMo;
import com.hs.lego.core.system.syslog.sdk.model.OptLogMo;
import com.hs.lego.core.system.syslog.sdk.model.OptLogQCondition;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.service.ConstructHsql;
import com.hs.lego.core.system.syslog.service.ISysOptStorage;
import com.hs.lego.core.system.syslog.service.TranslateObject;
import com.hs.lego.integrate.optlog.service.OptLogIntegrateFactory;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SysOptLogImpl
implements ISysOptLog {
    private static final int MAXNUM = 5000;
    private static final int SLEEPTIME = 100;
    private static final int MIN_USE_MEMORY = 50;
    private static final int NUM_1024 = 1024;
    private IOptLogDao optLogDao;
    private ICommonDao commDao;
    private ITaskService taskService;
    private ISysOptStorage sysOptStorage;
    private transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public IOptLogDao getOptLogDao() {
        return this.optLogDao;
    }

    public void setOptLogDao(IOptLogDao optLogDao) {
        this.optLogDao = optLogDao;
    }

    public ICommonDao getCommDao() {
        return this.commDao;
    }

    public void setCommDao(ICommonDao commDao) {
        this.commDao = commDao;
    }

    @Override
    public Paging querySysOptLog(OptLogQCondition oQueryCondition, int iStart, int iLength) {
        String sQueryCondition = "";
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo ");
        sQueryCondition = ConstructHsql.constructOptLogQueryHsql(oQueryCondition);
        String sSelHql = ConstructHsql.constructSelHql(oQueryCondition, sQueryCondition);
        sBufQObj.append(sSelHql);
        Paging roPaging = new Paging();
        ArrayList<OptLogMo> lstOptLogMo = new ArrayList();
        try {
            this.log.info((Object)sBufQObj.toString());
            lstOptLogMo = this.commDao.findPage(sBufQObj.toString(), iStart, iLength);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OptLogMo ");
        sBufTotle.append(sQueryCondition);
        this.log.info((Object)sBufTotle.toString());
        try {
            this.log.info((Object)"roPaging.setCount is will invoke!!");
            roPaging.setCount((int)this.commDao.getTotalCount(sBufTotle.toString()));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        this.log.info((Object)"commDao.getTotalCount is succesful!!....");
        roPaging.setData(TranslateObject.translateLstSysOptLogMo(lstOptLogMo));
        this.log.info((Object)("count is:" + roPaging.getCount() + "  querySysOptLog is succesful!!"));
        return roPaging;
    }

    @Override
    public Paging querySysOptLog(OptLogQCondition oQueryCondition) {
        Paging roPaging = new Paging();
        return roPaging;
    }

    @Override
    public byte[] queryLogDetail(long logId) {
        Blob logDetail;
        byte[] logDetailByte = new byte[]{};
        String sHql = "FROM OptLogDetailMo where logId = " + logId;
        List logDetailList = this.commDao.findByHql(sHql);
        if (logDetailList != null && !logDetailList.isEmpty() && (logDetail = ((OptLogDetailMo)logDetailList.get(0)).getOpLogDetail()) != null) {
            try {
                logDetailByte = logDetail.getBytes(1L, (int)logDetail.length());
            }
            catch (SQLException e) {
                this.log.error((Object)"SQLException error", (Throwable)e);
            }
        }
        return logDetailByte;
    }

    public void deleteSysOptLog(List<OptLogMo> lstOptLogMo) {
        this.commDao.deleteAll(lstOptLogMo);
    }

    @Override
    public void writeOptLog(SysOptLog oOptLog) {
        this.writeOptLog(oOptLog, null);
    }

    @Override
    public void writeOptLog(SysOptLog oOptLog, byte[] logDetail) {
        OptLogIntegrateFactory.getInstance().getOptLogService().writeOptLog(oOptLog, logDetail);
    }

    public Paging querySysOptLogByStorage(String hql, int iStart, int iLength) {
        String sQueryCondition = "";
        Paging roPaging = new Paging();
        List lstOptLogMo = new ArrayList();
        try {
            lstOptLogMo = this.commDao.findPage(hql, iStart, iLength);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OptLogMo ");
        sBufTotle.append(sQueryCondition);
        roPaging.setData(lstOptLogMo);
        roPaging.setCount((int)this.commDao.getTotalCount(sBufTotle.toString()));
        return roPaging;
    }

    @Override
    public List<SysOptLog> exportSelectedOpLog(String ids) {
        List oplogs;
        String sHql = "FROM OptLogMo where id in (" + ids + ")";
        try {
            oplogs = this.commDao.findByHql(sHql);
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return TranslateObject.translateLstSysOptLogMo(oplogs);
    }

    @Override
    public Map<Long, byte[]> exportSelectedOpLogDetail(String ids) {
        HashMap<Long, byte[]> detailMap = new HashMap<Long, byte[]>();
        String sHql = "FROM OptLogDetailMo where logId in (" + ids + ")";
        try {
            List oplogDetails = this.commDao.findByHql(sHql);
            for (OptLogDetailMo opLogDetail : oplogDetails) {
                detailMap.put(opLogDetail.getLogId(), opLogDetail.getOpLogDetail().getBytes(1L, (int)opLogDetail.getOpLogDetail().length()));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        return detailMap;
    }

    private int getCountByHql(long endTime) {
        StringBuffer sBufTotle = new StringBuffer("select count(*) from OptLogMo where opTime < " + endTime);
        return (int)this.commDao.getTotalCount(sBufTotle.toString());
    }

    private void judgingCapacity() {
        if (this.commDao.getTotalCount("SELECT COUNT(*) FROM TaskResult WHERE taskId=1") >= 1000L) {
            BatchOperation batchope;
            int i;
            List resultId = this.commDao.findByHql("SELECT t.resultId FROM TaskResult t WHERE taskId=1 ORDER BY t.resultId ASC");
            List resultLink = this.commDao.findByHql("SELECT t.resultLink FROM TaskResult t WHERE taskId=1 ORDER BY t.resultLink ASC");
            ArrayList<BatchOperation> bathOprLst = null;
            bathOprLst = new ArrayList<BatchOperation>();
            for (i = 0; i < 100; ++i) {
                batchope = new BatchOperation();
                batchope.setTargetId((Long)resultId.get(i));
                bathOprLst.add(batchope);
            }
            this.taskService.deleteTaskResultList(bathOprLst, 1);
            bathOprLst = new ArrayList();
            for (i = 0; i < 100; ++i) {
                batchope = new BatchOperation();
                batchope.setTargetName((String)resultLink.get(i));
                bathOprLst.add(batchope);
            }
            this.taskService.deleteFile(1, bathOprLst);
        }
    }

    @Override
    public String transferLog(String fileType, long endTime, String lang, String filePath) {
        String dateTime;
        if (!this.hasEnoughMemory()) {
            return "";
        }
        this.judgingCapacity();
        this.log.info((Object)"System transferLog begin");
        StringBuffer sBufQObj = new StringBuffer("FROM OptLogMo where opTime < " + endTime);
        Paging paging = null;
        int totalNum = this.getCountByHql(endTime);
        if (totalNum <= 0) {
            this.writeOptLogNoFile();
            return "lego.dic.warningaralm.noexist";
        }
        int count = totalNum / 5000;
        if (0 != totalNum % 5000) {
            ++count;
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
        String tempfileName = dateTime = dateFormat.format(date);
        String currentPath = AticInstallUtil.getInstance().getAticInstallPath();
        this.createDirectory(currentPath + File.separator + "datastorage");
        this.log.info((Object)("create directory path:" + currentPath + File.separator + "datastorage"));
        currentPath = currentPath + File.separator + filePath;
        this.createDirectory(currentPath);
        File tempFileDir = new File(currentPath + File.separator + tempfileName);
        this.log.info((Object)("create temp directory path:" + currentPath + File.separator + tempfileName + File.separator + "detail"));
        this.createDirectory(currentPath + File.separator + tempfileName + File.separator + "detail");
        if (totalNum > 5000) {
            this.transLogMultipleFile(count, sBufQObj, fileType, lang, tempFileDir, tempfileName);
        } else {
            paging = this.querySysOptLogByStorage(sBufQObj.toString(), 0, 5000);
            List list = paging.getData();
            if (null != this.sysOptStorage) {
                this.saveLogDetail(fileType, tempFileDir, list);
                try {
                    this.sysOptStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, 1);
                }
                catch (Exception e) {
                    this.log.error((Object)"Exception error", (Throwable)e);
                }
            }
        }
        try {
            FileZip.zip(currentPath + File.separator + tempfileName, currentPath + File.separator + tempfileName + ".zip", tempfileName);
            FileZip.getInstance().deleteFile(tempFileDir);
        }
        catch (Exception e) {
            this.log.error((Object)"zip file error", (Throwable)e);
        }
        this.deleteLog(endTime);
        this.writetTransferLog(endTime, currentPath, tempfileName, totalNum);
        return tempfileName + ".zip";
    }

    private boolean hasEnoughMemory() {
        long usableMemory = this.getUsableMemory();
        if (usableMemory > 50L) {
            this.log.info((Object)("alarm transferAlarm has EnoughMemory,usableMemory:" + usableMemory + " M."));
            return true;
        }
        this.log.error((Object)("alarm transferAlarm has no EnoughMemory,usableMemory:" + usableMemory + " M."));
        return false;
    }

    private long getUsableMemory() {
        Runtime run = Runtime.getRuntime();
        long max = run.maxMemory();
        long total = run.totalMemory();
        long free = run.freeMemory();
        long usable = max - total + free;
        return usable / 0x100000L;
    }

    private void writetTransferLog(long endTime, String currentPath, String tempfileName, int totalNum) {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(true);
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.ver.storage.sysOptLog");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setTerminalIp("127.0.0.1");
        Date da = new Date(endTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dt = df.format(da);
        String filePathTemp = currentPath + File.separator + tempfileName + ".zip";
        filePathTemp = filePathTemp.replace("\\", File.separator);
        String[] para = new String[]{dt, "" + totalNum, filePathTemp};
        oOptLog.setDetailPara(para);
        oOptLog.setOperator("system");
        this.writeOptLog(oOptLog);
    }

    private boolean deleteLog(long endTime) {
        boolean result = false;
        try {
            String hql = "select o.id from OptLogMo o where o.opTime <" + endTime;
            List optLogIdList = this.commDao.findByHql(hql);
            int listSize = optLogIdList.size();
            int pageSize = listSize % 200 == 0 ? listSize / 200 : listSize / 200 + 1;
            for (int i = 0; i < pageSize; ++i) {
                StringBuffer optLogIds = new StringBuffer();
                optLogIds.append(0);
                for (int j = i * 200; j < Math.min((i + 1) * 200, listSize); ++j) {
                    optLogIds.append(',');
                    optLogIds.append(optLogIdList.get(j));
                }
                hql = "delete from OptLogDetailMo o where o.logId in (" + optLogIds.toString() + ")";
                this.commDao.updateByHql(hql);
            }
            hql = "delete from OptLogMo where opTime <" + endTime;
            this.commDao.updateByHql(hql);
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.log.error((Object)"Exception error", (Throwable)e);
        }
        return result;
    }

    private void transLogMultipleFile(int count, StringBuffer sBufQObj, String fileType, String lang, File tempFileDir, String tempfileName) {
        Paging paging = null;
        for (int i = 0; i < count; ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e1) {
                this.log.error((Object)"InterruptedException", (Throwable)e1);
            }
            paging = this.querySysOptLogByStorage(sBufQObj.toString(), i * 5000 + 1, 5000);
            List list = paging.getData();
            if (null == this.sysOptStorage) continue;
            this.saveLogDetail(fileType, tempFileDir, list);
            try {
                this.sysOptStorage.logExport(list, fileType, lang, tempFileDir, tempfileName, i);
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)"Exception error", (Throwable)e);
            }
        }
    }

    private void saveLogDetail(String fileType, File tempFileDir, List<OptLogMo> list) {
        FileUtil fileUtil = null;
        fileUtil = FileFactory.getFileUtil(fileType);
        if (null == fileUtil) {
            return;
        }
        String detailPath = tempFileDir.getAbsolutePath() + File.separator + "detail" + File.separator;
        try {
            for (OptLogMo optLog : list) {
                byte[] logDetail;
                if (optLog.getHasDetail() != 1 || (logDetail = this.queryLogDetail(optLog.getId())) == null) continue;
                fileUtil.writeDetailFile(detailPath + optLog.getId() + ".txt", logDetail);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("write detail file error" + e));
        }
    }

    private void createDirectory(String filePath) {
        File path = new File(filePath);
        try {
            boolean result;
            if (!path.isDirectory() && !(result = path.mkdirs())) {
                this.log.error((Object)("createDirectory error " + filePath));
            }
        }
        catch (SecurityException se) {
            this.log.error((Object)se.toString());
        }
    }

    public void setSysOptStorage(ISysOptStorage sysOptStorage) {
        this.sysOptStorage = sysOptStorage;
    }

    private void writeOptLogNoFile() {
        SysOptLog oOptLog = new SysOptLog();
        oOptLog.setTarget("lego.sys.sysLog.operLog");
        oOptLog.setTargetLocal(true);
        oOptLog.setDate(new Date());
        oOptLog.setDetail("lego.dic.warningaralm.noexist");
        oOptLog.setLevel(1);
        oOptLog.setModule("lego.dic.module.system");
        oOptLog.setOperation("lego.lab.storage.sysOptLog");
        oOptLog.setResult(1);
        oOptLog.setOperator("system");
        oOptLog.setTerminalIp("127.0.0.1");
        this.writeOptLog(oOptLog);
    }

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }
}

