/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.syslog.service;

import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.file.util.FileFactory;
import com.hs.lego.core.sdk.file.util.FileUtil;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.OptLogMo;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.service.ISysOptStorage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SysOptStorage
implements ISysOptStorage {
    private static final int RESNUM = 2;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private I18nMrg i18nMrg;
    private Locale locale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logExport(List<OptLogMo> logList, String fileType, String lang, File tempFile, String fileNameTmp, int serialNum) {
        this.locale = null != lang && "en".equals(lang) ? new Locale(lang) : new Locale("zh", "CN");
        String type = fileType;
        String downloadPath = tempFile.getAbsolutePath() + File.separator + fileNameTmp;
        List<String> column = this.getColumn(fileType);
        FileUtil fileUtil = null;
        try {
            fileUtil = FileFactory.getFileUtil(type);
            if (null != fileUtil) {
                fileUtil.fileSet("", column, downloadPath + serialNum);
                if (null != lang && "en".equals(lang)) {
                    fileUtil.setStrChar("UTF-8");
                } else {
                    fileUtil.setStrChar("GBK");
                }
                List<List<String>> sysLog = this.logToStrWithId(logList);
                fileUtil.writeFile(sysLog, "detail" + File.separator);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("write file error" + e), (Throwable)e);
        }
        finally {
            try {
                if (null != fileUtil) {
                    fileUtil.closeFile();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"write file error");
            }
        }
    }

    private List<List<String>> logToStrWithId(List<OptLogMo> lstLog) {
        ArrayList<List<String>> lstStr = new ArrayList<List<String>>();
        for (OptLogMo sOptLog : lstLog) {
            if (null == sOptLog.getOpName()) continue;
            List<String> tempLst = this.getOptLogString(sOptLog);
            this.addTarget(sOptLog, tempLst);
            String opDetail = sOptLog.getOpDetail();
            opDetail = opDetail == null ? "" : opDetail;
            String detail = this.getText(opDetail);
            String optDetailPama = sOptLog.getOpDetailPama();
            if (null != optDetailPama && !optDetailPama.trim().equals("")) {
                String split = "\n";
                String[] detailParam = null;
                detailParam = optDetailPama.split(split);
                int detailParamLen = detailParam.length;
                for (int i = 0; i < detailParamLen; ++i) {
                    detailParam[i] = this.getText(detailParam[i]);
                }
                try {
                    detail = MessageFormat.format(detail, detailParam);
                }
                catch (Exception ex) {
                    this.log.error((Object)"MessageFormat.format(targt, targetParam)", (Throwable)ex);
                }
            }
            if (detail != null && detail.contains("<br>")) {
                detail = detail.replaceAll("<br>", " ");
            }
            tempLst.add(detail);
            if (sOptLog.getHasDetail() == 1) {
                tempLst.add(String.valueOf(sOptLog.getId()));
            } else {
                tempLst.add(null);
            }
            lstStr.add(tempLst);
        }
        return lstStr;
    }

    private void addTarget(OptLogMo sOptLog, List<String> tempLst) {
        if (0 != sOptLog.getTargetLocal()) {
            String split = "\n";
            String param = sOptLog.getOpTargetPama();
            String[] targetParam = null;
            if (null != param && !"".equals(param.trim())) {
                targetParam = param.split(split);
                int targetParamLen = targetParam.length;
                for (int i = 0; i < targetParamLen; ++i) {
                    targetParam[i] = this.getText(targetParam[i]);
                }
                String targt = this.getText(sOptLog.getOpTarget());
                String targetLocal = "";
                try {
                    targetLocal = MessageFormat.format(targt, targetParam);
                }
                catch (Exception ex) {
                    this.log.error((Object)"MessageFormat.format(targt, targetParam)", (Throwable)ex);
                }
                tempLst.add(targetLocal);
            } else if (sOptLog.getOpTarget() != null) {
                String targt = this.getText(sOptLog.getOpTarget());
                tempLst.add(targt);
            }
        } else {
            tempLst.add(sOptLog.getOpTarget());
        }
    }

    private List<String> getOptLogString(OptLogMo sOptLog) {
        ArrayList<String> tempLst = new ArrayList<String>();
        tempLst.add(this.getText(sOptLog.getOpName()));
        if (sOptLog.getRiskLevel() == SysoplogLevel.risk.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.risk"));
        } else if (sOptLog.getRiskLevel() == SysoplogLevel.normal.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.normal"));
        } else if (sOptLog.getRiskLevel() == SysoplogLevel.warning.getValue()) {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.warn"));
        } else {
            tempLst.add(this.getText("lego.dic.syslog.dangerlevel.info"));
        }
        tempLst.add(sOptLog.getOpUser());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tempLst.add(dateFormat.format(sOptLog.getOpTime()));
        tempLst.add(this.getText(sOptLog.getOptModuleName()));
        if (0 == sOptLog.getOpResult()) {
            tempLst.add(this.getText("lego.dic.resulttype.failure"));
        } else if (sOptLog.getOpResult() == 2) {
            tempLst.add(this.getText("lego.dic.resulttype.halfsuccess"));
        } else {
            tempLst.add(this.getText("lego.dic.resulttype.success"));
        }
        tempLst.add(sOptLog.getOpIpAddress());
        return tempLst;
    }

    private List<String> getColumn(String fileType) {
        this.log.info((Object)("fileType: " + fileType));
        ArrayList<String> column = new ArrayList<String>();
        column.add(this.getText("lego.lab.log.oprationname"));
        column.add(this.getText("lego.lab.log.dangerlevel"));
        column.add(this.getText("lego.lab.log.oprationuser"));
        column.add(this.getText("lego.lab.log.oprationtime"));
        column.add(this.getText("lego.lab.log.oprationtype"));
        column.add(this.getText("lego.lab.log.oprationresult"));
        column.add(this.getText("lego.lab.log.oprationip"));
        column.add(this.getText("lego.lab.log.oprationobj"));
        column.add(this.getText("lego.lab.log.oprationdetail"));
        column.add(this.getText("lego.lab.log.detailfile"));
        return column;
    }

    public I18nMrg getI18nMrg() {
        return this.i18nMrg;
    }

    public void setI18nMrg(I18nMrg i18nMrg) {
        this.i18nMrg = i18nMrg;
    }

    private String getText(String key) {
        return this.i18nMrg.getString(key, this.locale);
    }
}

