/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.csrf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.filter.csrf.CsrfGuargXmlHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.Locale;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public final class CsrfGuard {
    public static final String SESSION_KEY_NAME = "CFNMAE_S";
    public static final String CHECK_KEY_NAME = "cfNameHF";
    public static final String CHECK_KEY_NAME_FLAG = "needCfNameCheck";
    private static final CsrfGuard INSTANCE = new CsrfGuard();
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public static CsrfGuard getInstance() {
        return INSTANCE;
    }

    public String getNewValue() {
        return UUID.randomUUID().toString();
    }

    public boolean isValidRequest(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("csrf check error, xhrToken : " + e.getMessage()));
            return false;
        }
        uri = Normalizer.normalize(uri, Normalizer.Form.NFKC);
        boolean validRequest = false;
        boolean isWeakWhiteURL = CsrfGuargXmlHelper.getInstance().isWeakWhiteURL(uri);
        if (isWeakWhiteURL) {
            validRequest = true;
        } else {
            boolean approval = this.validCsrfToken(request);
            if (approval) {
                validRequest = true;
            }
        }
        return validRequest;
    }

    private boolean validCsrfToken(HttpServletRequest request) {
        boolean valid = false;
        HttpSession session = request.getSession(false);
        String sToken = (String)session.getAttribute(SESSION_KEY_NAME);
        if (sToken != null && !sToken.isEmpty()) {
            String paramToken;
            String xhrToken = request.getHeader(CHECK_KEY_NAME);
            if (null == xhrToken || xhrToken.isEmpty()) {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
                if (isMultipart) {
                    request.setAttribute(CHECK_KEY_NAME_FLAG, (Object)true);
                    return true;
                }
                xhrToken = request.getParameter(CHECK_KEY_NAME);
            }
            if (null != (paramToken = request.getParameter(CHECK_KEY_NAME)) && !paramToken.isEmpty()) {
                paramToken = Normalizer.normalize(paramToken, Normalizer.Form.NFKC);
            }
            if (null != paramToken && paramToken.contains(",")) {
                paramToken = paramToken.substring(0, paramToken.indexOf(44)).trim();
            }
            valid = this.check(valid, sToken, xhrToken, paramToken);
        }
        return valid;
    }

    private boolean check(boolean valid, String sToken, String xhrToken, String paramToken) {
        if (xhrToken != null && sToken.equals(xhrToken)) {
            if (this.validTokenFormat(xhrToken)) {
                valid = true;
            } else {
                LOG.error((Object)"csrf check error, xhrToken : ***");
            }
        } else if (paramToken != null && sToken.equals(paramToken)) {
            if (this.validTokenFormat(paramToken)) {
                valid = true;
            } else {
                LOG.error((Object)"csrf check error, paramToken : ***");
            }
        } else {
            LOG.error((Object)"csrf check error, default null : ");
        }
        return valid;
    }

    private boolean validTokenFormat(String token) {
        if (null == token) {
            return false;
        }
        String uuid = token.toUpperCase(Locale.US);
        uuid = Normalizer.normalize(uuid, Normalizer.Form.NFKC);
        boolean retVal = false;
        String regex = "[A-F0-9]{8}(?:-[A-F0-9]{4}){3}-[A-Z0-9]{12}";
        if (uuid.matches(regex)) {
            retVal = true;
        }
        return retVal;
    }
}

