/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.csrf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.filter.csrf.CsrfGuard;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.Normalizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CsrfGuardFilter
implements Filter {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        uri = URLDecoder.decode(uri, "UTF-8");
        uri = Normalizer.normalize(uri, Normalizer.Form.NFKC);
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        if (csrfGuard.isValidRequest(httpRequest, httpResponse)) {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else {
            this.log.error((Object)("Check CSRF error url=" + uri));
            httpRequest.getSession().invalidate();
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/pages/common/exception.jsp?timeout=true");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

