/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.csrf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class CsrfGuargXmlHelper {
    private static final String WEAK_WHITE_URL_FPATH = "csrfWeakWhiteUris.xml";
    private static final Object LOCK = new Object();
    private static CsrfGuargXmlHelper instanceObj = null;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private List<String> weakWhiteUrisArray = new ArrayList<String>();

    private CsrfGuargXmlHelper() {
        this.parser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsrfGuargXmlHelper getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == instanceObj) {
                instanceObj = new CsrfGuargXmlHelper();
            }
            return instanceObj;
        }
    }

    private void parser() {
        this.weakWhiteUrisArray = this.parseXml(WEAK_WHITE_URL_FPATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parseXml(String path) {
        InputStream fin = null;
        Document doc = null;
        ArrayList<String> resultList = new ArrayList<String>();
        ClassLoader cl = CsrfGuargXmlHelper.class.getClassLoader();
        if (null == cl) {
            this.log.info((Object)"ClassLoader not found");
            return resultList;
        }
        fin = cl.getResourceAsStream(path);
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            doc = reader.read(fin);
            Element root = doc.getRootElement();
            for (Element el : root.elements("entry")) {
                String key = el.attribute("url").getText().trim();
                if (key.isEmpty()) continue;
                resultList.add(key);
            }
        }
        catch (DocumentException e) {
            this.log.error((Object)(path + " read error"), (Throwable)e);
        }
        catch (SAXException e) {
            this.log.error((Object)" SAXException error", (Throwable)e);
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    this.log.error((Object)"Close file error");
                }
            }
        }
        return resultList;
    }

    public boolean isWeakWhiteURL(String url) {
        for (String s : this.weakWhiteUrisArray) {
            String validateUrl = Normalizer.normalize(url, Normalizer.Form.NFKC);
            if (!validateUrl.endsWith(s.trim())) continue;
            return true;
        }
        return false;
    }
}

