/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.urlf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.filter.urlf.UrlWhiteListHelper;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.Normalizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UrlWhiteFilter
implements Filter {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        if ((uri = URLDecoder.decode(uri, "UTF-8")).indexOf(";") >= 0) {
            uri = uri.substring(0, uri.indexOf(";"));
        }
        HttpSession session = httpRequest.getSession(false);
        uri = Normalizer.normalize(uri, Normalizer.Form.NFKC);
        if (null != session && uri.contains(".do")) {
            if (UrlWhiteListHelper.validateInWhiteUrl(httpRequest, uri)) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.log.error((Object)("Check White Url error url=" + uri));
                httpResponse.sendError(400);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

