/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.interceptor;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.exception.ExceptionAction;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CheckParamsInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 27714029349254722L;
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public String intercept(ActionInvocation invocation) throws Exception {
        if (invocation.getAction() instanceof ExceptionAction) {
            try {
                return invocation.invoke();
            }
            catch (Exception e) {
                LOG.error((Object)"error", (Throwable)e);
                HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
                HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                response.sendRedirect(request.getContextPath() + "/pages/common/exception.jsp");
                return null;
            }
        }
        String namespace = invocation.getProxy().getNamespace();
        String actionName = invocation.getProxy().getActionName();
        if ("getFirstPage".equals(actionName) || "getFirstPage4Iemp".equals(actionName) || "getLeftMenu4Iemp".equals(actionName)) {
            LOG.info((Object)"getFirstPage, getFirstPage4Iemp or getLeftMenu4Iemp");
        } else if ("/".equals(namespace) ? !"dataDrill".equals(actionName) : !namespace.startsWith("/elog/")) {
            return invocation.invoke();
        }
        Map params = invocation.getInvocationContext().getParameters();
        for (Map.Entry key : params.entrySet()) {
            Object value = key.getValue();
            if (value instanceof String[]) {
                for (String str : (String[])value) {
                    if (!this.checkForbiddenChar(str)) continue;
                    throw new LegoCheckedException(1L, new String[]{"legotag.valid.invalidChar"});
                }
                continue;
            }
            if (value instanceof String) {
                if (!this.checkForbiddenChar((String)value)) continue;
                throw new LegoCheckedException(1L, new String[]{"legotag.valid.invalidChar"});
            }
            LOG.info((Object)(value.getClass() + ":" + (String)key.getKey() + "=" + value));
        }
        return invocation.invoke();
    }

    private boolean checkForbiddenChar(String str) {
        char[] forbid;
        for (char c : forbid = new char[]{'\'', '\"', '<', '>', '\\'}) {
            if (str.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }
}

