/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.log;

import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import java.io.Serializable;

public final class OperateLog
implements Serializable {
    private static final long serialVersionUID = -4553905163990316631L;
    private SysOptLog sysLog = null;

    private void log(String operation, String module, String target) {
        this.sysLog = new SysOptLog();
        this.sysLog.setOperation(operation);
        this.sysLog.setModule(module);
        this.sysLog.setTarget(target);
    }

    public void log(String operation, SysoplogLevel level, String module, String target, boolean targetLocal, String detail, String[] detailPara) {
        OperateLog.getcleanedMessage(detailPara);
        this.log(operation, module, target);
        this.sysLog.setDetail(detail);
        this.sysLog.setDetailPara(detailPara);
        this.sysLog.setLevel(level.getValue());
        this.sysLog.setTargetLocal(targetLocal);
    }

    public void log(String operation, SysoplogLevel level, String module, String target, boolean targetLocal, String[] targetPara, String detail, String[] detailPara) {
        OperateLog.getcleanedMessage(targetPara);
        OperateLog.getcleanedMessage(detailPara);
        this.log(operation, module, target);
        this.sysLog.setDetail(detail);
        this.sysLog.setDetailPara(detailPara);
        this.sysLog.setLevel(level.getValue());
        this.sysLog.setTargetLocal(targetLocal);
        this.sysLog.setTargetPara(targetPara);
    }

    public void info(String operation, String module) {
        this.log(operation, module, "");
        this.sysLog.setLevel(SysoplogLevel.info.getValue());
    }

    public void info(String operation, String module, String target) {
        this.log(operation, module, target);
        this.sysLog.setLevel(SysoplogLevel.info.getValue());
    }

    public void info(String operation, String module, String target, boolean targetLocal, String detail, String[] detailPara) {
        this.log(operation, SysoplogLevel.info, module, target, targetLocal, detail, detailPara);
    }

    public void warning(String operation, String module) {
        this.log(operation, module, "");
        this.sysLog.setLevel(SysoplogLevel.warning.getValue());
    }

    public void warning(String operation, String module, String target) {
        this.log(operation, module, target);
        this.sysLog.setLevel(SysoplogLevel.warning.getValue());
    }

    public void warning(String operation, String module, String target, boolean targetLocal, String detail, String[] detailPara) {
        this.log(operation, SysoplogLevel.warning, module, target, targetLocal, detail, detailPara);
    }

    public void normal(String operation, String module) {
        this.log(operation, module, "");
        this.sysLog.setLevel(SysoplogLevel.normal.getValue());
    }

    public void normal(String operation, String module, String target) {
        this.log(operation, module, target);
        this.sysLog.setLevel(SysoplogLevel.normal.getValue());
    }

    public void normal(String operation, String module, String target, boolean targetLocal, String detail, String[] detailPara) {
        this.log(operation, SysoplogLevel.normal, module, target, targetLocal, detail, detailPara);
    }

    public void risk(String operation, String module) {
        this.log(operation, module, "");
        this.sysLog.setLevel(SysoplogLevel.risk.getValue());
    }

    public void risk(String operation, String module, String target) {
        this.log(operation, module, target);
        this.sysLog.setLevel(SysoplogLevel.risk.getValue());
    }

    public void risk(String operation, String module, String target, boolean targetLocal, String detail, String[] detailPara) {
        this.log(operation, SysoplogLevel.risk, module, target, targetLocal, detail, detailPara);
    }

    SysOptLog getSysLog() {
        return this.sysLog;
    }

    private static void getcleanedMessage(String[] message) {
        if (message != null) {
            for (int i = 0; i < message.length; ++i) {
                message[i] = message[i].replace('\n', ' ').replace('\r', ' ');
            }
        }
    }
}

