/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class UiBaseUtil {
    private static final String CUSTOM_PROPERTIES = "custom.conf";
    private static final Object LOCK = new Object();
    private static UiBaseUtil instance;
    private String portalShow;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UiBaseUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new UiBaseUtil();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPara() {
        String path = UiBaseUtil.class.getResource("/").getPath() + ".." + File.separator + CUSTOM_PROPERTIES;
        this.logger.info((Object)("custom.conf path: " + path));
        InputStream inpStr = null;
        Properties prop = null;
        try {
            File file = new File(URLDecoder.decode(path, "utf-8"));
            if (file.exists()) {
                prop = new Properties();
                inpStr = new FileInputStream(file);
                prop.load(inpStr);
                this.portalShow = prop.get("showPortal").toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)"custom.conf UnsupportedEncodingException", (Throwable)e);
            this.portalShow = "true";
        }
        catch (IOException e) {
            this.logger.error((Object)"custom.conf IOException");
            this.portalShow = "true";
        }
        finally {
            try {
                if (null != inpStr) {
                    inpStr.close();
                }
            }
            catch (IOException iex) {
                this.logger.error((Object)"initPara error.");
            }
            if (null != prop) {
                prop.clear();
            }
        }
    }

    public String getRemoteAddr(HttpServletRequest req) {
        String ipAddress = req.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = req.getRemoteAddr();
        } else {
            int index = ipAddress.indexOf(",");
            if (index > 0) {
                ipAddress = ipAddress.substring(0, index);
            }
        }
        return ipAddress;
    }

    public boolean isPortalShow() {
        if (this.portalShow == null || this.portalShow.isEmpty()) {
            this.initPara();
        }
        return Boolean.valueOf(this.portalShow);
    }
}

