/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.webapp.action;

import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.log.OperateLog;
import com.hs.lego.ui.tag.tools.IAuthHandler;
import com.opensymphony.xwork2.ActionSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.struts2.ServletActionContext;

public class BaseAction
extends ActionSupport {
    public static final String CANCEL = "cancel";
    private static final long serialVersionUID = 3525445612504421307L;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    protected int pageSize = 10;
    protected int start = 0;
    protected int total;
    protected BatchOperationResult batchOperationResult = null;
    private List<LangPair> batchOpeList;
    private OperateLog operateLog = new OperateLog();
    private IAuthHandler authHandler;

    public BaseAction() {
        try {
            PageSizeConfigService service = (PageSizeConfigService)ServiceContext.getInstance().getService("pageSizeConfigService", PageSizeConfigService.class);
            List<PageSizeConfig> list = service.findPageSizeNum("pageSize");
            if (list != null && !list.isEmpty()) {
                for (PageSizeConfig pageSizeConfig : list) {
                    this.pageSize = Integer.parseInt(pageSizeConfig.getSysValue());
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"log getPageSize error", (Throwable)e);
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isAuthority(String authId) {
        if (this.authHandler == null) {
            this.authHandler = (IAuthHandler)ServletActionContext.getRequest().getSession().getAttribute("auth_handler");
            if (this.authHandler == null) {
                return false;
            }
            return this.authHandler.isAuthority(authId);
        }
        return this.authHandler.isAuthority(authId);
    }

    public void setPageSize(int pageSize) {
        if (pageSize != 10 && pageSize != 20 && pageSize != 30 && pageSize != 50 && pageSize != 100) {
            return;
        }
        this.pageSize = pageSize;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (start <= 0) {
            return;
        }
        this.start = start;
    }

    protected HttpSession getSession() {
        return this.fetchRequest().getSession();
    }

    protected HttpServletRequest fetchRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(String string) {
        PrintWriter writer = null;
        try {
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store");
            this.getResponse().setDateHeader("Expires", 0L);
            this.getResponse().setContentType("text/html;charset=UTF-8");
            writer = this.getResponse().getWriter();
            writer.write(string);
            writer.flush();
        }
        catch (Exception e) {
            this.log.error((Object)("write response:" + string), (Throwable)e);
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public void validate() {
        Map fieldErrors = this.getFieldErrors();
        if (fieldErrors == null || fieldErrors.isEmpty()) {
            return;
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        for (String key : fieldErrors.keySet()) {
            this.log.error((Object)("**************parameters validate error, id:-->" + key));
        }
        if (user == null) {
            throw new LegoSecurityException(206L);
        }
        SysOptLog optLog = new SysOptLog();
        optLog.setOperation("lego.err.error");
        optLog.setModule("lego.dic.module.user");
        optLog.setLevel(SysoplogLevel.warning.getValue());
        optLog.setOperator(user.getUserName().trim());
        optLog.setTargetLocal(true);
        optLog.setTarget("lego.dic.module.user");
        optLog.setTerminalIp(((User)this.getSession().getAttribute("currentUser")).getIpAdr());
        optLog.setResult(0);
        optLog.setDetail("lego.err.dataerror");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysOptLog.writeOptLog(optLog);
        this.fetchRequest().getSession().invalidate();
        Iterator iterator = fieldErrors.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            throw new LegoSecurityException(206L, key);
        }
        throw new LegoSecurityException(206L);
    }

    public String batchOper() {
        HttpSession session = this.getSession();
        this.batchOpeList = new ArrayList<LangPair>();
        if (session.getAttribute("session.oper.catch") != null) {
            this.batchOperationResult = (BatchOperationResult)session.getAttribute("session.oper.catch");
            List<BatchOperation> batchTemLst = this.batchOperationResult.getResult();
            for (BatchOperation batchOp : batchTemLst) {
                this.processOper(batchOp);
            }
        } else {
            this.batchOperationResult = new BatchOperationResult();
        }
        return "success";
    }

    private void processOper(BatchOperation batchOp) {
        if (batchOp.getErrorCode() != 0L) {
            String targetName = "";
            String[] targetNameParam = batchOp.getTargetNameParam();
            if (null != targetNameParam && targetNameParam.length > 0) {
                int targetNameParamLen = targetNameParam.length;
                for (int i = 0; i < targetNameParamLen; ++i) {
                    targetNameParam[i] = this.getIntelizeText(targetNameParam[i]);
                }
                targetName = this.getText(batchOp.getTargetName(), targetNameParam);
            } else {
                targetName = this.getIntelizeText(batchOp.getTargetName());
            }
            String detail = "";
            String[] param = batchOp.getDetailParam();
            if (null != param && param.length > 0) {
                for (int i = 0; i < param.length; ++i) {
                    param[i] = this.getIntelizeText(param[i]);
                }
                detail = this.getText("lego.err." + batchOp.getErrorCode(), param);
            } else {
                detail = this.getText("lego.err." + batchOp.getErrorCode());
            }
            LangPair langPair = new LangPair(targetName, detail);
            this.batchOpeList.add(langPair);
        }
    }

    private String getIntelizeText(String strText) {
        String temp = "";
        if (null == strText) {
            return "";
        }
        if (-1 == strText.indexOf("[") && -1 == strText.indexOf("]")) {
            try {
                temp = this.getText(strText);
                return temp;
            }
            catch (Exception ex) {
                this.log.error((Object)"log getText error", (Throwable)ex);
            }
        } else {
            return strText;
        }
        return strText;
    }

    protected void bathResult(BatchOperationResult operationResult) {
        this.batchOperationResult = operationResult;
        if (operationResult.getFailCount() == 0) {
            this.responseResult("success");
        } else {
            HttpSession session = this.getSession();
            if (session.getAttribute("session.oper.catch") != null) {
                session.removeAttribute("session.oper.catch");
            }
            session.setAttribute("session.oper.catch", (Object)operationResult);
            this.responseResult("failure");
        }
    }

    public boolean validateURLParameters(String whiteStr) {
        String str = whiteStr.replaceAll("\\s", "");
        String[] whiteList = str.split(",");
        if (null == this.fetchRequest().getParameterMap()) {
            return true;
        }
        Set ss = this.fetchRequest().getParameterMap().keySet();
        if (null == ss) {
            return true;
        }
        HashSet<String> whiteParaSet = new HashSet<String>();
        whiteParaSet.addAll(Arrays.asList("cfNameHF", "_dc", "start", "pageSize"));
        whiteParaSet.addAll(Arrays.asList(whiteList));
        return whiteParaSet.containsAll(ss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(Object obj) {
        PrintWriter writer = null;
        try {
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store");
            this.getResponse().setDateHeader("Expires", 0L);
            this.getResponse().setContentType("text/html;charset=UTF-8");
            writer = this.getResponse().getWriter();
            String s = null;
            s = JSONObject.fromObject((Object)obj).toString();
            writer.write(s);
            writer.flush();
        }
        catch (Exception e) {
            this.log.error((Object)("write response:" + obj.toString()), (Throwable)e);
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public OperateLog getOperateLog() {
        return this.operateLog;
    }

    public BatchOperationResult getBatchOperationResult() {
        return this.batchOperationResult;
    }

    public void setBatchOperationResult(BatchOperationResult batchOperationResult) {
        this.batchOperationResult = batchOperationResult;
    }

    public List<LangPair> getBatchOpeList() {
        return this.batchOpeList;
    }

    public void setBatchOpeList(List<LangPair> batchOpeList) {
        this.batchOpeList = batchOpeList;
    }
}

