/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.custom.help.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.custom.help.vo.HelpInfo;
import com.hs.lego.ui.plat.custom.help.vo.ParamInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class HelpConfig {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static Map<String, HelpInfo> menuConfig = new HashMap<String, HelpInfo>();
    private static Map<String, HelpInfo> pageConfig = new HashMap<String, HelpInfo>();
    private static boolean nonInit = true;

    private HelpConfig() {
    }

    private static void init() {
        HelpConfig.readCfg("/../../help/menuConfig.xml", menuConfig);
        HelpConfig.readCfg("/../../help/pageConfig.xml", pageConfig);
        nonInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readCfg(String path, Map<String, HelpInfo> map) {
        block16: {
            InputStream in = null;
            SAXReader reader = new SAXReader();
            try {
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                in = HelpConfig.class.getResourceAsStream(path);
                if (in == null) {
                    HelpConfig.destroy(in);
                    return;
                }
                Document xmlDoc = reader.read(in);
                List configElementList = xmlDoc.selectNodes("//config");
                for (Element configElement : configElementList) {
                    Element urlElement;
                    Element keyElement = configElement.element("key");
                    if (keyElement == null) {
                        LOG.error((Object)"Help Config readConfig : no Key");
                        continue;
                    }
                    String textId = keyElement.getTextTrim();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("textId: " + textId));
                    }
                    HelpInfo helpInfo = new HelpInfo();
                    List paramsElementList = configElement.elements("params");
                    if (null != paramsElementList && !paramsElementList.isEmpty()) {
                        ParamInfo[] paramsArray = new ParamInfo[paramsElementList.size()];
                        int j = paramsElementList.size();
                        for (int i = 0; i < j; ++i) {
                            paramsArray[i] = HelpConfig.createParamInfo((Element)paramsElementList.get(i));
                        }
                        helpInfo.setParams(paramsArray);
                    }
                    if ((urlElement = configElement.element("url")) != null) {
                        String url = urlElement.getTextTrim();
                        helpInfo.setHelpUrl(url);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("url: " + url));
                        }
                    }
                    map.put(textId, helpInfo);
                }
                HelpConfig.destroy(in);
            }
            catch (DocumentException e) {
                LOG.error((Object)"HelpConfig readConfig", (Throwable)e);
            }
            catch (SAXException e2) {
                LOG.error((Object)"HelpConfig readConfig", (Throwable)e2);
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                HelpConfig.destroy(in);
            }
        }
    }

    private static void destroy(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error((Object)"HelpConfig readConfig");
            }
        }
    }

    private static ParamInfo createParamInfo(Element paramsElement) {
        List paramElementList = paramsElement.elements("param");
        String[] paramArray = new String[paramElementList.size()];
        int j = paramElementList.size();
        for (int i = 0; i < j; ++i) {
            paramArray[i] = "&" + ((Element)paramElementList.get(i)).getTextTrim() + "&";
        }
        String url = paramsElement.element("url").getTextTrim();
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("param: ");
            for (String param : paramArray) {
                sb.append(param).append(' ');
            }
            sb.append(" url:");
            sb.append(url);
            LOG.debug((Object)sb);
        }
        return new ParamInfo(paramArray, url);
    }

    public static String getHelpCfg(String url, String menu, String topMenu) {
        int split;
        if (nonInit) {
            HelpConfig.init();
        }
        String paramString = null;
        if (null != url && (split = url.indexOf("?")) >= 0) {
            paramString = url.substring(split + 1);
            url = url.substring(0, split);
        }
        HelpInfo cfg = null;
        if (url != null && !"".equals(url)) {
            cfg = pageConfig.get(url);
        }
        if (cfg == null && null != menu && (cfg = menuConfig.get(HelpConfig.filterCfName(menu))) == null) {
            cfg = menuConfig.get(topMenu);
        }
        if (cfg == null) {
            return null;
        }
        return cfg.getHelpUrl(paramString);
    }

    private static String filterCfName(String strMenu) {
        int cfnameBeginIndex = strMenu.indexOf("?cfNameHF=");
        if (-1 == cfnameBeginIndex && -1 == (cfnameBeginIndex = strMenu.indexOf("&cfNameHF="))) {
            return strMenu;
        }
        return strMenu.substring(0, cfnameBeginIndex);
    }
}

