/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.custom.help.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class UrlConfigUtil {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static Map<String, String> tempMap = new HashMap<String, String>();

    private UrlConfigUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readCfg(String path) {
        InputStream in = null;
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            in = UrlConfigUtil.class.getResourceAsStream(path);
            if (in == null) {
                return;
            }
            Document xmlDoc = reader.read(in);
            List configElementList = xmlDoc.selectNodes("//config");
            for (Element configElement : configElementList) {
                String value;
                Element keyElement = configElement.element("url");
                Element serialnumber = configElement.element("serialnumber");
                if (null == keyElement || null == serialnumber) continue;
                String textId = keyElement.getTextTrim().indexOf("?") > -1 ? keyElement.getTextTrim().substring(0, keyElement.getTextTrim().indexOf("?")) : keyElement.getTextTrim();
                String string = value = serialnumber.getTextTrim().indexOf("?") > -1 ? serialnumber.getTextTrim().substring(0, serialnumber.getTextTrim().indexOf("?")) : serialnumber.getTextTrim();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("textId/value: " + textId + "/" + value));
                }
                tempMap.put(textId, value);
            }
        }
        catch (DocumentException e) {
            LOG.error((Object)"UrlConfig read", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"UrlConfig read", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"UrlConfig read error");
                }
            }
        }
    }

    public static String getSerialnumberByUrl(String url) {
        UrlConfigUtil.readCfg("/../../help/urlConfig.xml");
        String serialnumber = null;
        if (null == url) {
            return serialnumber;
        }
        if (tempMap.isEmpty()) {
            return serialnumber;
        }
        Set<String> ks = tempMap.keySet();
        for (String k : ks) {
            if (!url.equals(k)) continue;
            serialnumber = tempMap.get(url);
            break;
        }
        return serialnumber;
    }
}

