/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.fault.webapp.action;

import com.hs.lego.cbb.fault.sdk.service.FaultStatisticParentService;
import com.hs.lego.cbb.fault.sdk.service.IAlertNotifyParentService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.AlertAudioSetting;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.fault.webapp.vo.StatisticVO;

public class AlarmStatisticAction
extends BaseAction {
    private static final long serialVersionUID = 1159516109636294760L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_FAULT);

    public void faultStatistic() {
        try {
            User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
            if (null == currentUser) {
                LOGGER.info((Object)"faultStatistic:currentUser is null.");
                return;
            }
            long userId = currentUser.getUserID();
            FaultStatisticParentService faultStatisticService = (FaultStatisticParentService)ServiceContext.getInstance().getService("faultStatisticService", FaultStatisticParentService.class);
            IAlertNotifyParentService alertNotifyService = (IAlertNotifyParentService)ServiceContext.getInstance().getService("alertNotifyService", IAlertNotifyParentService.class);
            StatisticVO statistic = null;
            long[] overallStatistic = faultStatisticService.getFaultStatistic(userId);
            if (null != overallStatistic) {
                AlertAudioSetting setting = alertNotifyService.getAudioSettingForm(currentUser.getUserID());
                if (null == setting) {
                    return;
                }
                statistic = new StatisticVO((int)overallStatistic[0], (int)overallStatistic[1], (int)overallStatistic[2], (int)overallStatistic[3], (int)overallStatistic[4], (int)overallStatistic[5], (int)overallStatistic[6], (int)overallStatistic[7], setting.isIsEnabled(), setting.isIsEnabledInfo(), setting.isIsEnabledWarn(), setting.isIsEnabledMajor(), setting.isIsEnabledCritical(), setting.getAudioInfo(), setting.getAudioWarn(), setting.getAudioMajor(), setting.getAudioCritical());
            }
            if (null == statistic) {
                LOGGER.error((Object)"AlarmStatisticAction::faultStatistic error, statistic is null.");
                return;
            }
            this.responseResult(statistic);
        }
        catch (Exception e) {
            LOGGER.error((Object)"getAllNetCount error", (Throwable)e);
        }
    }
}

