/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.util;

import java.util.HashMap;
import java.util.Map;

public final class LoginMgrUtil {
    private static final Object LOCK = new Object();
    private static int maxFailNumber = 3;
    private static int maxAuthFailNumber = 3;
    private static LoginMgrUtil instance;
    private static Map<String, Integer> loginFailData;
    private static Map<String, Integer> authFailData;

    private LoginMgrUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginMgrUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new LoginMgrUtil();
                loginFailData = new HashMap<String, Integer>();
                authFailData = new HashMap<String, Integer>();
            }
            return instance;
        }
    }

    public void loginFail(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number == null) {
            loginFailData.put(ip, 1);
        } else {
            loginFailData.put(ip, number + 1);
        }
    }

    public void loginSuccess(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number != null) {
            loginFailData.remove(ip);
        }
        if ((number = authFailData.get(userName)) != null) {
            authFailData.remove(userName);
        }
    }

    public boolean needVerifyCode(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number == null) {
            return false;
        }
        return number >= maxFailNumber;
    }

    public void authFail(String userName) {
        Integer number = authFailData.get(userName);
        if (number == null) {
            authFailData.put(userName, 1);
        } else {
            authFailData.put(userName, number + 1);
        }
    }

    public void authSuccess(String userName) {
        Integer number = authFailData.get(userName);
        if (number != null) {
            authFailData.remove(userName);
        }
    }

    public boolean needLogout(String userName) {
        Integer number = authFailData.get(userName);
        if (number == null) {
            return false;
        }
        return number >= maxAuthFailNumber;
    }
}

