/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.common.sdk.util;

import com.hs.lego.core.sdk.util.IPUtil;

public final class IPUtil4Atic {
    private IPUtil4Atic() {
    }

    public static String convert2CompleteIpV6(String ip) {
        if (!IPUtil.isIpv6(ip)) {
            return ip;
        }
        return IPUtil.convert2CompleteIpV6AllZero(ip);
    }

    public static String convert2CompleteIpV4(String ip) {
        if (!IPUtil.isIpv4(ip)) {
            return ip;
        }
        StringBuilder finalReturnStr = new StringBuilder();
        String[] items = ip.split("\\.");
        for (int i = 0; i < items.length; ++i) {
            for (int len = 0; len < 3 - items[i].length(); ++len) {
                finalReturnStr.append('0');
            }
            finalReturnStr.append(items[i]);
            if (i == items.length - 1) continue;
            finalReturnStr.append('.');
        }
        return finalReturnStr.toString();
    }

    public static String convert2CompleteIp(String ip) {
        if (null == ip) {
            return "";
        }
        if (IPUtil.isIpv4(ip)) {
            return IPUtil4Atic.convert2CompleteIpV4(ip);
        }
        if (IPUtil.isIpv6(ip)) {
            return IPUtil4Atic.convert2CompleteIpV6(ip);
        }
        return "";
    }

    public static String compressIPv4(String ip) {
        if (!IPUtil.isIpv4(ip)) {
            return ip;
        }
        String[] items = ip.split("\\.");
        return Integer.parseInt(items[0]) + "." + Integer.parseInt(items[1]) + "." + Integer.parseInt(items[2]) + "." + Integer.parseInt(items[3]);
    }

    public static String compressIP(String ip) {
        if (IPUtil.isIpv4(ip)) {
            String[] items = ip.split("\\.");
            return Integer.parseInt(items[0]) + "." + Integer.parseInt(items[1]) + "." + Integer.parseInt(items[2]) + "." + Integer.parseInt(items[3]);
        }
        if (IPUtil.isIpv6(ip)) {
            return IPUtil.compressIPv6(ip);
        }
        return ip;
    }

    public static boolean isInIpRange(String[] ipRange, String ip) {
        try {
            if (null == ipRange || ipRange.length != 2) {
                return false;
            }
            if (!(IPUtil.isIpv4(ipRange[0]) && IPUtil.isIpv4(ipRange[1]) && IPUtil.isIpv4(ip) || IPUtil.isIpv6(ipRange[0]) && IPUtil.isIpv6(ipRange[1]) && IPUtil.isIpv6(ip))) {
                return false;
            }
            if (IPUtil.compareTo(ipRange[0], ipRange[1]) == 1) {
                return false;
            }
            return IPUtil.isInIpRange(ipRange, ip);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean checkStartEndIpArray(String[] ipRange) {
        if (null == ipRange || ipRange.length != 2) {
            return false;
        }
        if (IPUtil.isIpv4(ipRange[0]) && IPUtil.isIpv4(ipRange[1]) || IPUtil.isIpv6(ipRange[0]) && IPUtil.isIpv6(ipRange[1])) {
            return IPUtil.compareTo(ipRange[0], ipRange[1]) < 1;
        }
        return false;
    }

    public static boolean isInIpRange(String[] ipRange, String[] srcIpRange) {
        if (!IPUtil4Atic.checkStartEndIpArray(srcIpRange) || !IPUtil4Atic.checkStartEndIpArray(ipRange)) {
            return false;
        }
        if (IPUtil.compareTo(ipRange[0], ipRange[1]) == 1) {
            return false;
        }
        if (IPUtil.compareTo(srcIpRange[0], srcIpRange[1]) == 1) {
            return false;
        }
        return IPUtil4Atic.isInIpRange(ipRange, srcIpRange[0]) && IPUtil.isInIpRange(ipRange, srcIpRange[1]);
    }

    public static boolean isCrossIpRange(String[] ipRange, String[] srcIpRange) {
        if (!IPUtil4Atic.checkStartEndIpArray(srcIpRange) || !IPUtil4Atic.checkStartEndIpArray(ipRange)) {
            return false;
        }
        if (IPUtil.compareTo(ipRange[0], ipRange[1]) == 1) {
            return false;
        }
        if (IPUtil.compareTo(srcIpRange[0], srcIpRange[1]) == 1) {
            return false;
        }
        if (IPUtil.isIpv4(srcIpRange[0]) && IPUtil.isIpv4(ipRange[0]) || IPUtil.isIpv6(srcIpRange[0]) && IPUtil.isIpv6(ipRange[0])) {
            return IPUtil.compareTo(srcIpRange[0], ipRange[1]) < 1 && IPUtil.compareTo(srcIpRange[1], ipRange[0]) > -1;
        }
        return false;
    }

    public static String convertIpAndMask2Complete(String ipAndMask) {
        String ip = ipAndMask.split("/")[0];
        String mask = ipAndMask.split("/")[1];
        if (IPUtil.isIpv4(ip)) {
            return IPUtil4Atic.convert2CompleteIpV4(ip);
        }
        if (IPUtil.isIpv6(ip)) {
            return IPUtil4Atic.convert2CompleteIpV6(ip);
        }
        String result = ip + "/" + mask;
        return result.trim();
    }

    public static boolean ipEquals(String fip, String sip) {
        if (IPUtil.isIpv4(fip) && IPUtil.isIpv4(sip) || IPUtil.isIpv6(fip) && IPUtil.isIpv6(sip)) {
            return IPUtil.compareTo(fip, sip) == 0;
        }
        return false;
    }

    public static boolean isIpv4Mask(String mask) {
        String regex = "^1[0-9]|2[0-9]|3[0-2]|[8-9]$";
        return !IPUtil4Atic.isNull(mask) && mask.matches(regex);
    }

    public static boolean isIpv6Mask(String mask) {
        String regex = "^[89]$|^[1-9][0-9]$|^1[0-2][0-8]$";
        return !IPUtil4Atic.isNull(mask) && mask.matches(regex);
    }

    public static boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    public static String mask2ipMask(String mask) {
        String ipMask = null;
        if (mask.contains(".")) {
            ipMask = mask;
        } else {
            int inetMask = Integer.parseInt(mask);
            int part = inetMask / 8;
            int remainder = inetMask % 8;
            int sum = 0;
            for (int i = 8; i > 8 - remainder; --i) {
                sum += (int)Math.pow(2.0, i - 1);
            }
            if (part == 0) {
                ipMask = sum + ".0.0.0";
            } else if (part == 1) {
                ipMask = "255." + sum + ".0.0";
            } else if (part == 2) {
                ipMask = "255.255." + sum + ".0";
            } else if (part == 3) {
                ipMask = "255.255.255." + sum;
            } else if (part == 4) {
                ipMask = "255.255.255.255";
            }
        }
        return ipMask;
    }

    public static int maskStr2InetMask(String maskStr) {
        int inetmask = 0;
        int count = 0;
        String[] ipSegment = maskStr.split("\\.");
        for (int n = 0; n < ipSegment.length; ++n) {
            StringBuffer sb = IPUtil4Atic.toBin(Integer.parseInt(ipSegment[n]));
            String str = sb.reverse().toString();
            count = 0;
            for (int i = 0; i < str.length() && (i = str.indexOf(49, i)) != -1; ++i) {
                ++count;
            }
            inetmask += count;
        }
        return inetmask;
    }

    private static StringBuffer toBin(int x) {
        StringBuffer result = new StringBuffer();
        result.append(x % 2);
        x /= 2;
        while (x > 0) {
            result.append(x % 2);
            x /= 2;
        }
        return result;
    }
}

