/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.rmi;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.rmi.AticRmiService;
import com.huawei.atic.util.CertFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

public class AticRmiServiceRegisterUtil {
    public static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final String CONFIG_FILE = "/collector.conf";
    private static AtomicInteger initCount = new AtomicInteger(0);
    private ClientSocketFactory clientSocketFactory = null;
    private ServerSocketFactory serverSocketFactory = null;
    private int aticRmiListenPort = 11098;
    private int aticRmiServicePort = 33098;
    private String aticRmiServiceIp = "127.0.0.1";
    private Registry registry = null;
    private List<AticRmiService<?>> allAticRmiService = new ArrayList();

    private AticRmiServiceRegisterUtil() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        int initC = initCount.incrementAndGet();
        if (initC > 1) {
            LOG.warn((Object)("AticRmiServiceRegisterUtil has inited more than once!(count=" + initC + ")"));
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = AticUtil.class.getResourceAsStream(CONFIG_FILE);
            String localPort = AticUtil.getPropertyValue(inputStream, "AticRmiPort");
            this.aticRmiListenPort = Integer.parseInt(localPort);
            inputStream = AticUtil.class.getResourceAsStream(CONFIG_FILE);
            String localServicePort = AticUtil.getPropertyValue(inputStream, "AticRmiServicePort");
            this.aticRmiServicePort = Integer.parseInt(localServicePort);
            if (null != System.getProperty("nms.server.host")) {
                this.aticRmiServiceIp = System.getProperty("nms.server.host");
            }
            System.setProperty("java.rmi.server.hostname", this.aticRmiServiceIp);
            LOG.info((Object)("Bind Rmi Server on port: " + this.aticRmiListenPort));
            LOG.info((Object)("Bind Rmi Server on ip: " + this.aticRmiServiceIp));
            this.setSSLSystemProperties();
            this.clientSocketFactory = new ClientSocketFactory(true);
            this.serverSocketFactory = new ServerSocketFactory(this.aticRmiServiceIp, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"}, new String[]{"TLSv1.2"}, true);
            this.registry = LocateRegistry.createRegistry(this.aticRmiListenPort, this.clientSocketFactory, this.serverSocketFactory);
        }
        catch (RemoteException e) {
            LOG.error((Object)"publishRmiService error ", (Throwable)e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"publishRmiService error ", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"inputStream.close() error");
                }
            }
        }
    }

    private void setSSLSystemProperties() {
        String certPath = CertFileUtil.getInstance().getCertPath();
        Properties properties = CertFileUtil.getInstance().loadLegoCertInfoProperties(certPath);
        System.setProperty("javax.net.ssl.keyStore", properties.getProperty("keystore.mc.path", certPath + File.separator + "mc_keystore"));
        System.setProperty("javax.net.ssl.keyStorePassword", DataProtectServiceConst.sdpDecryptInitDataBuffer((String)properties.getProperty("keystore.mc.password")).toString());
        System.setProperty("javax.net.ssl.trustStore", properties.getProperty("truststore.mc.path", certPath + File.separator + "mc_truststore"));
        System.setProperty("javax.net.ssl.trustStorePassword", DataProtectServiceConst.sdpDecryptInitDataBuffer((String)properties.getProperty("truststore.mc.password")).toString());
    }

    public static AticRmiServiceRegisterUtil getInstance() {
        return RMIServiceRegisterUtilHolder.rmiServiceRegisterUtil;
    }

    public ClientSocketFactory getClientSocketFactory() {
        return new ClientSocketFactory(true);
    }

    public ServerSocketFactory getServerSocketFactory() {
        return new ServerSocketFactory(this.aticRmiServiceIp, new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256"}, new String[]{"TLSv1.2"}, true);
    }

    public int getAticRmiServicePort() {
        return this.aticRmiServicePort;
    }

    public String getAticRmiServiceIp() {
        return this.aticRmiServiceIp;
    }

    public void publishAllRmiService() {
        for (AticRmiService<?> service : this.allAticRmiService) {
            try {
                service.register(this.registry);
                LOG.info((Object)(" registry.bind " + service.getServiceName() + " successfully!"));
            }
            catch (Exception e) {
                LOG.error((Object)("registry rmi service " + service.getServiceName() + " error"), (Throwable)e);
            }
        }
    }

    public void addService(AticRmiService<?> service) {
        this.allAticRmiService.add(service);
    }

    private static class RMIServiceRegisterUtilHolder {
        private static AticRmiServiceRegisterUtil rmiServiceRegisterUtil = new AticRmiServiceRegisterUtil();

        private RMIServiceRegisterUtilHolder() {
        }
    }
}

