/*
 * Decompiled with CFR 0.152.
 */
package com.restful.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class JSONUtil {
    private static JSONUtil instance = new JSONUtil();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public static JSONUtil getInstance() {
        return instance;
    }

    public String toJSON(Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, obj);
        }
        catch (JsonGenerationException e) {
            throw new JsonGenerationException(e.toString(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            throw new JsonMappingException(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new IOException(e.toString(), e);
        }
        return writer.toString();
    }

    public String toJSONString(Object obj) {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, obj);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return writer.toString();
    }

    public <T> T fromJSON(String json, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (JsonParseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JsonMappingException(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.toString(), e);
        }
    }

    public <T> T fromJSON(String json, TypeReference<T> type) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (JsonParseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new JsonMappingException(e.toString(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.toString(), e);
        }
    }
}

