/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.HashMap;
import java.util.Map;
import twaver.AlarmSeverity;
import twaver.IElement;
import twaver.Utils;

public class AlarmState {
    private IElement element = null;
    private Map<AlarmSeverity, Integer> newAlarms = new HashMap<AlarmSeverity, Integer>();
    private Map<AlarmSeverity, Integer> ackAlarms = new HashMap<AlarmSeverity, Integer>();
    private AlarmSeverity propagateSeverity = null;
    private AlarmSeverity highestAcknowledgedAlarmSeverity = null;
    private AlarmSeverity highestNewAlarmSeverity = null;
    private AlarmSeverity highestOverallAlarmSeverity = null;
    private AlarmSeverity highestNativeAlarmSeverity = null;
    private boolean hasLessSevereNewAlarms = false;
    private int acknowledgedAlarmCount = 0;
    private int newAlarmCount = 0;
    private boolean isEnablePropagation = true;

    public AlarmState(IElement element) {
        this.element = element;
    }

    private void dispatchAlarmStateChangeEvent() {
        this.calculateHighestAcknowledgedAlarmSeverity();
        this.calculateHighestNewAlarmSeverity();
        this.calculateHasLessSevereNewAlarms();
        this.calculateHighestOverallAlarmSeverity();
        this.calculateHighestNativeAlarmSeverity();
        this.calculateAcknowledgedAlarmCount();
        this.calculateNewAlarmCount();
        this.element.dispatchPropertyChangeEvent("alarmState", null, this);
    }

    private void calculateHighestAcknowledgedAlarmSeverity() {
        AlarmSeverity result = null;
        for (AlarmSeverity severity : this.ackAlarms.keySet()) {
            if (AlarmSeverity.isClearedAlarmSeverity(severity) || this.getAcknowledgedAlarmCount(severity) == 0) continue;
            if (result == null) {
                result = severity;
                continue;
            }
            result = AlarmSeverity.compare(result, severity) > 0 ? result : severity;
        }
        this.highestAcknowledgedAlarmSeverity = result;
    }

    public AlarmSeverity getHighestAcknowledgedAlarmSeverity() {
        return this.highestAcknowledgedAlarmSeverity;
    }

    private void calculateHighestNewAlarmSeverity() {
        AlarmSeverity result = null;
        for (AlarmSeverity severity : this.newAlarms.keySet()) {
            if (AlarmSeverity.isClearedAlarmSeverity(severity) || this.getNewAlarmCount(severity) == 0) continue;
            if (result == null) {
                result = severity;
                continue;
            }
            result = AlarmSeverity.compare(result, severity) > 0 ? result : severity;
        }
        this.highestNewAlarmSeverity = result;
    }

    public AlarmSeverity getHighestNewAlarmSeverity() {
        return this.highestNewAlarmSeverity;
    }

    private void calculateHasLessSevereNewAlarms() {
        if (this.highestNewAlarmSeverity == null) {
            this.hasLessSevereNewAlarms = false;
            return;
        }
        for (AlarmSeverity severity : this.newAlarms.keySet()) {
            if (AlarmSeverity.isClearedAlarmSeverity(severity) || this.getNewAlarmCount(severity) == 0 || AlarmSeverity.compare(this.highestNewAlarmSeverity, severity) <= 0) continue;
            this.hasLessSevereNewAlarms = true;
            return;
        }
        this.hasLessSevereNewAlarms = false;
    }

    public boolean hasLessSevereNewAlarms() {
        return this.hasLessSevereNewAlarms;
    }

    private void calculateHighestOverallAlarmSeverity() {
        AlarmSeverity ackResult = this.highestAcknowledgedAlarmSeverity;
        AlarmSeverity newResult = this.highestNewAlarmSeverity;
        AlarmSeverity propagatedResult = this.propagateSeverity;
        this.highestOverallAlarmSeverity = ackResult;
        if (AlarmSeverity.compare(newResult, this.highestOverallAlarmSeverity) > 0) {
            this.highestOverallAlarmSeverity = newResult;
        }
        if (AlarmSeverity.compare(propagatedResult, this.highestOverallAlarmSeverity) > 0) {
            this.highestOverallAlarmSeverity = propagatedResult;
        }
    }

    public AlarmSeverity getHighestOverallAlarmSeverity() {
        return this.highestOverallAlarmSeverity;
    }

    private void calculateHighestNativeAlarmSeverity() {
        AlarmSeverity ackResult = this.highestAcknowledgedAlarmSeverity;
        AlarmSeverity newResult = this.highestNewAlarmSeverity;
        this.highestNativeAlarmSeverity = ackResult;
        if (AlarmSeverity.compare(newResult, this.highestNativeAlarmSeverity) > 0) {
            this.highestNativeAlarmSeverity = newResult;
        }
    }

    public AlarmSeverity getHighestNativeAlarmSeverity() {
        return this.highestNativeAlarmSeverity;
    }

    public void increaseAcknowledgedAlarm(AlarmSeverity severity) {
        this.increaseAcknowledgedAlarm(severity, 1);
    }

    public void increaseAcknowledgedAlarm(AlarmSeverity severity, int increment) {
        if (increment <= 0) {
            return;
        }
        int count = this.getAcknowledgedAlarmCount(severity);
        this.ackAlarms.put(severity, Utils.valueOf(count += increment));
        this.dispatchAlarmStateChangeEvent();
    }

    public void increaseNewAlarm(AlarmSeverity severity) {
        this.increaseNewAlarm(severity, 1);
    }

    public void increaseNewAlarm(AlarmSeverity severity, int increment) {
        int count = this.getNewAlarmCount(severity);
        this.newAlarms.put(severity, Utils.valueOf(count += increment));
        this.dispatchAlarmStateChangeEvent();
    }

    public void decreaseAcknowledgedAlarm(AlarmSeverity severity) {
        this.decreaseAcknowledgedAlarm(severity, 1);
    }

    public void decreaseAcknowledgedAlarm(AlarmSeverity severity, int decrement) {
        int count = this.getAcknowledgedAlarmCount(severity);
        if ((count -= decrement) < 0) {
            throw new IllegalArgumentException("Alarm count can not be negative");
        }
        this.ackAlarms.put(severity, Utils.valueOf(count));
        this.dispatchAlarmStateChangeEvent();
    }

    public void decreaseNewAlarm(AlarmSeverity severity) {
        this.decreaseNewAlarm(severity, 1);
    }

    public void decreaseNewAlarm(AlarmSeverity severity, int decrement) {
        if (decrement == 0) {
            return;
        }
        int count = this.getNewAlarmCount(severity);
        if ((count -= decrement) < 0) {
            throw new IllegalArgumentException("Alarm count can not be negative");
        }
        this.newAlarms.put(severity, Utils.valueOf(count));
        this.dispatchAlarmStateChangeEvent();
    }

    public void acknowledgeAlarm(AlarmSeverity severity) {
        this.decreaseNewAlarm(severity, 1);
        this.increaseAcknowledgedAlarm(severity, 1);
    }

    public void acknowledgeAllAlarms() {
        for (AlarmSeverity severity : this.newAlarms.keySet()) {
            this.acknowledgeAllAlarms(severity);
        }
    }

    public void acknowledgeAllAlarms(AlarmSeverity severity) {
        int count = this.getNewAlarmCount(severity);
        this.decreaseNewAlarm(severity, count);
        this.increaseAcknowledgedAlarm(severity, count);
    }

    private void calculateAcknowledgedAlarmCount() {
        this.acknowledgedAlarmCount = 0;
        for (AlarmSeverity severity : this.ackAlarms.keySet()) {
            this.acknowledgedAlarmCount += this.getAcknowledgedAlarmCount(severity);
        }
    }

    public int getAcknowledgedAlarmCount() {
        return this.acknowledgedAlarmCount;
    }

    public int getAcknowledgedAlarmCount(AlarmSeverity severity) {
        Integer count = this.ackAlarms.get(severity);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public int getAlarmCount() {
        return this.getAcknowledgedAlarmCount() + this.getNewAlarmCount();
    }

    public int getAlarmCount(AlarmSeverity severity) {
        return this.getAcknowledgedAlarmCount(severity) + this.getNewAlarmCount(severity);
    }

    private void calculateNewAlarmCount() {
        this.newAlarmCount = 0;
        for (AlarmSeverity severity : this.newAlarms.keySet()) {
            this.newAlarmCount += this.getNewAlarmCount(severity);
        }
    }

    public int getNewAlarmCount() {
        return this.newAlarmCount;
    }

    public int getNewAlarmCount(AlarmSeverity severity) {
        Integer count = this.newAlarms.get(severity);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public void setNewAlarmCount(AlarmSeverity severity, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Alarm count can not be negative");
        }
        this.newAlarms.put(severity, Utils.valueOf(count));
        this.dispatchAlarmStateChangeEvent();
    }

    public void removeAllNewAlarms() {
        this.newAlarms.clear();
        this.dispatchAlarmStateChangeEvent();
    }

    public void removeAllNewAlarms(AlarmSeverity severity) {
        this.newAlarms.remove(severity);
        this.dispatchAlarmStateChangeEvent();
    }

    public void setAcknowledgedAlarmCount(AlarmSeverity severity, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Alarm count can not be negative");
        }
        this.ackAlarms.put(severity, Utils.valueOf(count));
        this.dispatchAlarmStateChangeEvent();
    }

    public void removeAllAcknowledgedAlarms() {
        this.ackAlarms.clear();
        this.dispatchAlarmStateChangeEvent();
    }

    public void removeAllAcknowledgedAlarms(AlarmSeverity severity) {
        this.ackAlarms.remove(severity);
        this.dispatchAlarmStateChangeEvent();
    }

    public boolean isEmpty() {
        return this.highestOverallAlarmSeverity == null;
    }

    public void clear() {
        this.newAlarms.clear();
        this.ackAlarms.clear();
        this.dispatchAlarmStateChangeEvent();
    }

    public AlarmSeverity getPropagateSeverity() {
        return this.propagateSeverity;
    }

    public void setPropagateSeverity(AlarmSeverity value) {
        if (!this.isEnablePropagation) {
            value = null;
        }
        if (this.propagateSeverity == value) {
            return;
        }
        AlarmSeverity oldValue = this.propagateSeverity;
        this.propagateSeverity = value;
        this.dispatchAlarmStateChangeEvent();
        this.element.dispatchPropertyChangeEvent("propagateSeverity", oldValue, value);
    }

    public boolean isEnablePropagation() {
        return this.isEnablePropagation;
    }

    public void setEnablePropagation(boolean value) {
        if (this.isEnablePropagation == value) {
            return;
        }
        boolean oldValue = this.isEnablePropagation;
        this.isEnablePropagation = value;
        this.element.dispatchPropertyChangeEvent("enablePropagation", oldValue, value);
        if (!this.isEnablePropagation) {
            this.propagateSeverity = null;
        }
    }
}

