/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import twaver.ShapeNode;
import twaver.Utils;

public class Bus
extends ShapeNode {
    public Bus() {
        this(null);
    }

    public Bus(Object id) {
        super(id);
        this.setIcon("bus_icon");
        this.setStyle("vector.fill", Boolean.FALSE);
        this.setStyle("shapenode.closed", Boolean.FALSE);
    }

    @Override
    public void dispatchPointsChangeEvent() {
        int count = this.points.size();
        if (!Utils.isDeserializingXML() && count >= 2) {
            Point2D lastPoint = (Point2D)this.points.get(0);
            for (int i = 1; i < count; ++i) {
                Point2D point = (Point2D)this.points.get(i);
                if (Math.abs(point.getX() - lastPoint.getX()) > Math.abs(point.getY() - lastPoint.getY())) {
                    point.setLocation(point.getX(), lastPoint.getY());
                } else {
                    point.setLocation(lastPoint.getX(), point.getY());
                }
                lastPoint = point;
            }
        }
        super.dispatchPointsChangeEvent();
    }
}

