/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twaver.Follower;
import twaver.IClient;
import twaver.IData;
import twaver.Link;
import twaver.Node;
import twaver.Styles;
import twaver.XMLSerializer;

public class DataBox
implements IClient {
    private String name = null;
    private String toolTip = null;
    private String icon = "databox_icon";
    private List<IData> dataList;
    private Map<Object, IData> dataMap;
    private List<IData> rootList;
    private Map<Object, IData> rootMap;
    private Map<String, Object> clientMap;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public DataBox() {
        this("DataBox");
    }

    public DataBox(String name) {
        this.name = name;
        this.dataList = new ArrayList<IData>();
        this.dataMap = new HashMap<Object, IData>();
        this.rootList = new ArrayList<IData>();
        this.rootMap = new HashMap<Object, IData>();
    }

    @Override
    public void setClient(String clientProp, Object newValue) {
        if (clientProp == null) {
            throw new NullPointerException("clientProp");
        }
        if (this.clientMap == null) {
            this.clientMap = new HashMap<String, Object>();
        }
        if (newValue == null) {
            this.clientMap.remove(clientProp);
        } else {
            this.clientMap.put(clientProp, newValue);
        }
    }

    @Override
    public Object getClient(String clientProp) {
        if (this.clientMap == null) {
            return null;
        }
        return this.clientMap.get(clientProp);
    }

    public Map<String, Object> getClientProperties() {
        return this.clientMap;
    }

    public int getCount() {
        return this.dataList.size();
    }

    public boolean isEmpty() {
        return this.dataList.size() == 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public List<IData> getRoots() {
        int size = this.getCount();
        ArrayList<IData> list = new ArrayList<IData>();
        for (int i = 0; i < size; ++i) {
            IData data = this.dataList.get(i);
            if (data.getParent() != null) continue;
            list.add(data);
        }
        return list;
    }

    public List<IData> getSiblings(IData data) {
        IData parent;
        if (!this.contains(data)) {
            this.log.error((Object)" dosen't belong to this dataBox");
        }
        if ((parent = data.getParent()) == null) {
            return this.rootList;
        }
        return parent.getChildren();
    }

    public List<?> getDatas() {
        return this.dataList;
    }

    public List<IData> toDatas() {
        return new ArrayList<IData>(this.dataList);
    }

    public void add(IData data) {
        this.add(data, -1);
    }

    public void add(IData data, int index) {
        if (data == null) {
            throw new IllegalArgumentException("Data can not be null");
        }
        if (this.dataMap.containsKey(data.getID())) {
            throw new IllegalArgumentException("Data with ID '" + data.getID() + "' already exists");
        }
        this.dataMap.put(data.getID(), data);
        this.dataList.add(data);
        if (data.getParent() == null) {
            this.rootMap.put(data.getID(), data);
            this.rootList.add(data);
        }
    }

    public void remove(IData data) {
        if (data != null) {
            this.removeByID(data.getID());
        }
    }

    public void removeByID(Object id) {
        IData data = this.getDataByID(id);
        if (data == null) {
            return;
        }
        if (data instanceof Link) {
            Link link = (Link)data;
            link.setFromNode(null);
            link.setToNode(null);
        }
        if (data instanceof Node) {
            ArrayList followers;
            Node node = (Node)data;
            ArrayList links = node.getLinks();
            if (links != null) {
                links = new ArrayList(links);
                int size = links.size();
                for (int i = 0; i < size; ++i) {
                    Link link = (Link)links.get(i);
                    this.removeByID(link.getID());
                }
            }
            if ((followers = node.getFollowers()) != null) {
                followers = new ArrayList(followers);
                int size = followers.size();
                for (int i = 0; i < size; ++i) {
                    Follower follower = (Follower)followers.get(i);
                    follower.setHost(null);
                }
            }
        }
        if (data.hasChildren()) {
            List children = data.toChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                IData child = (IData)children.get(i);
                this.removeByID(child.getID());
            }
        }
        if (data.getParent() != null) {
            data.getParent().removeChild(data);
        }
        this.dataList.remove(data);
        this.dataMap.remove(data.getID());
        if (this.rootMap.containsKey(data.getID())) {
            this.rootMap.remove(data.getID());
            this.rootList.remove(data);
        }
    }

    public IData getDataByID(Object id) {
        return this.dataMap.get(id);
    }

    public void clear() {
        if (this.dataList.size() == 0) {
            return;
        }
        this.dataList.clear();
        this.dataMap.clear();
        this.rootList.clear();
        this.rootMap.clear();
    }

    public boolean contains(IData data) {
        if (data == null) {
            return false;
        }
        return data == this.dataMap.get(data.getID());
    }

    public boolean containsByID(Object id) {
        return this.dataMap.containsKey(id);
    }

    public int getSiblingIndex(IData data) {
        if (data.getParent() == null) {
            return this.rootList.indexOf(data);
        }
        return data.getParent().getChildren().indexOf(data);
    }

    public void moveToBottom(IData data) {
        if (data.getParent() == null) {
            this.moveTo(data, this.rootList.size());
        } else {
            this.moveTo(data, data.getParent().getChildrenCount());
        }
    }

    public void moveTo(IData data, int newIndex) {
        if (!this.contains(data)) {
            throw new IllegalArgumentException(data + " dosen't belong to this dataBox");
        }
        int oldIndex = this.getSiblingIndex(data);
        if (oldIndex == newIndex || oldIndex < 0 || newIndex < 0) {
            return;
        }
        if (data.getParent() == null) {
            if (newIndex <= this.rootList.size()) {
                this.rootList.remove(data);
                if (newIndex > this.rootList.size()) {
                    --newIndex;
                }
                this.rootList.add(newIndex, data);
            }
        } else if (newIndex <= data.getParent().getChildrenCount()) {
            data.getParent().getChildren().remove(data);
            if (newIndex > data.getParent().getChildrenCount()) {
                --newIndex;
            }
            data.getParent().getChildren().add(newIndex, data);
        }
    }

    private void serializeBoxXML(XMLSerializer xmlSerializer, DataBox newInstance) {
        if (this.clientMap != null) {
            for (Map.Entry<String, Object> entry : this.clientMap.entrySet()) {
                this.serializeClient(xmlSerializer, entry.getKey().toString(), newInstance);
            }
        }
        this.serializeProperty(xmlSerializer, "name", newInstance);
        this.serializeProperty(xmlSerializer, "icon", newInstance);
        this.serializeProperty(xmlSerializer, "toolTip", newInstance);
    }

    public void serializeXML(XMLSerializer serializer, DataBox newInstance) {
        this.serializeBoxXML(serializer, newInstance);
    }

    public void serializeCommonXML(XMLSerializer serializer, DataBox newInstance) {
        this.serializeBoxXML(serializer, newInstance);
    }

    protected void serializeProperty(XMLSerializer serializer, String property, DataBox newInstance) {
        serializer.serializeProperty(this, property, newInstance);
    }

    protected void serializeClient(XMLSerializer serializer, String clientPrope, DataBox newInstance) {
        serializer.serializeClient(this, clientPrope, newInstance);
    }

    public void deserializeXML(XMLSerializer serializer, String prefix, String prop, org.w3c.dom.Node pNode) {
        if (prefix.equals("p")) {
            this.deserializeProperty(serializer, prop, pNode);
        } else {
            if (!prefix.equals("c")) {
                return;
            }
            this.deserializeClient(serializer, prop, pNode);
        }
    }

    protected void deserializeClient(XMLSerializer serializer, String prop, org.w3c.dom.Node pNode) {
        serializer.deserializeClient(this, prop, pNode);
    }

    protected void deserializeProperty(XMLSerializer serializer, String prop, org.w3c.dom.Node pNode) {
        serializer.deserializeProperty(this, prop, pNode);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    static {
        Styles.initStyleMap();
    }
}

